/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTable;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTableModel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.PatternTableModelItem;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.service.AttributeService;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class PatternModuleTabPanelItemFactory
implements PatternModuleTabPanel.PatternModuleTabPanelItemFactory {
    private static final String ELEMENT_NAME_BILL = "bill";
    private BillService billService = null;
    private ClientContext clientContext = null;
    private AttributeService attributeService = null;

    public Collection<PatternModuleTabPanel.PatternModuleTabPanelItem> getPatternModuleTabPanelItems(int moduleId, String moduleTitle) {
        this.clientContext = new ClientContext(ELEMENT_NAME_BILL, moduleId, -1, -1, AddDefaultAccountTabPanel.class.getPackage());
        LinkedHashSet<PatternModuleTabPanel.PatternModuleTabPanelItem> items = new LinkedHashSet<PatternModuleTabPanel.PatternModuleTabPanelItem>();
        items.add(new AddDocumentTypeTabPanel(moduleId, moduleTitle));
        items.add(new AddDetailsTabPanel(moduleId, moduleTitle));
        items.add(new AddDefaultAccountTabPanel(moduleId, moduleTitle));
        return items;
    }

    private BillService getBillService() {
        if (this.billService == null) {
            this.billService = (BillService)this.clientContext.getPort(BillService.class);
        }
        return this.billService;
    }

    private AttributeService getAttributeService() {
        if (this.attributeService == null) {
            this.attributeService = (AttributeService)this.clientContext.getPort(AttributeService.class);
        }
        return this.attributeService;
    }

    private class AddDefaultAccountTabPanel
    extends PatternModuleTabPanel.PatternModuleTabPanelItem {
        private static final String KEY_ORGANIZATION_ID = "organizationId";
        private static final String KEY_BANK_ACCOUNT_ID = "bankAccountId";
        private String title;
        private PatternTable organizationTable;
        private PatternTableModel organizationTableModel;
        private PatternTable bankAccountTable;
        private PatternTableModel bankAccountTableModel;

        private AddDefaultAccountTabPanel(int moduleId, String title) {
            super((LayoutManager)new GridBagLayout(), moduleId);
            this.title = "\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f, \u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442";
            this.organizationTable = null;
            this.organizationTableModel = null;
            this.bankAccountTable = null;
            this.bankAccountTableModel = null;
            this.organizationTableModel = new PatternTableModel(AddDefaultAccountTabPanel.class.getName());
            this.organizationTable = new PatternTable((BGTableModel)this.organizationTableModel);
            this.organizationTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        AddDefaultAccountTabPanel.this.setBankAccountData(AddDefaultAccountTabPanel.this.organizationTable.getSelectedId());
                    }
                }
            });
            this.bankAccountTableModel = new PatternTableModel(AddDefaultAccountTabPanel.class.getName());
            this.bankAccountTable = new PatternTable((BGTableModel)this.bankAccountTableModel);
            Dimension dimension = new Dimension(200, 300);
            JScrollPane scrollPane = new JScrollPane((Component)this.organizationTable);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            int gridy = 0;
            this.add(new JLabel("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f"), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 5, 3, 0), 0, 0));
            this.add(scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(new JLabel("\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442"), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 5, 3, 0), 0, 0));
            this.add(new JScrollPane((Component)this.bankAccountTable), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        protected void init() {
            try {
                List organizations = PatternModuleTabPanelItemFactory.this.getBillService().getOrganizationList();
                ArrayList<PatternTableModelItem> items = new ArrayList<PatternTableModelItem>();
                organizations.stream().forEach(o -> items.add(new PatternTableModelItem(new IdTitle(o.getId(), o.getTitle()))));
                items.add(0, new PatternTableModelItem(new IdTitle(0, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e")));
                this.organizationTableModel.setData(items);
            }
            catch (BGException ex) {
                ex.printStackTrace();
            }
        }

        private void setBankAccountData(int organizationId) {
            try {
                ArrayList<PatternTableModelItem> items = new ArrayList<PatternTableModelItem>();
                if (organizationId > 0) {
                    List accounts = PatternModuleTabPanelItemFactory.this.getBillService().getBankAccountList(organizationId, null);
                    for (BankAccount bankAccount : accounts) {
                        IdTitle idTitle = new IdTitle(bankAccount.getId(), bankAccount.getTitle() + (bankAccount.isInUse() ? "" : " (\u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f)"));
                        items.add(new PatternTableModelItem(idTitle));
                    }
                }
                items.add(0, new PatternTableModelItem(new IdTitle(0, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e")));
                items.add(0, new PatternTableModelItem(new IdTitle(-1, "\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438")));
                this.bankAccountTableModel.setData(items);
                BankAccount bankAccount = PatternModuleTabPanelItemFactory.this.getBillService().getDefaultBankAccount(organizationId);
                this.bankAccountTable.setSelected(bankAccount == null ? 0 : bankAccount.getId());
            }
            catch (BGException ex) {
                ex.printStackTrace();
            }
        }

        protected boolean isItemEnabled() {
            return false;
        }

        protected void setData(Element element) {
            int organizationId = 0;
            int bankAccountId = 0;
            Element billElement = XMLUtils.selectElement((Node)element, (String)("data/modules/bill[@mid=" + this.getModuleId() + "]"));
            if (billElement != null) {
                organizationId = Utils.parseInt((String)billElement.getAttribute(KEY_ORGANIZATION_ID), (int)0);
                bankAccountId = Utils.parseInt((String)billElement.getAttribute(KEY_BANK_ACCOUNT_ID), (int)0);
            }
            this.organizationTable.setSelected(organizationId);
            this.setBankAccountData(organizationId);
            boolean selected = false;
            for (PatternTableModelItem item : this.bankAccountTableModel.getRows()) {
                selected = item.getId() == bankAccountId;
                if (!selected) continue;
                this.bankAccountTable.setSelected(item.getId());
                break;
            }
            if (!selected) {
                this.bankAccountTable.setSelected(0);
            }
        }

        protected void reset() {
            this.organizationTable.setSelected(0);
            this.bankAccountTable.setSelected(0);
        }

        protected void serialise(Element element) {
            Element module = XMLUtils.selectElement((Node)element, (String)PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            if (module == null) {
                module = XMLUtils.createElement((Element)element, (String)PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            }
            module.setAttribute(KEY_BANK_ACCOUNT_ID, String.valueOf(this.bankAccountTable.getSelectedId()));
            module.setAttribute(KEY_ORGANIZATION_ID, String.valueOf(this.organizationTable.getSelectedId()));
        }

        public String getTitle() {
            return this.title;
        }
    }

    private class AddDocumentTypeTabPanel
    extends PatternModuleTabPanel.PatternModuleTabPanelItem {
        private BGControlPanelListSelect bills;
        private BGControlPanelListSelect invoices;
        private String title;

        private AddDocumentTypeTabPanel(int moduleId, String title) {
            super((LayoutManager)new GridBagLayout(), moduleId);
            this.bills = new BGControlPanelListSelect();
            this.invoices = new BGControlPanelListSelect();
            this.title = null;
            this.setTitle(" \u0421\u0447\u0435\u0442\u0430, \u0421\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0410\u043a\u0442\u044b, \u0423\u041f\u0414 (\u0442\u0438\u043f\u044b) ");
            this.bills.setBorder((Border)new BGTitleBorder(" \u0421\u0447\u0435\u0442\u0430 "));
            this.invoices.setBorder((Border)new BGTitleBorder(" \u0421\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0410\u043a\u0442\u044b, \u0423\u041f\u0414 "));
            this.bills.setMinimumSize(new Dimension(180, 200));
            this.bills.setPreferredSize(new Dimension(180, 200));
            this.add((Component)this.bills, new GridBagConstraints(1, 0, 1, 3, 0.4, 1.0, 14, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.invoices.setMinimumSize(new Dimension(180, 200));
            this.invoices.setPreferredSize(new Dimension(180, 200));
            this.add((Component)this.invoices, new GridBagConstraints(2, 0, 1, 3, 0.4, 1.0, 14, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        protected boolean isItemEnabled() {
            return false;
        }

        protected void init() {
            Request request = new Request();
            request.setModule(PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            request.setModuleId(this.getModuleId());
            request.setAction("DocTypeList");
            request.setAttribute("type", PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            Document doc = this.getDocument(request);
            if (this.checkStatus(doc)) {
                ClientUtils.buildList((JList)this.bills.getList(), (DefaultListModel)this.bills.getListModel(), (Node)XMLUtils.selectElement((Node)doc, (String)"//list_avaliable"));
            }
            request = new Request();
            request.setModule(PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            request.setModuleId(this.getModuleId());
            request.setAction("DocTypeList");
            request.setAttribute("type", "invoice");
            doc = this.getDocument(request);
            if (this.checkStatus(doc)) {
                ClientUtils.buildList((JList)this.invoices.getList(), (DefaultListModel)this.invoices.getListModel(), (Node)XMLUtils.selectElement((Node)doc, (String)"//list_avaliable"));
            }
        }

        protected void reset() {
            this.bills.setListItemSelected(false);
            this.invoices.setListItemSelected(false);
        }

        protected void serialise(Element element) {
            Element addDocumentType;
            String bills = this.bills.getListValues();
            String invoices = this.invoices.getListValues();
            Element module = XMLUtils.selectElement((Node)element, (String)PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            if (module == null) {
                module = XMLUtils.createElement((Element)element, (String)PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
            }
            module.setAttribute("mid", String.valueOf(this.getModuleId()));
            Element addDocuments = XMLUtils.createElement((Element)module, (String)"addDocuments");
            if (Utils.notEmptyString((String)bills) || Utils.notEmptyString((String)invoices)) {
                addDocuments.setAttribute("enable", "1");
            } else {
                addDocuments.setAttribute("enable", "0");
            }
            if (Utils.notEmptyString((String)bills)) {
                addDocumentType = XMLUtils.createElement((Element)addDocuments, (String)"addDocumentType");
                addDocumentType.setAttribute("type", PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL);
                addDocumentType.setAttribute("docTypes", bills);
            }
            if (Utils.notEmptyString((String)invoices)) {
                addDocumentType = XMLUtils.createElement((Element)addDocuments, (String)"addDocumentType");
                addDocumentType.setAttribute("type", "invoice");
                addDocumentType.setAttribute("docTypes", invoices);
            }
        }

        protected void setData(Element element) {
            Element addDocuments = XMLUtils.selectElement((Node)element, (String)("data/modules/bill[@mid=" + this.getModuleId() + "]/addDocuments"));
            this.bills.setListItemSelected(false);
            this.invoices.setListItemSelected(false);
            if (addDocuments != null) {
                for (Element addDocumentType : XMLUtils.selectElements((Node)addDocuments, (String)"addDocumentType")) {
                    if (PatternModuleTabPanelItemFactory.ELEMENT_NAME_BILL.equals(addDocumentType.getAttribute("type"))) {
                        this.bills.setListValues(addDocumentType.getAttribute("docTypes"));
                        continue;
                    }
                    if (!"invoice".equals(addDocumentType.getAttribute("type"))) continue;
                    this.invoices.setListValues(addDocumentType.getAttribute("docTypes"));
                }
            }
        }
    }

    private class AddDetailsTabPanel
    extends PatternModuleTabPanel.PatternModuleTabPanelItem {
        private String title;
        private List<AttributeType> attributeTypes;
        private DetailsTableModel detailsTableModel;

        private AddDetailsTabPanel(int moduleId, String title) {
            super((LayoutManager)new GridBagLayout(), moduleId);
            this.title = "\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b";
            this.attributeTypes = null;
            this.detailsTableModel = new DetailsTableModel();
            BGUTable table = new BGUTable((TableModel)((Object)this.detailsTableModel));
            table.setSelectionMode(0);
            BGDialogToolBar toolBar = new BGDialogToolBar();
            toolBar.setDefaultButtons(e -> {
                Element element;
                if ("newItem".equals(e.getActionCommand())) {
                    DefaultListModel listModel = new DefaultListModel();
                    this.attributeTypes.forEach(t -> {
                        for (Element element : this.detailsTableModel.getRows()) {
                            if (!element.getAttribute("typeId").equals(String.valueOf(t.getId()))) continue;
                            return;
                        }
                        listModel.addElement(new IdTitle(t.getId(), t.getTitle()));
                    });
                    JList list = new JList(listModel);
                    list.setSelectionMode(0);
                    Dimension dimension = new Dimension(500, 300);
                    JScrollPane scrollPane = new JScrollPane(list);
                    scrollPane.setMinimumSize(dimension);
                    scrollPane.setPreferredSize(dimension);
                    JOptionPane.showMessageDialog((Component)BGClientBase.getFrame(), scrollPane, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442", -1);
                    IdTitle idTitle = (IdTitle)list.getSelectedValue();
                    if (idTitle != null) {
                        Element element2 = XMLUtils.createElement((Document)XMLUtils.newDocument(), (String)"item");
                        element2.setAttribute("typeId", String.valueOf(idTitle.getId()));
                        element2.setAttribute("name", idTitle.getTitle());
                        element2.setAttribute("type", "1");
                        element2.setAttribute("value", "");
                        this.detailsTableModel.addRow(element2);
                        this.editItem(element2);
                    }
                } else if ("editItem".equals(e.getActionCommand())) {
                    Element element3 = (Element)this.detailsTableModel.getSelectedRow();
                    if (element3 != null) {
                        this.editItem(element3);
                    }
                } else if ("deleteItem".equals(e.getActionCommand()) && (element = (Element)this.detailsTableModel.getSelectedRow()) != null && ClientUtils.confirmDelete((Object)element.getAttribute("name"))) {
                    this.detailsTableModel.deleteRow(element);
                }
            });
            toolBar.setToolBar(Arrays.asList("newItem", "editItem", "deleteItem"));
            toolBar.setFloatable(false);
            this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        }

        private void editItem(Element element) {
            JTextField rekv = new JTextField(element.getAttribute("name"), 50);
            Color bgColor = rekv.getBackground();
            rekv.setEditable(false);
            rekv.setBackground(bgColor);
            JTextField rekvConstValue = new JTextField();
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton typeConst = new JRadioButton("\u0442\u0438\u043f \u041a\u041e\u041d\u0421\u0422\u0410\u041d\u0422\u0410", "1".equals(element.getAttribute("type")));
            buttonGroup.add(typeConst);
            JList parameterList = new JList();
            JRadioButton typeParameter = new JRadioButton("\u0442\u0438\u043f \u041f\u0410\u0420\u0410\u041c\u0415\u0422\u0420 \u0414\u041e\u0413\u041e\u0412\u041e\u0420\u0410", "2".equals(element.getAttribute("type")));
            buttonGroup.add(typeParameter);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            panel.add((Component)rekv, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
            panel.add((Component)typeConst, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            panel.add((Component)rekvConstValue, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
            panel.add((Component)typeParameter, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(parameterList), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 0, 0), 0, 0));
            JOptionPane.showMessageDialog((Component)BGClientBase.getFrame(), panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430", -1);
            this.detailsTableModel.fireTableDataChanged();
        }

        protected void init() {
            try {
                this.attributeTypes = PatternModuleTabPanelItemFactory.this.getAttributeService().attributeTypeList();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        protected boolean isItemEnabled() {
            return false;
        }

        protected void setData(Element element) {
            this.detailsTableModel.deleteRows();
        }

        protected void reset() {
        }

        protected void serialise(Element element) {
        }

        public String getTitle() {
            return this.title;
        }
    }

    class DetailsTableModel
    extends BGTableModel<Element> {
        public DetailsTableModel() {
            super(DetailsTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442", 200, 300, 400, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 100, 100, 100, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

