/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import bitel.billing.server.ActionConType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionDao;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBill;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBillManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@ActionConType(value=2)
public class ActionGetTemplateBillList
extends ActionBase {
    private DocumentType documentType;
    int documentIdFrom;

    public void doAction() throws SQLException, BGException {
        Comparable<ChronoLocalDate> month;
        String type = this.getParameter("type");
        int yy = this.getIntParameter("y", 0);
        int mm = this.getIntParameter("m", 0);
        String docTypes = this.getParameter("doc_types");
        if (this.mid <= 0 || yy <= 0 || mm < 0 || Utils.isBlankString((String)type)) {
            throw new BGIllegalArgumentException();
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionGetTemplateBillList", (int)this.mid, (int)this.userId);
        if (closedDate != null) {
            month = LocalDate.of(yy, mm + 1, 1);
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (LocalDate)month, (LocalDate)month);
        }
        this.documentIdFrom = this.getIntParameter("documentId", -1);
        this.documentType = type.equals("invoice") ? DocumentType.INVOICE : DocumentType.BILL;
        month = new GregorianCalendar(yy, mm, 1);
        String contractIds = this.getParameter("cids");
        String outgoing = this.getParameter("outgoing");
        String[] range = null;
        if (outgoing != null) {
            range = outgoing.split(";");
        }
        boolean andCreate = this.getBooleanParameter("andCreate", false);
        Element table = this.createElement(this.rootNode, "table");
        Element data = null;
        Element row = null;
        Document doc = null;
        String rowName = null;
        if (andCreate) {
            doc = XMLUtils.newDocument();
            data = XMLUtils.createElement((Document)doc, (String)"bills");
            rowName = "bill";
        } else {
            data = this.createElement(table, "data");
            rowName = "row";
        }
        boolean checked = this.moduleSetup.getInt(type + ".generate.new.checked", 1) > 0;
        String contractLabels = this.getParameter("gr");
        TemplateBillManager templateBillManager = new TemplateBillManager(this.conSlave, this.mid, this.documentType);
        List<TemplateBill> templateBillList = templateBillManager.getTemplatePayBillList((Preferences)this.moduleSetup, yy, mm, contractLabels, contractIds, docTypes, range);
        try (BalanceUtils bu = new BalanceUtils(this.conSlave);){
            for (TemplateBill templateBill : templateBillList) {
                BigDecimal subBillSumm = BigDecimal.ZERO;
                row = this.createElement(data, rowName);
                if (checked) {
                    row.setAttribute("check", "true");
                }
                row.setAttribute("rest", Utils.formatBigDecimalSumm((BigDecimal)bu.getBalance(((Calendar)month).getTime(), templateBill.getContractId())));
                BigDecimal billSumm = this.fillBillData(row, templateBill);
                String accountId = this.getParameter("account_id");
                if (andCreate && !this.documentType.equals((Object)DocumentType.INVOICE) && Utils.notBlankString((String)accountId)) {
                    row.setAttribute("account_id", accountId);
                }
                String organizationId = this.getParameter("organization_id");
                if (andCreate && !this.documentType.equals((Object)DocumentType.INVOICE) && Utils.notBlankString((String)accountId)) {
                    row.setAttribute("organization_id", organizationId);
                }
                if (templateBill.getSubBillList() != null) {
                    for (TemplateBill templateSubBill : templateBill.getSubBillList()) {
                        Element subBill = this.createElement(row, "sub_bill");
                        subBillSumm = subBillSumm.add(this.fillBillData(subBill, templateSubBill));
                    }
                }
                row.setAttribute("sub_bill_summ", Utils.formatBigDecimalSumm((BigDecimal)subBillSumm));
                row.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)billSumm.add(subBillSumm)));
            }
        }
        if (andCreate) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLUtils.serialize((Node)doc, (OutputStream)baos, (String)"UTF-8");
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try (AbstractManager manager = this.documentType.equals((Object)DocumentType.INVOICE) ? new InvoiceManager(this.con, this.mid) : new BillManager(this.con, this.mid);){
                manager.addBillDocs(this.userId, is, yy, mm, new Date());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try (PositionDao positionDao = new PositionDao(this.con, this.mid, this.documentType);){
            Element positions = this.createElement(this.rootNode, "positions");
            for (Position pos : positionDao.getPositonList()) {
                this.addListItem(positions, pos.getId(), BillUtil.parsePositionName(pos.getName(), month));
            }
        }
    }

    private BigDecimal fillBillData(Element row, TemplateBill templateBill) throws BGMessageException {
        BigDecimal billSumm = BigDecimal.ZERO;
        row.setAttribute("id", String.valueOf(templateBill.getContractDocTypeId()));
        row.setAttribute("type", String.valueOf(templateBill.getDocTypeId()));
        row.setAttribute("type_title", templateBill.getDocTypeTitle());
        row.setAttribute("cid", String.valueOf(templateBill.getContractId()));
        row.setAttribute("contract", templateBill.getContractTitle());
        row.setAttribute("contract_comment", templateBill.getContractComment());
        if (this.documentIdFrom > 0) {
            String typeFrom = this.getParameter("typeDocumentFrom", null);
            if (typeFrom == null) {
                throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0431\u0443\u0434\u0443\u0442 \u0431\u0440\u0430\u0442\u044c\u0441\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u0438");
            }
            try (AbstractManager manager = typeFrom.equals("invoice") ? new InvoiceManager(this.con, this.mid) : new BillManager(this.con, this.mid);){
                Document doc1 = XMLUtils.parseDocument((byte[])manager.getXMLData(this.documentIdFrom));
                Element bill = (Element)doc1.getElementsByTagName("bill").item(0);
                for (Element item : XMLUtils.selectElements((Node)bill, (String)"pos")) {
                    Node node = row.getOwnerDocument().importNode(item, true);
                    row.appendChild(node);
                    if (!Utils.parseBoolean((String)XMLUtils.getAttribute((Element)item, (String)"insum"), (boolean)false)) continue;
                    billSumm = billSumm.add(Utils.parseBigDecimal((String)XMLUtils.getAttribute((Element)item, (String)"summ"), (BigDecimal)BigDecimal.ZERO));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (PositionValue value : templateBill.getPositionList()) {
                BigDecimal sum = value.getSum();
                Element posEl = this.createElement(row, "pos");
                value.toElement(posEl);
                Position pos = value.getPosition();
                posEl.setAttribute("insum", pos.isInSum() ? "1" : "0");
                posEl.setAttribute("awlz", pos.isAddWhenLessZero() ? "1" : "0");
                Map params = pos.getParams();
                if (params != null && "1".equals(params.get("param_awq")) && BigDecimal.ZERO.compareTo(Utils.maskNull((BigDecimal)value.getQuantity())) < 0) {
                    posEl.setAttribute("awlz", "1");
                }
                if (!pos.isInSum()) continue;
                billSumm = billSumm.add(sum);
            }
        }
        row.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)billSumm));
        return billSumm;
    }
}

