/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import bitel.billing.server.ActionConType;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.Invoice;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

@ActionConType(value=2)
public class ActionInvoice
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        String groups = this.getParameter("gr", "");
        String groupMode = this.getParameter("gr_mode", "or");
        String contractTitle = this.getParameter("contract", "");
        String billNumber = this.getParameter("billNumber", "");
        int unloadType = this.getIntParameter("unload_type", 0);
        String type = this.getParameter("type", "");
        int yy = this.getIntParameter("y", 0);
        int mm = this.getIntParameter("m", -1);
        String sFrom = this.getParameter("from", "");
        String sUntil = this.getParameter("until", "");
        boolean getXml = Utils.notBlankString((String)this.getParameter("get_xml"));
        int packageParamId = this.getPackageParamId();
        int packageId = this.getIntParameter("package", -1);
        int addressParamId = this.getAddressSortParamId();
        String nameParamId = this.getNameSortParamId();
        int sortMode = this.getIntParameter("sort_mode", 0);
        int secondarySortMode = this.getIntParameter("secondary_sort_mode", -1);
        Calendar from = null;
        Calendar until = null;
        if (!Utils.isEmptyString((String)sFrom)) {
            from = TimeUtils.convertStringToCalendar((String)sFrom);
        }
        if (!Utils.isEmptyString((String)sUntil)) {
            until = TimeUtils.convertStringToCalendar((String)sUntil);
        }
        boolean forRegister = this.getIntParameter("forRegister", 0) == 1;
        Page page = this.getPage();
        List<Invoice> payInvoiceList = null;
        try (InvoiceManager invoiceManager = new InvoiceManager(this.conSlave, this.mid);){
            payInvoiceList = invoiceManager.getInvoiceList(page, yy, mm, from, until, unloadType, groups, groupMode, contractTitle, billNumber, getXml, type, packageParamId, packageId, addressParamId, nameParamId, sortMode, secondarySortMode, forRegister);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (payInvoiceList == null) {
            return;
        }
        Document doc = this.rootNode.getOwnerDocument();
        BigDecimal sum = BigDecimal.ZERO;
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        this.setPageAttribute(table, page);
        StringBuilder contractAndComment = new StringBuilder();
        for (Invoice payInvoice : payInvoiceList) {
            Element row = this.createElement(data, "row");
            sum = sum.add(payInvoice.getSumm());
            contractAndComment.setLength(0);
            contractAndComment.append(payInvoice.getContractTitle());
            if (payInvoice.getContractComment() != null) {
                contractAndComment.append(" [ ").append(payInvoice.getContractComment()).append(" ]");
            }
            row.setAttribute("id", String.valueOf(payInvoice.getId()));
            row.setAttribute("cid", String.valueOf(payInvoice.getContractId()));
            row.setAttribute("contract", payInvoice.getContractTitle());
            row.setAttribute("contract_and_comment", contractAndComment.toString());
            row.setAttribute("number", String.valueOf(payInvoice.getFormatNumber()));
            row.setAttribute("create_dt", TimeUtils.formatDate((Date)payInvoice.getCreateDate()));
            row.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)payInvoice.getSumm()));
            row.setAttribute("sum", Utils.formatBigDecimalSumm((BigDecimal)payInvoice.getSumm()));
            row.setAttribute("unload_status", payInvoice.getUnloadStatus() == 0 ? "\u043d\u0435 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d" : "\u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d");
            row.setAttribute("show_ready", String.valueOf(payInvoice.isShowReady()));
            row.setAttribute("type", String.valueOf(payInvoice.getTypeId()));
            row.setAttribute("type_title", Utils.maskNull((String)payInvoice.getTypeTitle()));
            row.setAttribute("userId", String.valueOf(payInvoice.getUserId()));
            if (forRegister) {
                row.setAttribute("address", Utils.maskNull((String)payInvoice.getAddress()));
                row.setAttribute("recipient", Utils.maskNull((String)payInvoice.getRecipient()));
            }
            if (!getXml) continue;
            row.appendChild(doc.importNode(payInvoice.getDocument().getDocumentElement(), true));
        }
        table.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)sum));
        table.setAttribute("number", String.valueOf(payInvoiceList.size()));
        this.createElement(this.rootNode, "separator").setAttribute("separator", this.moduleSetup.get("csv.separator", ","));
    }
}

