/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.service;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.jws.WebService;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.config.server.bean.ConfigDAO;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.modules.bill.common.bean.BillPositionType;
import ru.bitel.bgbilling.modules.bill.common.service.BillPositionService;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.bill.common.service.BillPositionService")
public class BillPositionServiceImpl
extends AbstractService
implements BillPositionService {
    public List<String> searchPositions(BillPositionType billPositionType, Page page) throws BGException {
        ArrayList<String> list = new ArrayList<String>();
        this.resetModuleSetup();
        ModuleSetup moduleSetup = this.getModuleSetup();
        switch (billPositionType) {
            case BILL: {
                list.addAll(this.buildPositionList(moduleSetup.sub("bill.pos.")));
                break;
            }
            case INVOICE: {
                list.addAll(this.buildPositionList(moduleSetup.sub("invoice.pos.")));
                break;
            }
        }
        return list;
    }

    public void updatePositionData(BillPositionType billPositionType, String positionData) throws BGException {
        try (ConfigDAO configDAO = new ConfigDAO(this.getConnection());){
            ConfigData configData = configDAO.getActiveConfig(this.moduleId);
            if (configData == null) {
                throw new BGException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f [moduleId=" + this.moduleId + "]");
            }
            ArrayList<CallSite> config = new ArrayList<CallSite>();
            Stream.of(configData.getConfig().split("\n")).forEach(e -> config.add((CallSite)e));
            JSONObject json = new JSONObject(positionData);
            String prefix = (billPositionType == BillPositionType.BILL ? "bill" : "invoice") + ".pos." + json.optString("key") + ".";
            json.remove("id");
            json.remove("key");
            for (String key : json.keySet()) {
                boolean update = false;
                String value = json.getString(key);
                for (int index = 0; index < config.size(); ++index) {
                    String line = (String)config.get(index);
                    if (!line.startsWith(prefix + key + "=")) continue;
                    if (Utils.isBlankString((String)value)) {
                        config.remove(index);
                    } else {
                        config.set(index, (CallSite)((Object)(prefix + key + "=" + value)));
                    }
                    update = true;
                    break;
                }
                if (update || !Utils.notBlankString((String)value)) continue;
                config.add((CallSite)((Object)(prefix + key + "=" + value)));
            }
            StringBuffer stringBuffer = new StringBuffer();
            config.stream().forEach(l -> stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "").append((String)l));
            configData.setConfig(stringBuffer.toString());
            configDAO.update((Object)configData);
            EventProcessor.getInstance().publish((Event)new ModuleConfigModifiedEvent(this.moduleId, this.userId));
        }
    }

    public void deletePositionData(BillPositionType billPositionType, String key) throws BGException {
        try (ConfigDAO configDAO = new ConfigDAO(this.getConnection());){
            ConfigData configData = configDAO.getActiveConfig(this.moduleId);
            if (configData == null) {
                throw new BGException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f [moduleId=" + this.moduleId + "]");
            }
            ArrayList config = new ArrayList();
            Stream.of(configData.getConfig().split("\n")).forEach(e -> config.add(e));
            String prefix = (billPositionType == BillPositionType.BILL ? "bill" : "invoice") + ".pos." + key + ".";
            for (int index = config.size() - 1; index >= 0; --index) {
                String line = (String)config.get(index);
                if (!line.startsWith(prefix)) continue;
                config.remove(index);
            }
            StringBuffer stringBuffer = new StringBuffer();
            config.stream().forEach(l -> stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "").append((String)l));
            configData.setConfig(stringBuffer.toString());
            configDAO.update((Object)configData);
            EventProcessor.getInstance().publishAfterCommit((Event)new ModuleConfigModifiedEvent(this.moduleId, this.userId));
        }
    }

    private List<String> buildPositionList(ParameterMap subMap) {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, HashMap<String, String>> maps = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry entry : subMap.entrySet()) {
            int pos = ((String)entry.getKey()).indexOf(46);
            if (pos <= 0) continue;
            String key = ((String)entry.getKey()).substring(0, pos);
            HashMap<String, String> map = (HashMap<String, String>)maps.get(key);
            if (map == null) {
                map = new HashMap<String, String>();
                maps.put(key, map);
            }
            map.put(((String)entry.getKey()).substring(pos + 1), (String)entry.getValue());
        }
        int id = 1;
        for (Map.Entry entry : maps.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", id++);
            jsonObject.put("key", entry.getKey());
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                jsonObject.put((String)entry1.getKey(), entry1.getValue());
            }
            list.add(jsonObject.toString());
        }
        return list;
    }
}

