/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.client.contract;

import bitel.billing.module.common.BGControlPanelDate;
import bitel.billing.module.common.BGControlPanelPeriodNoDay;
import bitel.billing.module.contract.ContractPanel_Parameters;
import bitel.billing.module.contract.ContractSubPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusBalance;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusCharge;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPayment;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPaymentType;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;

public class ContractSubPanel_Bonus
extends ContractSubPanel {
    private BonusPaymentTableModel paymentModel;
    private BGUTable paymentTable;
    private BonusChargeTableModel chargeModel;
    private BGUTable chargeTable;
    private DetailsBonusPaymentTableModel detailsPaymentModel;
    private BGUTable detailsPaymentTable;
    private DetailsBonusChargeTableModel detailsChargeModel;
    private BGUTable detailsChargeTable;
    private BonusBalanceTableModel balanceModel;
    private BGUTable balanceTable;
    private NotActivePaymentTableModel notActivePaymentModel;
    private BGUTable notActivePaymentTable;
    private CardLayout buttonsPeriodCardLayout = new CardLayout();
    private CardLayout tableCardLayout = new CardLayout();
    private CardLayout periodCardLayout = new CardLayout();
    private JPanel periodButtonsPanel = new JPanel();
    private JPanel periodPanel = new JPanel();
    private BGControlPanelPeriodNoDay periodNoDayPanel = new BGControlPanelPeriodNoDay();
    private BGControlPanelDate balanceDatePanel = new BGControlPanelDate();
    private JPanel mpButtonsPanel = new JPanel();
    private JPanel tablePanel = new JPanel();
    private JToggleButton paymentButton = new BonusToggleButton("\u041f\u0440\u0438\u0445\u043e\u0434", "Payment");
    private JToggleButton chargeButton = new BonusToggleButton("\u0420\u0430\u0441\u0445\u043e\u0434", "Charge");
    private JToggleButton balanceButton = new BonusToggleButton("\u0411\u0430\u043b\u0430\u043d\u0441", "Balance");
    private JPanel balanceDateButtonsPanel = new JPanel();
    private JPanel monthsPanel = new JPanel(new GridBagLayout());
    private BGTextField balanceTextField = new BGTextField();
    private BGTextField balanceNotActiveTextField = new BGTextField();
    private Directory<ChargeType> chargeTDirectory;
    private boolean load = true;

    public ContractSubPanel_Bonus() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.getContext().processException((Throwable)e);
        }
    }

    private void jbInit() throws BGException {
        this.chargeTDirectory = this.getContext().getDirectory(ChargeType.class);
        this.tablePanel.setLayout(this.tableCardLayout);
        this.tablePanel.add((Component)this.getPaymentPanel(), "payment");
        this.tablePanel.add((Component)this.getChargePanel(), "charge");
        this.tablePanel.add((Component)this.getBalancePanel(), "balance");
        this.setLayout(new GridBagLayout());
        this.add(this.getControlPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.tablePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 5, 5), 0, 0));
    }

    private JPanel getSeguePanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.paymentButton);
        buttonGroup.add(this.chargeButton);
        buttonGroup.add(this.balanceButton);
        this.paymentButton.setSelected(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.paymentButton, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.chargeButton, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.balanceButton, new GridBagConstraints(2, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getChargePanel() {
        this.chargeModel = new BonusChargeTableModel();
        this.chargeTable = new BGUTable((TableModel)((Object)this.chargeModel));
        this.chargeTable.getSelectionModel().addListSelectionListener(e -> {
            try {
                if (!e.getValueIsAdjusting() && this.chargeModel.getSelectedRow() != null) {
                    int chargeId = ((BonusCharge)this.chargeModel.getSelectedRow()).getId();
                    this.detailsPaymentModel.setData(((BonusService)this.getContext().getPort(BonusService.class)).paymentDetailsList(chargeId));
                }
            }
            catch (Exception e2) {
                ClientUtils.showErrorMessageDialog((Throwable)e2);
            }
        });
        this.detailsPaymentModel = new DetailsBonusPaymentTableModel();
        this.detailsPaymentTable = new BGUTable((TableModel)((Object)this.detailsPaymentModel));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.chargeTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.detailsPaymentTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.15, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPaymentPanel() {
        this.paymentModel = new BonusPaymentTableModel();
        this.paymentTable = new BGUTable((TableModel)((Object)this.paymentModel));
        this.paymentTable.getSelectionModel().addListSelectionListener(e -> {
            try {
                if (!e.getValueIsAdjusting() && this.paymentModel.getSelectedRow() != null) {
                    int paymentId = ((BonusPayment)this.paymentModel.getSelectedRow()).getId();
                    this.detailsChargeModel.setData(((BonusService)this.getContext().getPort(BonusService.class)).chargeDetailsList(paymentId));
                }
            }
            catch (Exception e2) {
                ClientUtils.showErrorMessageDialog((Throwable)e2);
            }
        });
        this.detailsChargeModel = new DetailsBonusChargeTableModel();
        this.detailsChargeTable = new BGUTable((TableModel)((Object)this.detailsChargeModel));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.paymentTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.detailsChargeTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.15, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getBalancePanel() {
        this.balanceModel = new BonusBalanceTableModel();
        this.balanceTable = new BGUTable((TableModel)((Object)this.balanceModel));
        this.notActivePaymentModel = new NotActivePaymentTableModel();
        this.notActivePaymentTable = new BGUTable((TableModel)((Object)this.notActivePaymentModel));
        this.balanceTextField.setEditable(false);
        this.balanceTextField.setHorizontalAlignment(4);
        this.balanceNotActiveTextField.setEditable(false);
        this.balanceNotActiveTextField.setHorizontalAlignment(4);
        JPanel notActivePaymentsPanel = new JPanel(new GridBagLayout());
        notActivePaymentsPanel.add((Component)new JLabel("\u041f\u043b\u0430\u0442\u0435\u0436\u0438 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u043d\u0430 " + TimeUtils.formatFullDate((Date)new Date())), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        notActivePaymentsPanel.add((Component)new JScrollPane((Component)this.notActivePaymentTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.balanceTable), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0431\u0430\u043b\u0430\u043d\u0441:"), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 0), 0, 0));
        panel.add((Component)this.balanceTextField, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 13, 1, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)notActivePaymentsPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.3, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041e\u0436\u0438\u0434\u0430\u0435\u043c\u044b\u0435 \u0431\u0430\u043b\u043b\u044b:"), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 0), 0, 0));
        panel.add((Component)this.balanceNotActiveTextField, new GridBagConstraints(2, 3, 1, 1, 0.1, 0.0, 13, 1, new Insets(5, 5, 5, 0), 0, 0));
        return panel;
    }

    public void setPeriod(Calendar date1, Calendar date2) {
        this.periodNoDayPanel.setDateCalendar1((Calendar)date1.clone());
        this.periodNoDayPanel.setDateCalendar2((Calendar)date2.clone());
        this.refreshData();
    }

    private JPanel getControlPanel() {
        BonusPeriodButton contract = new BonusPeriodButton("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", "c", "\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        BonusPeriodButton currentMonth = new BonusPeriodButton("\u041c\u0435\u0441\u044f\u0446", "cM", "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446");
        BonusPeriodButton currentQuarter = new BonusPeriodButton("\u041a\u0432\u0430\u0440\u0442\u0430\u043b", "cQ", "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u0432\u0430\u0440\u0442\u0430\u043b");
        BonusPeriodButton currentYear = new BonusPeriodButton("\u0413\u043e\u0434", "cY", "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0433\u043e\u0434");
        BonusPeriodButton quarter = new BonusPeriodButton("3 \u041c\u0435\u0441.", "q", "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 3 \u043c\u0435\u0441\u044f\u0446\u0430");
        BonusPeriodButton halfYear = new BonusPeriodButton("6 \u041c\u0435\u0441.", "hY", "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 6 \u043c\u0435\u0441\u044f\u0446\u0435\u0432");
        BonusPeriodButton year = new BonusPeriodButton("12 \u041c\u0435\u0441.", "y", "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 12 \u043c\u0435\u0441\u044f\u0446\u0435\u0432");
        BonusBalanceDateButton currentDay = new BonusBalanceDateButton("\u0421\u0435\u0433\u043e\u0434\u043d\u044f", "currentDay", "\u0421\u0435\u0433\u043e\u0434\u043d\u044f");
        BonusBalanceDateButton yesterday = new BonusBalanceDateButton("\u0412\u0447\u0435\u0440\u0430", "yesterday", "\u0412\u0447\u0435\u0440\u0430");
        BonusBalanceDateButton startWeek = new BonusBalanceDateButton("\u041d\u0435\u0434\u0435\u043b\u044f", "startWeek", "\u041d\u0430 \u043d\u0430\u0447\u0430\u043b\u043e \u043d\u0435\u0434\u0435\u043b\u0438");
        BonusBalanceDateButton startMonth = new BonusBalanceDateButton("\u041c\u0435\u0441\u044f\u0446", "startMonth", "\u041d\u0430 \u043d\u0430\u0447\u0430\u043b\u043e \u043c\u0435\u0441\u044f\u0446\u0430");
        BonusBalanceDateButton startYear = new BonusBalanceDateButton("\u0413\u043e\u0434", "startYear", "\u041d\u0430 \u043d\u0430\u0447\u0430\u043b\u043e \u0433\u043e\u0434\u0430");
        this.periodButtonsPanel.setLayout(new GridBagLayout());
        this.periodButtonsPanel.add((Component)contract, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.periodButtonsPanel.add((Component)currentMonth, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.periodButtonsPanel.add((Component)currentQuarter, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.periodButtonsPanel.add((Component)currentYear, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.periodButtonsPanel.add((Component)quarter, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.periodButtonsPanel.add((Component)halfYear, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.periodButtonsPanel.add((Component)year, new GridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.balanceDateButtonsPanel.setLayout(new GridBagLayout());
        this.balanceDateButtonsPanel.add((Component)currentDay, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.balanceDateButtonsPanel.add((Component)yesterday, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.balanceDateButtonsPanel.add((Component)startWeek, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.balanceDateButtonsPanel.add((Component)startMonth, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.balanceDateButtonsPanel.add((Component)startYear, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.periodNoDayPanel.setBorder((Border)new BGTitleBorder(" \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 "));
        this.periodNoDayPanel.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("date1") || evt.getPropertyName().equals("date2")) {
                this.refreshData();
            }
        });
        this.balanceDatePanel.setButtonMove(true);
        this.balanceDatePanel.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("date")) {
                this.refreshData();
            }
        });
        this.periodPanel.setLayout(this.periodCardLayout);
        this.periodPanel.add((Component)this.periodNoDayPanel, "periodNoDayPanel");
        this.periodPanel.add((Component)this.balanceDatePanel, "balanceDatePanel");
        this.periodCardLayout.show(this.periodPanel, "periodNoDayPanel");
        this.mpButtonsPanel.setLayout(this.buttonsPeriodCardLayout);
        this.mpButtonsPanel.add((Component)this.balanceDateButtonsPanel, "balanceDay");
        this.mpButtonsPanel.add((Component)this.periodButtonsPanel, "period");
        this.buttonsPeriodCardLayout.show(this.mpButtonsPanel, "period");
        this.monthsPanel.setBorder((Border)new BGTitleBorder(" \u0412\u044b\u0431\u043e\u0440 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 "));
        this.monthsPanel.add((Component)this.mpButtonsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)this.periodPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
        controlPanel.add((Component)this.monthsPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        controlPanel.add((Component)this.getSeguePanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return controlPanel;
    }

    private BigDecimal round(BigDecimal value) {
        return value.setScale(0, RoundingMode.CEILING);
    }

    public void refreshData() {
        try {
            Date dateFrom = this.periodNoDayPanel.getDateFrom();
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(this.periodNoDayPanel.getDateTo());
            calendar.add(2, 1);
            calendar.add(13, -1);
            Date dateTo = calendar.getTime();
            if (this.paymentButton.isSelected()) {
                this.paymentModel.setData(((BonusService)this.getContext().getPort(BonusService.class)).paymentList(this.getContractId(), dateFrom, dateTo));
                this.detailsChargeModel.setData(new ArrayList());
            } else if (this.chargeButton.isSelected()) {
                this.chargeModel.setData(((BonusService)this.getContext().getPort(BonusService.class)).chargeList(this.getContractId(), dateFrom, dateTo));
                this.detailsPaymentModel.setData(new ArrayList());
            } else if (this.balanceButton.isSelected()) {
                Date whatDay = TimeUtils.getEndDay((Calendar)this.balanceDatePanel.getDateCalendar()).getTime();
                this.balanceModel.setData(((BonusService)this.getContext().getPort(BonusService.class)).balanceList(this.getContractId(), whatDay));
                this.notActivePaymentModel.setData(((BonusService)this.getContext().getPort(BonusService.class)).paymentsNotActiveNow(this.getContractId()));
                BigDecimal balanceLoc = ((BonusService)this.getContext().getPort(BonusService.class)).balance(this.getContractId(), whatDay);
                this.balanceTextField.setText(balanceLoc != null ? this.round(balanceLoc).toString() : BigDecimal.ZERO.toString());
                BigDecimal balanceNonActiveLoc = ((BonusService)this.getContext().getPort(BonusService.class)).balanceNotActive(this.getContractId(), new Date());
                this.balanceNotActiveTextField.setText(balanceNonActiveLoc != null ? this.round(balanceNonActiveLoc).toString() : BigDecimal.ZERO.toString());
            }
        }
        catch (Exception e) {
            this.getContext().processException((Throwable)e);
        }
    }

    public void setData() {
        if (this.load) {
            GregorianCalendar date1 = new GregorianCalendar();
            date1.set(5, 1);
            GregorianCalendar date2 = new GregorianCalendar();
            this.setPeriod(date1, date2);
            this.balanceDatePanel.setLocalDate(TimeUtils.convertDateToLocalDate((Date)date2.getTime()));
            this.load = false;
        } else {
            this.refreshData();
        }
    }

    public void newItem() {
        try {
            if (this.paymentButton.isSelected()) {
                if (((BonusService)this.getContext().getPort(BonusService.class)).pluginInclude(this.getContractId())) {
                    new BonusPaymentEditor("\u041d\u043e\u0432\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436", new BonusPayment()).getDialog().setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u043b\u0430\u0433\u0438\u043d \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d \u0443 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. ");
                }
            } else {
                super.newItem();
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    public void editItem() {
        try {
            if (this.paymentButton.isSelected()) {
                if (((BonusService)this.getContext().getPort(BonusService.class)).pluginInclude(this.getContractId())) {
                    BonusPayment bonusPayment = (BonusPayment)this.paymentModel.getSelectedRow();
                    if (bonusPayment == null) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u0442\u0435\u0436");
                        return;
                    }
                    new BonusPaymentEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430", bonusPayment).getDialog().setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u043b\u0430\u0433\u0438\u043d \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d \u0443 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. ");
                }
            } else {
                super.editItem();
                super.newItem();
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    public void deleteItem() {
        try {
            if (this.paymentButton.isSelected()) {
                if (!((BonusService)this.getContext().getPort(BonusService.class)).pluginInclude(this.getContractId())) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u043b\u0430\u0433\u0438\u043d \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d \u0443 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. ");
                    return;
                }
                if (this.paymentModel.getSelectedRow() != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 ?", "", 0, 3) == 0 && !((BonusService)this.getContext().getPort(BonusService.class)).paymentDelete(((BonusPayment)this.paymentModel.getSelectedRow()).getId())) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d, \u0442\u0430\u043a \u043a\u0430\u043a \u0443 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u0440\u0430\u0441\u0445\u043e\u0434. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0432 \u043d\u0430\u0447\u0430\u043b\u0435 \u0440\u0430\u0441\u0445\u043e\u0434. ");
                }
            } else if (this.chargeButton.isSelected()) {
                ClientUtils.showErrorMessageDialog((String)"\u0411\u043e\u043d\u0443\u0441\u043d\u044b\u0435 \u0440\u0430\u0441\u0445\u043e\u0434\u044b \u0443\u0434\u0430\u043b\u044f\u044e\u0442\u0441\u044f \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0440\u0430\u0441\u0445\u043e\u0434\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.");
            } else {
                super.newItem();
            }
            EventBus.publish((Object)new UpdateContractTreeEvent(0, this.getContractId()));
            this.refreshData();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private class BonusToggleButton
    extends JToggleButton {
        BonusToggleButton(String text, String actionCommand) {
            this.setText(text);
            this.setActionCommand(actionCommand);
            this.setFont(new Font("Dialog", 1, 14));
            ActionListener modeButtonActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BonusToggleButton.this.switchTable(actionEvent.getActionCommand());
                }
            };
            this.addActionListener(modeButtonActionListener);
        }

        private void switchTable(String command) {
            if (command.equals("Payment")) {
                ContractSubPanel_Bonus.this.tableCardLayout.show(ContractSubPanel_Bonus.this.tablePanel, "payment");
                ContractSubPanel_Bonus.this.buttonsPeriodCardLayout.show(ContractSubPanel_Bonus.this.mpButtonsPanel, "period");
                ContractSubPanel_Bonus.this.periodCardLayout.show(ContractSubPanel_Bonus.this.periodPanel, "periodNoDayPanel");
            } else if (command.equals("Charge")) {
                ContractSubPanel_Bonus.this.tableCardLayout.show(ContractSubPanel_Bonus.this.tablePanel, "charge");
                ContractSubPanel_Bonus.this.buttonsPeriodCardLayout.show(ContractSubPanel_Bonus.this.mpButtonsPanel, "period");
                ContractSubPanel_Bonus.this.periodCardLayout.show(ContractSubPanel_Bonus.this.periodPanel, "periodNoDayPanel");
            } else if (command.equals("Balance")) {
                ContractSubPanel_Bonus.this.tableCardLayout.show(ContractSubPanel_Bonus.this.tablePanel, "balance");
                ContractSubPanel_Bonus.this.buttonsPeriodCardLayout.show(ContractSubPanel_Bonus.this.mpButtonsPanel, "balanceDay");
                ContractSubPanel_Bonus.this.periodCardLayout.show(ContractSubPanel_Bonus.this.periodPanel, "balanceDatePanel");
            }
            ContractSubPanel_Bonus.this.refreshData();
        }
    }

    class BonusChargeTableModel
    extends BGTableModel<BonusCharge> {
        public BonusChargeTableModel() {
            super(BonusChargeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430", -1, 150, -1, "", true);
            this.addColumn("ID \u0440\u0430\u0441\u0445\u043e\u0434\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", -1, 150, -1, "contractChargeId", true);
            this.addColumn("\u0414\u0430\u0442\u0430", -1, 150, -1, "date", true);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", -1, 150, -1, "sum", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValueAt(BonusCharge val, int column) throws BGException {
            if (column == 1) {
                return ContractSubPanel_Bonus.this.chargeTDirectory.get(val.getTypeId()) != null ? ((ChargeType)ContractSubPanel_Bonus.this.chargeTDirectory.get(val.getTypeId())).getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
            }
            return super.getValue((Object)val, column);
        }
    }

    class DetailsBonusPaymentTableModel
    extends BGTableModel<BonusPayment> {
        public DetailsBonusPaymentTableModel() {
            super(DetailsBonusPaymentTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430", -1, 150, -1, "typeTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0430\u0442\u0430", -1, 150, -1, "date", true);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", -1, 150, -1, "sum", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", -1, 150, -1, "datePeriod", true);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 200, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class BonusPaymentTableModel
    extends BGTableModel<BonusPayment> {
        public BonusPaymentTableModel() {
            super(BonusPaymentTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430", -1, 100, 100, "date", true);
            this.addColumn("\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430", -1, -1, -1, "typeTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 100, 100, 100, "sum", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", -1, 200, 200, "datePeriod", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 200, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class DetailsBonusChargeTableModel
    extends BGTableModel<BonusCharge> {
        public DetailsBonusChargeTableModel() {
            super(DetailsBonusChargeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430", -1, 150, -1, "typeTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("ID \u0440\u0430\u0441\u0445\u043e\u0434\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", -1, 150, -1, "contractChargeId", true);
            this.addColumn("\u0414\u0430\u0442\u0430", -1, 150, -1, "date", true);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", -1, 150, -1, "sum", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValue(BonusCharge val, int column) throws BGException {
            if (column == 1) {
                return ContractSubPanel_Bonus.this.chargeTDirectory.get(val.getTypeId()) != null ? ((ChargeType)ContractSubPanel_Bonus.this.chargeTDirectory.get(val.getTypeId())).getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
            }
            return super.getValue((Object)val, column);
        }
    }

    class BonusBalanceTableModel
    extends BGTableModel<BonusBalance> {
        public BonusBalanceTableModel() {
            super(BonusBalanceTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0438\u043f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438", -1, 150, -1, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0430\u0442\u0430", -1, 150, -1, "date", true);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", -1, 150, -1, "sum", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041a\u0440\u0435\u0434\u0438\u0442", String.class, -1, 150, -1, "sum", true);
            this.addColumn("\u0414\u0435\u0431\u0435\u0442", String.class, -1, 150, -1, "sum", true);
            this.addColumn("\u041e\u0441\u0442\u0430\u0442\u043e\u043a", String.class, -1, 150, -1, "excess", true);
        }

        public Object getValue(BonusBalance val, int column) throws BGException {
            switch (column) {
                case 1: {
                    return val.getTypeId() == 1 ? "\u041f\u0440\u0438\u0445\u043e\u0434" : "\u0420\u0430\u0441\u0445\u043e\u0434";
                }
                case 4: {
                    if (val.getTypeId() == 1) {
                        return ContractSubPanel_Bonus.this.round(val.getSum());
                    }
                    if (val.getTypeId() == 2) {
                        return "----";
                    }
                }
                case 5: {
                    if (val.getTypeId() == 1) {
                        return "----";
                    }
                    if (val.getTypeId() == 2) {
                        return ContractSubPanel_Bonus.this.round(val.getDebitSum());
                    }
                    return super.getValue((Object)val, column);
                }
                case 6: {
                    return ContractSubPanel_Bonus.this.round(val.getRest());
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class NotActivePaymentTableModel
    extends BGTableModel<BonusPayment> {
        public NotActivePaymentTableModel() {
            super(NotActivePaymentTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430", -1, 150, -1, "typeTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0430\u0442\u0430", -1, 150, -1, "date", true);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", -1, 150, -1, "sum", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", -1, 150, -1, "datePeriod", true);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 200, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(BonusPayment val, int column) throws BGException {
            if (column == 3) {
                return ContractSubPanel_Bonus.this.round(val.getSum());
            }
            return super.getValue((Object)val, column);
        }
    }

    class BonusPeriodButton
    extends JButton {
        public BonusPeriodButton(String title, String actionCommand, String toolTipText) {
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BonusPeriodButton.this.periodButton_actionPerformed(actionEvent);
                }
            };
            this.setActionCommand(actionCommand);
            this.setText(title);
            this.setToolTipText(toolTipText);
            this.addActionListener(al);
        }

        private void periodButton_actionPerformed(ActionEvent actionEvent) {
            GregorianCalendar nowDate = new GregorianCalendar();
            Calendar date = (Calendar)((Calendar)nowDate).clone();
            date.set(5, 1);
            String comand = actionEvent.getActionCommand();
            if (comand.equals("c")) {
                Container container;
                for (container = this.getParent(); container != null && !(container instanceof ContractPanel_Parameters); container = container.getParent()) {
                }
                if (container != null && container instanceof ContractPanel_Parameters) {
                    ContractPanel_Parameters panel_Parameters = (ContractPanel_Parameters)container;
                    Period period = panel_Parameters.getContractPeriod();
                    date.setTime(period.getDateFrom());
                    if (period.getDateTo() != null) {
                        nowDate.setTime(period.getDateTo());
                    }
                }
            } else if (comand.equals("cQ")) {
                int m = date.get(2);
                if (m <= 2) {
                    date.set(2, 0);
                } else if (m > 2 && m <= 5) {
                    date.set(2, 3);
                } else if (m > 5 && m <= 8) {
                    date.set(2, 6);
                } else if (m > 8 && m <= 11) {
                    date.set(2, 9);
                }
            } else if (comand.equals("cY")) {
                date.set(2, 0);
            } else if (comand.equals("q")) {
                date.set(2, date.get(2) - 3);
            } else if (comand.equals("hY")) {
                date.set(2, date.get(2) - 6);
            } else if (comand.equals("y")) {
                date.set(2, date.get(2) - 12);
            }
            if (date.after(nowDate)) {
                date.add(1, -1);
            }
            ContractSubPanel_Bonus.this.setPeriod(date, nowDate);
        }
    }

    class BonusBalanceDateButton
    extends JButton {
        public BonusBalanceDateButton(String title, String actionCommand, String toolTipText) {
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BonusBalanceDateButton.this.periodButton_actionPerformed(actionEvent);
                }
            };
            this.setActionCommand(actionCommand);
            this.setText(title);
            this.setToolTipText(toolTipText);
            this.addActionListener(al);
        }

        private void periodButton_actionPerformed(ActionEvent actionEvent) {
            Calendar date = new GregorianCalendar();
            String comand = actionEvent.getActionCommand();
            if (comand.equals("yesterday")) {
                date = TimeUtils.getPrevDay((Calendar)date);
            } else if (comand.equals("startWeek")) {
                date.set(7, 2);
            } else if (comand.equals("startMonth")) {
                date = TimeUtils.getStartMonth((Calendar)date);
            } else if (comand.equals("startYear")) {
                date.set(2, 0);
                date.set(5, 1);
            }
            ContractSubPanel_Bonus.this.balanceDatePanel.setLocalDate(TimeUtils.convertDateToLocalDate((Date)date.getTime()));
        }
    }

    class BonusPaymentEditor
    extends BGEditorDialog<BonusPayment> {
        private BGUComboBox<BonusPaymentType> typeComboBox;
        private BGControlPanelPeriod period;
        private JTextField sumTextField;
        private JTextField commentTextField;

        public BonusPaymentEditor(String title, BonusPayment data) {
            super(title, (Object)data);
            this.typeComboBox = new BGUComboBox();
            this.period = new BGControlPanelPeriod();
            this.sumTextField = new BGTextField(10);
            this.commentTextField = new BGTextField();
        }

        public void doDialogPanel() {
            try {
                this.typeComboBox.setData(((BonusService)ContractSubPanel_Bonus.this.getContext().getPort(BonusService.class)).paymentTypeList(true));
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            this.sumTextField.setText(((BonusPayment)this.data).getSum().toString());
            this.sumTextField.setHorizontalAlignment(0);
            this.period.setDateFrom(((BonusPayment)this.data).getDateFrom());
            this.period.setDateTo(((BonusPayment)this.data).getDateTo());
            this.period.setBorder(null);
            this.commentTextField.setText(((BonusPayment)this.data).getComment());
            if (((BonusPayment)this.data).getId() > 0) {
                this.typeComboBox.setEnabled(false);
                this.sumTextField.setEnabled(false);
            }
            this.panel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.typeComboBox, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getSumPeriodPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.commentTextField, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        }

        private JPanel getSumPeriodPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("C\u0443\u043c\u043c\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 25, 0, 5), 0, 0));
            panel.add((Component)this.sumTextField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.period, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            try {
                BigDecimal sum = Utils.parseBigDecimal((String)this.sumTextField.getText(), (BigDecimal)BigDecimal.ZERO);
                if (sum.compareTo(BigDecimal.ZERO) != 1) {
                    ClientUtils.showErrorMessageDialog((String)"\u0421\u0443\u043c\u043c\u0430 \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e!");
                    return false;
                }
                if (this.period.getDateCalendar2() == null || this.period.getDateCalendar1() == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0441\u0442\u0430\u0432\u0438\u0442\u0435 \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0440\u0438\u0445\u043e\u0434\u0430");
                    return false;
                }
                if (this.period.getDateCalendar1().compareTo(this.period.getDateCalendar2()) > 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u041f\u0435\u0440\u0432\u0430\u044f \u0434\u0430\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0432\u0442\u043e\u0440\u043e\u0439 \u0434\u0430\u0442\u044b!");
                    return false;
                }
                if (TimeUtils.dateBefore((Calendar)this.period.getDateCalendar2(), (Calendar)Calendar.getInstance())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u0442\u043e\u0440\u0430\u044f \u0434\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u044b!");
                    return false;
                }
                int typeId = ((BonusPaymentType)this.typeComboBox.getSelectedItem()).getId();
                if (typeId != -1) {
                    ((BonusPayment)this.data).setTypeId(typeId);
                    ((BonusPayment)this.data).setSum(sum);
                    ((BonusPayment)this.data).setDate(new Date());
                    ((BonusPayment)this.data).setDateFrom(this.period.getPeriod().getDateFrom());
                    ((BonusPayment)this.data).setDateTo(this.period.getPeriod().getDateTo());
                    ((BonusPayment)this.data).setComment(this.commentTextField.getText());
                    ((BonusService)ContractSubPanel_Bonus.this.getContext().getPort(BonusService.class)).paymentUpdate(ContractSubPanel_Bonus.this.getContractId(), (BonusPayment)this.data);
                    ContractSubPanel_Bonus.this.refreshData();
                }
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ContractSubPanel_Bonus.this.getContractId()));
            }
            catch (Exception e) {
                ContractSubPanel_Bonus.this.getContext().processException((Throwable)e);
            }
            return super.doApply();
        }
    }
}

