/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class BotSessionsDao {
    private final String TABLE_NAME;
    private final Connection connection;

    public BotSessionsDao(Connection connection, int moduleId) {
        this.connection = connection;
        this.TABLE_NAME = ServerUtils.getModuleTableName((String)"bot_sessions", (int)moduleId);
    }

    public Map<Long, Integer> getSessions(int botId) throws BGException {
        HashMap<Long, Integer> sessions = new HashMap<Long, Integer>();
        String query = "SELECT * FROM " + this.TABLE_NAME + " WHERE bot_id=?";
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setInt(1, botId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                sessions.put(rs.getLong("chat_id"), rs.getInt("contract_id"));
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return sessions;
    }

    public void updateSession(int botId, int contractId, long chatId) throws BGException {
        String query;
        boolean isUpdate = this.isUpdate(botId, chatId);
        String set = " SET bot_id=?, contract_id=?, chat_id=?";
        String string = query = isUpdate ? "UPDATE " + this.TABLE_NAME + set : "INSERT INTO " + this.TABLE_NAME + set;
        if (isUpdate) {
            query = query + " WHERE chat_id=?";
        }
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setInt(1, botId);
            ps.setInt(2, contractId);
            ps.setLong(3, chatId);
            if (isUpdate) {
                ps.setLong(4, chatId);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private boolean isUpdate(int botId, long chatId) throws BGException {
        boolean result = false;
        String query = "select count(*) from " + this.TABLE_NAME + " where bot_id=? AND chat_id=?";
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setInt(1, botId);
            ps.setLong(2, chatId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = true;
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void removeSession(int botId, long chatId) throws BGException {
        String query = "DELETE * FROM " + this.TABLE_NAME + " WHERE botId=? AND chatId=?";
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setInt(1, botId);
            ps.setLong(2, chatId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

