/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogGroup;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessingWrapper;
import ru.bitel.bgbilling.modules.botmanager.common.bean.StatisticNote;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.bgbilling.modules.botmanager.server.bots.BotManagment;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDao;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDialogDao;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDialogElementDao;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDialogGroupDao;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotStatisticDao;
import ru.bitel.bgbilling.modules.botmanager.server.filestorage.BotFileStorage;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService")
public class BotManagerServiceImpl
extends AbstractService
implements BotManagerService {
    private static Logger logger = LogManager.getLogger();
    private BotDao botDao;
    private BotDialogDao dialogDao;
    private BotDialogElementDao dialogElementDao;
    private BotDialogGroupDao dialogGroupDao;
    private BotStatisticDao statisticDao;
    private FileStorage fileStorage;

    @PostConstruct
    public void init() {
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(true);
            this.botDao = new BotDao(connection, this.moduleId);
            this.dialogDao = new BotDialogDao(connection, this.moduleId);
            this.dialogElementDao = new BotDialogElementDao(connection, this.moduleId);
            this.dialogGroupDao = new BotDialogGroupDao(connection, this.moduleId);
            this.statisticDao = new BotStatisticDao(connection, this.moduleId);
            this.fileStorage = new BotFileStorage(this.getConnection(), this.moduleId);
        }
        catch (SQLException | BGException ex) {
            logger.error((Object)ex);
        }
    }

    public List<BotDialog> getDialogs() throws BGException {
        return this.dialogDao.getDialogs();
    }

    public void updateDialog(BotDialog dialog) throws BGException {
        boolean needUpdateDialogOnRuntimeBot = dialog.getId() > 0;
        this.dialogDao.update(dialog);
        if (needUpdateDialogOnRuntimeBot) {
            BotManagment.getInstance().getBots().values().forEach(runtimeBot -> {
                try {
                    if (runtimeBot.getFirstDialog().getId() == dialog.getId()) {
                        runtimeBot.setFirstDialog(this.getDialogById(dialog.getId()));
                    }
                }
                catch (BGException ex) {
                    logger.error((Object)ex);
                }
            });
        }
    }

    public void deleteDialog(BotDialog dialog) throws BGException {
        for (BotDialogElement element : dialog.getDialogElements()) {
            element.getDialogIds().remove(dialog.getId());
            this.dialogElementDao.update(element);
        }
        this.dialogDao.delete(dialog.getId());
    }

    public List<Bot> getBots() throws BGException {
        return this.botDao.getBots();
    }

    public void deleteBot(int botId) throws BGException {
        BotManagment botManagment = BotManagment.getInstance();
        RuntimeBot runtimeBot = botManagment.getBot(botId);
        if (runtimeBot.getBotState() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0431\u043e\u0442\u0430 \u0441 id=" + botId);
            }
            botManagment.stopBot(runtimeBot.getToken());
        }
        botManagment.getBots().remove(runtimeBot.getToken());
        this.botDao.delete(botId);
    }

    public void updateBot(Bot bot) throws BGException {
        ModuleSetup setup;
        int startDialogId;
        if (bot.getState() == 1 && (startDialogId = (setup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId))).getInt("bot." + bot.getId() + ".start.dialog.id", -1)) <= 0) {
            throw new BGException("\u041f\u0435\u0440\u0435\u0434 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u0431\u043e\u0442\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u043b\u044f \u043d\u0435\u0433\u043e \u0441\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0434\u0438\u0430\u043b\u043e\u0433 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f!");
        }
        this.botDao.update(bot);
        BotManagment.getInstance().hotSwapBotData(bot);
    }

    public BotDialog getDialogById(int dialogId) throws BGException {
        return (BotDialog)this.dialogDao.get(dialogId);
    }

    public BotDialog getDialogByCommand(String command) throws BGException {
        return this.dialogDao.getByCommand(command);
    }

    public List<BotDialogElement> getDialogElements() throws BGException {
        return this.dialogElementDao.getElements();
    }

    public List<BotDialogElement> getElementsByIds(List<Integer> ids) throws BGException {
        return this.dialogElementDao.getElementsByIds(ids);
    }

    public int updateDialogElement(BotDialogElement element) throws BGException {
        return this.dialogElementDao.updateElement(element);
    }

    public void updateDialogElements(List<BotDialogElement> elements) throws BGException {
        if (elements != null) {
            for (BotDialogElement element : elements) {
                this.updateDialogElement(element);
            }
        }
    }

    public void updateDialogGroups(List<BotDialogGroup> groups) {
        groups.forEach(group -> {
            try {
                this.dialogGroupDao.update(group);
            }
            catch (BGException e) {
                logger.error((Object)e);
            }
        });
    }

    public void deleteDialogElement(BotDialogElement element) throws BGException {
        this.dialogDao.getDialogs().stream().filter(dialog -> element.getDialogIds().contains(dialog.getId())).collect(Collectors.toList()).forEach(dialog -> {
            dialog.getDialogElements().removeIf(dialogElement -> dialogElement.getId() == element.getId());
            try {
                this.updateDialog((BotDialog)dialog);
            }
            catch (BGException e) {
                logger.error((Object)e);
            }
        });
        if (element.getElementType().equals((Object)BotDialogElementType.ATTACHMENT)) {
            try {
                this.fileStorage.deleteByOwner(element.getId());
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        this.dialogElementDao.delete(element.getId());
    }

    public List<BotDialogElement> getElementsOfDialog(int dialogId) throws BGException {
        return this.dialogElementDao.getElementsOfDialog(dialogId);
    }

    public List<BotDialogGroup> getDialogGroups() throws BGException {
        return this.dialogGroupDao.getGroupList();
    }

    public void updateDialogGroup(BotDialogGroup group) throws BGException {
        this.dialogGroupDao.update(group);
    }

    public void deleteDialogGroup(BotDialogGroup group) throws BGException {
        this.dialogGroupDao.delete(group.getId());
    }

    public List<BotDialog> getDialogsByGroupId(int dialogGroupId) throws BGException {
        return this.dialogDao.getDialogListByGroupId(dialogGroupId);
    }

    public void reloadDialogProcessingClasses() throws BGException {
        BotManagment.getInstance().reloadDialogProcessing();
    }

    public List<DialogProcessingWrapper> getDialogProcessingClasses() throws BGException {
        this.reloadDialogProcessingClasses();
        ArrayList<DialogProcessingWrapper> wrappers = new ArrayList<DialogProcessingWrapper>();
        BotManagment.getInstance().getDialogProcessingClasses().values().forEach(clazz -> wrappers.add(new DialogProcessingWrapper(clazz.title(), clazz.getClass().getName())));
        return wrappers;
    }

    public byte[] getFile(int elementId) throws BGException {
        try {
            return this.getFileBytes(this.getFileByElementId(elementId));
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    public File getFileByElementId(int elementId) throws BGException {
        List files = this.fileStorage.getFilesListByOwner(elementId);
        if (files.size() == 0) {
            return null;
        }
        return new File(this.fileStorage.getFileName(((BGServerFile)files.get(0)).getId()));
    }

    private byte[] getFileBytes(File file) throws IOException {
        if (file == null) {
            return new byte[0];
        }
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] bytes = new byte[(int)file.length()];
            fis.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public void setFile(BotDialogElement element, byte[] fileBytes) throws BGException {
        if (fileBytes == null || fileBytes.length == 0) {
            return;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(fileBytes);){
            BGServerFile bgFile = new BGServerFile();
            bgFile.setTitle(element.getJSONConfig().optString("attachmentFileTitle"));
            bgFile.setSize((long)((InputStream)is).available());
            bgFile.setOwnerId(element.getId());
            bgFile.setComment("");
            bgFile.setDate(new Date());
            this.fileStorage.updateFile(bgFile);
            if (bgFile.getId() > 0) {
                this.fileStorage.saveStream(bgFile.getId(), (InputStream)is, FilenameUtils.getExtension((String)bgFile.getTitle()));
            }
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void updateSortPositionOfElements(Map<Integer, Integer> elementSorting) {
        this.dialogElementDao.updateSortingElements(elementSorting);
    }

    public SearchResult<StatisticNote> getStatistic(Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setList(new ArrayList());
        this.statisticDao.getList((SearchResult<StatisticNote>)searchResult);
        return searchResult;
    }

    public List<StatisticNote> getStatisticByContractId(int contractId) throws BGException {
        return this.statisticDao.getListByContractId(contractId);
    }

    public void clearStatisticByBotId(int botId) throws BGException {
        this.statisticDao.deleteByBotId(botId);
    }

    public void clearStatisticByContractId(int contractId) throws BGException {
        this.statisticDao.deleteByContractId(contractId);
    }

    public void updateStatisticNote(StatisticNote statisticNote) throws BGException {
        this.statisticDao.update(statisticNote);
    }
}

