/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;

public class ActionDealerContractFind
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        float summa;
        PreparedStatement ps;
        DecimalFormat df = new DecimalFormat("########0.00");
        int cid = this.getIntParameter("cid", -1);
        String title = this.getParameter("title", null);
        String comment = "";
        if (title == null) {
            throw new BGMessageException("title = " + title);
        }
        boolean patternOk = false;
        String contractPattern = this.moduleSetup.get("contract.pattern", null);
        if (contractPattern != null) {
            StringTokenizer st = new StringTokenizer(contractPattern, ";");
            while (st.hasMoreTokens()) {
                String pattern = st.nextToken().trim();
                if (pattern.length() == title.length()) {
                    patternOk = true;
                    for (int i = 0; i < pattern.length(); ++i) {
                        char ch = pattern.charAt(i);
                        if (ch == '#' || ch == title.charAt(i)) continue;
                        patternOk = false;
                        break;
                    }
                }
                if (!patternOk) continue;
                break;
            }
        }
        if (!patternOk) {
            throw new BGMessageException("patternOk = " + patternOk);
        }
        String firmId = this.moduleSetup.get("firm.id", null);
        if (cid > 0) {
            String query = "SELECT title, comment FROM contract WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (title.equalsIgnoreCase(rs.getString(1))) {
                    comment = rs.getString(2);
                    continue;
                }
                cid = -1;
            }
            ps.close();
        }
        if (cid < 0) {
            String query = "SELECT id, comment FROM contract WHERE UPPER(title)=?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, title.toUpperCase());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                cid = rs.getInt(1);
                comment = rs.getString(2);
            }
            ps.close();
        }
        if (cid > 0) {
            summa = 0.0f;
            String query = "SELECT summa1 + summa2 - summa3 - summa4 FROM contract_balance WHERE cid=? ORDER BY yy DESC, mm DESC LIMIT 1";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                summa = rs.getFloat(1);
            }
        } else {
            throw new BGMessageException("contract not found [" + title + "]");
        }
        ps.close();
        Element contract = this.createElement(this.rootNode, "contract");
        this.createParamElement(contract, "id", String.valueOf(cid));
        this.createParamElement(contract, "title", title);
        this.createParamElement(contract, "comment", comment);
        this.createParamElement(contract, "summa", df.format(summa));
        this.createParamElement(contract, "firm_id", firmId);
    }

    private void createParamElement(Element contract, String name, String value) {
        if (contract != null) {
            Element param = this.createElement(contract, "param");
            if (name != null) {
                param.setAttribute("name", name);
            }
            if (value != null) {
                param.setAttribute("value", value);
            }
        }
    }
}

