/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ActionFilterCardInfo
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        Page page = this.getPage();
        Period period = this.getPeriod();
        int mid = this.getIntParameter("mid", -1);
        int did = this.getIntParameter("did", -1);
        int locked = this.getIntParameter("locked", -1);
        int sale = this.getIntParameter("sale", -1);
        int contract = this.getIntParameter("contract", -1);
        int balance = this.getIntParameter("balance", -1);
        int num = this.getIntParameter("num", -1);
        int count = this.getIntParameter("count", -1);
        String from = this.getParameter("from");
        String till = this.getParameter("till");
        String dateType = this.getParameter("date_type", "");
        String login = this.getParameter("login");
        String pass = this.getParameter("pass");
        if (mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        String[] statusTitle = new String[]{this.moduleSetup.get("status.title.lock", "Lock"), this.moduleSetup.get("status.title.pay", "Pay"), this.moduleSetup.get("status.title.contract", "Contract"), this.moduleSetup.get("status.title.balance", "Balance")};
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        StringBuffer buf = new StringBuffer();
        buf.append(" WHERE 1>0 ");
        if (did > 0) {
            buf.append(" AND did=");
            buf.append(did);
        }
        if (from != null && from.length() > 0) {
            buf.append(" AND summa>=");
            buf.append(from);
        }
        if (till != null && till.length() > 0) {
            buf.append(" AND summa<=");
            buf.append(till);
        }
        if (login != null && login.length() > 0) {
            buf.append(" AND card_data.card_code=");
            buf.append(login);
        }
        if (pass != null && pass.length() > 0) {
            buf.append(" AND card_data.card_pin_code='");
            buf.append(pass);
            buf.append("'");
        }
        if (period.getDateFrom() != null && Utils.notBlankString((String)dateType)) {
            buf.append(" AND TO_DAYS(");
            buf.append(dateType);
            buf.append(")>=TO_DAYS('");
            buf.append(TimeUtils.formatSQLDate((Date)period.getDateFrom()));
            buf.append("') ");
        }
        if (period.getDateTo() != null && Utils.notBlankString((String)dateType)) {
            buf.append(" AND TO_DAYS(");
            buf.append(dateType);
            buf.append(")<=TO_DAYS('");
            buf.append(TimeUtils.formatSQLDate((Date)period.getDateTo()));
            buf.append("') ");
        }
        if (contract > 0 || sale > 0 || balance > 0 || locked >= 0) {
            buf.append(" AND card_data.status IN ( ");
            buf.append(contract);
            buf.append(",");
            buf.append(sale);
            buf.append(",");
            buf.append(balance);
            buf.append(",");
            buf.append(locked);
            buf.append(" )");
        }
        if (num > 0 && count >= 0) {
            buf.append(" AND card_data.id>=");
            buf.append(num);
            buf.append(" AND card_data.id<=");
            buf.append(num + count);
        }
        String query = "SELECT * FROM card_data_" + mid + " AS card_data LEFT JOIN card_dealer_" + mid + " AS card_dealer ON card_data.did=card_dealer.id " + buf.toString() + " ORDER BY card_data.id LIMIT ?, ?";
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        int i = 1;
        ps.setInt(i++, page.getPageFirstRecordNumber());
        ps.setInt(i++, page.getPageSize());
        ContractUtils cu = new ContractUtils(this.con);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int status = rs.getInt("status");
            if (status < 0 || status >= statusTitle.length) {
                status = 0;
            }
            Element row = this.createElement(data, "row");
            row.setAttribute("f0", rs.getString("id"));
            row.setAttribute("f1", rs.getString("title"));
            row.setAttribute("f2", statusTitle[status]);
            row.setAttribute("f3", rs.getString("summa"));
            row.setAttribute("f4", TimeUtils.formatDate((Date)rs.getDate("d_date")));
            row.setAttribute("f5", TimeUtils.format((Date)rs.getDate("date"), (String)"dd.MM.yyyy"));
            row.setAttribute("f6", rs.getString("card_code"));
            row.setAttribute("f7", rs.getString("card_pin_code"));
            row.setAttribute("period", TimeUtils.formatPeriod((Date)rs.getDate("date1"), (Date)rs.getDate("date2")));
            row.setAttribute("cid", rs.getString("cid"));
            if (rs.getInt("cid") <= 0) continue;
            row.setAttribute("contract", cu.getContractTitle(rs.getInt("cid"), false));
        }
        rs.close();
        ps.close();
        int records = 1;
        query = "SELECT count(*), sum(summa) FROM card_data_" + mid + " AS card_data " + buf.toString();
        ps = this.con.prepareStatement(query);
        rs = ps.executeQuery();
        int summa = 0;
        while (rs.next()) {
            records = rs.getInt(1);
            summa = rs.getInt(2);
        }
        rs.close();
        ps.close();
        page.setRecordCount(records);
        table.setAttribute("summa", String.valueOf(summa));
        table.setAttribute("allRecord", String.valueOf(records));
        this.setPageAttribute(table, page);
    }
}

