/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.idealer.findbean;

import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class Find {
    protected int mid;
    protected String mode;
    protected int pid;
    protected String title;
    protected boolean periodCheck;

    public Find(int mid, String mode, int pid, String title, boolean periodCheck) {
        this.mid = mid;
        this.mode = mode;
        this.pid = pid;
        this.title = title;
        this.periodCheck = periodCheck;
    }

    public String getValue(int id, HttpServletRequest request) {
        Object result = "";
        if (this.mode.equals("contract")) {
            result = request.getParameter("contract_title_" + id);
        } else if (this.mode.equals("comment")) {
            result = request.getParameter("comment_" + id);
        } else if (this.mode.equals("parameter")) {
            result = request.getParameter("param_" + id);
        } else if (this.mode.equals("cerbercrypt")) {
            result = request.getParameter("cerber_card_" + id);
        } else if (this.mode.equals("login")) {
            result = request.getParameter("login_dialup_" + id);
            if (result == null || ((String)result).isEmpty()) {
                result = request.getParameter("login_voip_" + id);
            }
        } else if (this.mode.equals("login_voip")) {
            result = request.getParameter("login_voip_" + id);
        } else if (this.mode.equals("login_inet")) {
            result = request.getParameter("login_inet_" + id);
        } else if (this.mode.equals("login_dialup")) {
            result = request.getParameter("login_dialup_" + id);
        } else if (this.mode.equals("phone")) {
            result = request.getParameter("phone_number_" + id);
        } else if (this.mode.equals("address")) {
            String streetId = this.getParameter(request, "address_street_" + id, "0");
            String houseAndFrac = this.getParameter(request, "address_house_frac_" + id, "");
            String house = "";
            String frac = "";
            if (!houseAndFrac.isEmpty()) {
                house = AddressUtils.getHouse((String)houseAndFrac);
                frac = AddressUtils.getHouseFrac((String)houseAndFrac);
            } else {
                house = this.getParameter(request, "address_house_" + id, "");
                frac = this.getParameter(request, "address_frac_" + id, "");
            }
            String flat = this.getParameter(request, "address_flat_" + id, "0");
            if (Utils.parseInt((String)streetId) > 0) {
                result = "{" + streetId + "}{" + house + "}{" + frac + "}{" + flat + "}";
            }
        }
        return result;
    }

    private String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String result = defaultValue;
        if (request != null && name != null && ((result = request.getParameter(name)) == null || result.isEmpty())) {
            result = defaultValue;
        }
        return result;
    }

    public void addMode(Node node, int id) {
        Element modeEl = node.getOwnerDocument().createElement("mode");
        modeEl.setAttribute("id", String.valueOf(id));
        modeEl.setAttribute("title", this.title);
        if (this.mode.equals("login") || this.mode.equals("login_dialup")) {
            modeEl.setAttribute("name", "dialup");
            Element paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "login_dialup");
            modeEl.appendChild(paramEl);
        } else if (this.mode.equals("login_voip")) {
            modeEl.setAttribute("name", "voip");
            Element paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "login_voip");
            modeEl.appendChild(paramEl);
        } else if (this.mode.equals("login_inet")) {
            modeEl.setAttribute("name", "inet");
            Element paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "login_inet");
            modeEl.appendChild(paramEl);
        } else if (this.mode.equals("cerbercrypt")) {
            modeEl.setAttribute("name", "cerbercrypt");
            Element paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "cerber_card");
            modeEl.appendChild(paramEl);
        } else if (this.mode.equals("contract")) {
            modeEl.setAttribute("name", "kernel_contract");
            Element paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "contract_title");
            modeEl.appendChild(paramEl);
        } else if (this.mode.equals("comment")) {
            modeEl.setAttribute("name", "kernel_comment");
            Element paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "comment");
            modeEl.appendChild(paramEl);
        } else if (this.mode.equals("parameter")) {
            modeEl.setAttribute("name", "kernel_text_param");
            Element paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "param");
            modeEl.appendChild(paramEl);
        } else if (this.mode.equals("phone")) {
            modeEl.setAttribute("name", "phone");
            Element paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "phone_number");
            modeEl.appendChild(paramEl);
        } else if (this.mode.equals("address")) {
            modeEl.setAttribute("name", "kernel_address");
            Element paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "address_street");
            modeEl.appendChild(paramEl);
            paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "address_house_frac");
            modeEl.appendChild(paramEl);
            paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "address_flat");
            modeEl.appendChild(paramEl);
            paramEl = node.getOwnerDocument().createElement("param");
            paramEl.setAttribute("name", "address_room");
            modeEl.appendChild(paramEl);
        }
        node.appendChild(modeEl);
    }
}

