/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.common.event;

import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;

@EventType(autoAcknowledge=false)
@XmlRootElement
public class CardActivateRequestEvent
extends QueueEvent {
    public static final int STATUS_ACTIVATION_SUCCEEDED = 0;
    public static final int STATUS_INVALID_ACCOUNT = 1;
    public static final int STATUS_INVALID_PIN = 2;
    public static final int STATUS_CARD_EXPIRED = 30;
    public static final int STATUS_CARD_LOCKED = 31;
    public static final int STATUS_CARD_FOR_BALANCE = 32;
    public static final int STATUS_CARD_DEVICE_DENY = 33;
    public static final int STATUS_SERVER_ERROR = 100;
    @XmlAttribute
    private final Set<Integer> activateServiceIds;
    @XmlAttribute
    private final long cardId;
    @XmlAttribute
    private final String cardNumber;
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int activateModuleId;
    @XmlAttribute
    private int status = 100;

    protected CardActivateRequestEvent() {
        this.activateServiceIds = null;
        this.cardId = -1L;
        this.cardNumber = null;
        this.deviceId = -1;
        this.activateModuleId = -1;
    }

    public CardActivateRequestEvent(int moduleId, Set<Integer> services, long cardId, String cardNumber, int deviceId, int activateModuleId) {
        super(moduleId, CONTRACT_GLOBAL, -1);
        this.activateServiceIds = services;
        this.cardId = cardId;
        this.cardNumber = cardNumber;
        this.deviceId = deviceId;
        this.activateModuleId = activateModuleId;
    }

    public Set<Integer> getActivateServiceIds() {
        return this.activateServiceIds;
    }

    public long getCardId() {
        return this.cardId;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getActivateModuleId() {
        return this.activateModuleId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public static int statusToAccessCode(int status) {
        switch (status) {
            case 0: {
                return 0;
            }
            case 33: {
                return 40;
            }
            case 30: {
                return 30;
            }
            case 32: {
                return 32;
            }
            case 31: {
                return 31;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 100;
    }
}

