/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.task;

import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.AutoprintProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class AutoprintReprintAutoBatch
extends RunTask {
    private List<Payment> logPayments;

    public AutoprintReprintAutoBatch(List<Payment> logPayments) {
        this.logPayments = logPayments;
    }

    public String getDescription() {
        return "\u041f\u043b\u0430\u0433\u0438\u043d CashCheck. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0440\u0435\u043f\u0435\u0447\u0430\u0442\u0438 \u0438\u0437 \u043b\u043e\u0433\u0430 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0445 auto- \u0438 delay-\u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 (" + this.logPayments.size() + "\u0448\u0442)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            this.processQueue(con, conSlave);
        }
        catch (Exception e) {
            this.log.error("error AutoprintReprintAutoBatch task", (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
        }
    }

    private void processQueue(Connection con, Connection conSlave) throws BGException {
        try (PaymentDao pm = new PaymentDao(con);){
            this.log.info("cashcheck autoprint: reprint error batch: queue size: " + this.logPayments.size() + "...");
            for (Payment p : this.logPayments) {
                ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment bgpayment = (ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment)pm.get(p.getPaymentId());
                AutoprintProcessor.processErroredPayment(bgpayment, p.getLogId(), this.setup, con, conSlave);
                try {
                    CashCheckUtils.sleepBatch();
                }
                catch (InterruptedException e) {
                    pm.close();
                    return;
                }
            }
        }
    }

    public String getUniqueKeyQueue() {
        List logids = this.logPayments.stream().map(p -> p.getLogId()).collect(Collectors.toList());
        return "cashcheck-reprint-" + Utils.toString(logids);
    }

    public String getUniqueKeyParallel() {
        return "cashcheck-reprint";
    }
}

