package ru.bitel.bgbilling.modules.cashcheck.dyn;

import java.math.BigDecimal;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.Fiscalizator;

/**
 * Пример фискализатора в дин.коде, имплементированы только обязательные методы, остальные см. в родительском Fiscalizator.
 * Это НЕ ШАБЛОН ЧЕКА, а реализация способа фискализации.
 * @author dimon
 */
public class SimpleDyncodeFiscalizator
    extends Fiscalizator
{
    public SimpleDyncodeFiscalizator(Printer printer) throws BGException
    {
        super(printer);
    }

    @Override
    public String check(String oppass, BigDecimal clientsumma, Check check) throws BGException
    {
        System.out.println("check");
        return "do check";
    }

    @Override
    public String checkreturn(String oppass, BigDecimal clientsumma, Check check) throws BGException
    {
        System.out.println("checkreturn");
        return "do check";
    }

    @Override
    public String status(String pass) throws BGException
    {
        return "ok";
    }

    @Override
    public String name(String pass) throws BGException
    {
        return "фискализатор в дин.коде";
    }

    @Override
    public String getFiscalizatorStatus() throws BGException
    {
        return "нормально";
    }

    @Override
    public boolean isAsynchronous()
    {
        return false;
    }
}
