/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.cticas4;

import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;

public class CtiCas4Exception
extends BGException {
    private final Map<Integer, String> ERRORS = new HashMap<Integer, String>(){
        {
            this.put(0, "Received OK");
            this.put(10, "Wrong Protocol ID");
            this.put(11, "Undefined SMS ID");
            this.put(12, "Unknown CI Command");
            this.put(13, "Wrong DL");
            this.put(14, "Unknown PI Command");
            this.put(15, "One Required Parameter Missing");
            this.put(16, "Same Parameter Found Several Times");
            this.put(17, "Two Parameters Incompatible");
            this.put(18, "Wrong Parameter Value");
            this.put(19, "Smart Card not Exist");
            this.put(20, "Package ID not Exist");
            this.put(21, "Wrong PPV Money");
            this.put(22, "Can not Handled Interface Command");
            this.put(23, "Provider\u2019s Channel does not Exist");
            this.put(24, "Provider\u2019s Package does not Exist");
            this.put(25, "No Corresponding Program on this Date");
            this.put(26, "BlackOut Region Amount Overflow");
            this.put(27, "Package already Ordered");
            this.put(28, "Smart Card unable to Stop");
            this.put(29, "Smart Card unable to Unregister (Cancel)");
            this.put(30, "Smart Card unable to Delete");
            this.put(31, "Smart Card unable to Resume");
            this.put(32, "Smart Card unable to Operate in this Status");
            this.put(33, "Program ID Authorization already Existed");
            this.put(34, "Number of Days must greater than 0");
            this.put(35, "Begin Time must greater than Present Time");
            this.put(36, "Send Times must greater than 0");
            this.put(37, "Message ID must greater than 0");
            this.put(38, "Message ID not Exist");
            this.put(39, "Message ID already Existed");
            this.put(50, "TLV Structure Error");
            this.put(51, "Unknown PI");
            this.put(52, "Wrong PL");
            this.put(53, "Message Length too long");
            this.put(54, "Parameter Missing in this Command");
            this.put(55, "Parameter Variable String out of limit");
            this.put(56, "Smart Card already Existed");
            this.put(57, "Master Card not Selected (Master Card not Register)");
            this.put(58, "Smart Card not Register, unable Operated");
            this.put(60, "Master Card and Slave Card Number Same");
            this.put(61, "BeginID is bigger than MaxID");
            this.put(62, "StartDate is greater than EndDate");
            this.put(63, "Cancel Package not Authorized");
            this.put(64, "Cancel Program not Authorized");
            this.put(65, "Delete Region not Existed");
            this.put(66, "Region Amount greater than 32, unable Increase");
            this.put(67, "Region already Existed");
            this.put(68, "Smart Card Authorization not Existed");
            this.put(69, "Region not Existed");
            this.put(70, "None Program Information");
            this.put(71, "PIN Code Wrong");
            this.put(72, "Fingerprint Position value out of the Range");
            this.put(73, "Fingerprint Status value out of the Range");
            this.put(74, "Fingerprint Flag value out of the Range");
            this.put(75, "CCA Number missing");
            this.put(76, "GCA Number missing");
            this.put(77, "End Time must greater than Present Time");
            this.put(78, "Smart Card Stop/Resume Operation and Region Stop/Resume Operation Incompatible");
            this.put(79, "CtrlCUSTWD value not in (1-256)");
            this.put(80, "CCA Number could not be NULL");
            this.put(81, "CCA Number is not Existed");
            this.put(82, "GCA Number could not be NULL");
            this.put(83, "GCA Number is not Existed");
            this.put(84, "CCA Region Command is valid, could not operate for Smart Card");
            this.put(85, "This Smart Card is a Slave Card, could not use like a Master Card");
            this.put(86, "This Smart Card is a Master Card, could not use like a Slave Card");
            this.put(87, "New Smart Card Number could not be the Same with Old Smart Card Number");
            this.put(88, "CCA Registered for a Smart Card, could not Delete");
            this.put(89, "GCA Registered for a Smart Card, could not Delete");
            this.put(90, "Program ID is not Exist");
            this.put(110, "Server Open Database Source Failed, unable Operated");
            this.put(111, "Open Database Session Failed, unable Operated");
            this.put(112, "None PPID Existed");
            this.put(113, "Database Operated Failed");
            this.put(114, "Illegal Parameter");
            this.put(255, "Other Error");
        }
    };
    private int commandNumber;
    private int errorNumber;
    private long cardNumber;

    public CtiCas4Exception(int commandNumber, int errorNumber, long cardNumber) {
        this.commandNumber = commandNumber;
        this.errorNumber = errorNumber;
        this.cardNumber = cardNumber;
    }

    public String getMessage() {
        return String.format("CAS command %d%s error %02d: %s", this.commandNumber, this.cardNumber > 0L ? " (card " + this.cardNumber + ")" : "", this.errorNumber, this.ERRORS.containsKey(this.errorNumber) ? this.ERRORS.get(this.errorNumber) : "UNKNOWN");
    }

    public int getErrorNumber() {
        return this.errorNumber;
    }
}

