/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.task;

import bitel.billing.server.util.MailMsg;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.Calculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class Recalculator
extends RunTaskRecalculator<Calculator> {
    private String cids;
    private String comment = null;

    public Recalculator(int mid, Calendar dt, String email, String cids, String comment) {
        super(mid, dt, email);
        this.cids = cids;
        this.comment = comment;
    }

    protected Calculator createTask() {
        Calculator calculator = new Calculator();
        calculator.setExecutingTime(this.dt);
        calculator.setCids(this.cids);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid + "\ncomment=" + this.comment);
        return calculator;
    }

    public void executeTask() {
        try {
            long start = System.currentTimeMillis();
            Calculator calculator = this.createTask();
            calculator.startTask();
            long end = System.currentTimeMillis();
            if (this.email != null) {
                String report = "\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 CerberCrypt \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e\n\u0412\u0440\u0435\u043c\u044f: " + TimeUtils.formatDeltaTime((long)((end - start) / 1000L));
                MailMsg msg = new MailMsg((Preferences)this.setup);
                msg.sendMessage(this.email, "\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 CerberCrypt \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e", report);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

