/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cladr.server;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.GetIndexPoint;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.plugins.cladr.server.dao.AddressDBFDAO;
import ru.bitel.bgbilling.plugins.cladr.server.finder.IndexFinder;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.function.Async;

public class PluginServerListener
extends IndexFinder
implements OnInitServer,
GetIndexPoint {
    private static final String DB_URL = "db.url";
    private static final String DB_CHARSET = "db.charset";
    private final Logger log = LogManager.getLogger();

    public void onInitServer(String applicationName) {
        Async.of(() -> {
            Path dbfPath;
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cladr");
            String dbUrl = plugin.getSetup().get(DB_URL, null);
            if (dbUrl != null && Files.exists(dbfPath = Paths.get(dbUrl.startsWith("jdbc:DBF:///") ? dbUrl.substring(12) : dbUrl, new String[0]), new LinkOption[0])) {
                try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                    String toPath = TimeUtils.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MM_dd_HHmm");
                    Path loadedPath = Paths.get(dbfPath.toString(), "loaded");
                    if (Files.notExists(loadedPath, new LinkOption[0])) {
                        try {
                            Files.createDirectory(loadedPath, new FileAttribute[0]);
                        }
                        catch (IOException e) {
                            this.log.error((Object)e);
                        }
                    }
                    Files.list(dbfPath).forEach(p -> {
                        if (Files.isDirectory(p, new LinkOption[0])) {
                            return;
                        }
                        String fileName = p.getFileName().toString().toLowerCase();
                        if (fileName.endsWith(".dbf")) {
                            String tableName = "cladr_i_" + fileName.substring(0, fileName.length() - 4).replaceAll("[^a-z]", "");
                            try (PreparedStatement psDrop = con.prepareStatement("DROP TABLE IF EXISTS " + tableName);){
                                psDrop.executeUpdate();
                            }
                            catch (Exception e1) {
                                this.log.error((Object)e1);
                            }
                            try (FileInputStream fileInputStream = new FileInputStream(p.toString());){
                                DBFReader reader = new DBFReader((InputStream)fileInputStream, Charset.forName(plugin.getSetup().get(DB_CHARSET, "cp866")));
                                StringBuilder query = new StringBuilder("CREATE TABLE " + tableName + " ( ");
                                int numberOfFields = reader.getFieldCount();
                                for (int i = 0; i < numberOfFields; ++i) {
                                    DBFField field = reader.getField(i);
                                    if (i > 0) {
                                        query.append(", ");
                                    }
                                    query.append("`" + field.getName() + "` varchar(" + field.getLength() + ")");
                                }
                                query.append(" )");
                                try (PreparedStatement psCreate = con.prepareStatement(query.toString());){
                                    psCreate.executeUpdate();
                                }
                                catch (Exception e1) {
                                    this.log.error((Object)e1);
                                }
                                int maxRecord = 1000;
                                int count = 0;
                                HashMap<String, PreparedStatement> psMap = new HashMap<String, PreparedStatement>();
                                List<Object[]> records = null;
                                while (!(records = this.getNextRecords(reader, maxRecord)).isEmpty()) {
                                    this.insertRecords(this.getInsertPs(psMap, con, tableName, maxRecord, numberOfFields), records);
                                    count += records.size();
                                }
                                for (PreparedStatement ps : psMap.values()) {
                                    ps.close();
                                }
                            }
                            catch (Exception e) {
                                this.log.error("File => {}; ExceptiongetMessage() = {}", (Object)fileName, (Object)e.getMessage());
                            }
                            Path path = Paths.get(loadedPath.toString(), toPath);
                            if (Files.notExists(path, new LinkOption[0])) {
                                try {
                                    Files.createDirectory(path, new FileAttribute[0]);
                                }
                                catch (IOException e) {
                                    this.log.error((Object)e);
                                }
                            }
                            try {
                                Files.move(p, Paths.get(path.toString(), p.getFileName().toString()), new CopyOption[0]);
                            }
                            catch (IOException e) {
                                this.log.error((Object)e);
                            }
                        }
                    });
                    new AddressDBFDAO(con, LogManager.getLogger()).addIndex();
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
        });
    }

    private List<Object[]> getNextRecords(DBFReader reader, int maxRecord) throws DBFException {
        Object[] rowObjects;
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        while ((rowObjects = reader.nextRecord()) != null && maxRecord > 0) {
            records.add(rowObjects);
            --maxRecord;
        }
        return records;
    }

    private void insertRecords(PreparedStatement psInsert, List<Object[]> objectList) throws Exception {
        int index = 1;
        for (Object[] rowObjects : objectList) {
            for (int i = 0; i < rowObjects.length; ++i) {
                psInsert.setString(index++, new String(((String)rowObjects[i]).getBytes("latin1"), "Cp866").trim());
            }
        }
        psInsert.executeUpdate();
    }

    private PreparedStatement getInsertPs(Map<String, PreparedStatement> psMap, Connection con, String tableName, int insertRecord, int numberOfFields) throws SQLException {
        String key = tableName + insertRecord;
        PreparedStatement psInsert = psMap.get(key);
        if (psInsert == null) {
            Object a = "( ?";
            for (int i = 1; i < numberOfFields; ++i) {
                a = (String)a + ", ?";
            }
            a = (String)a + " )";
            String insertQuery = "INSERT INTO " + tableName + " VALUES ";
            for (int i = 0; i < insertRecord; ++i) {
                if (i > 0) {
                    insertQuery = insertQuery + ", ";
                }
                insertQuery = insertQuery + (String)a;
            }
            psInsert = con.prepareStatement(insertQuery);
            psMap.put(key, psInsert);
        }
        return psInsert;
    }
}

