/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.call.bean.LoginManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLogin;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLoginManager;
import ru.bitel.bgbilling.modules.dialup.server.bean.IpAddr;
import ru.bitel.bgbilling.modules.dialup.server.bean.LoginIpManager;
import ru.bitel.bgbilling.modules.dialup.server.event.bus.DialUpLoginIpChangedEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class Module
extends bitel.billing.server.call.Module {
    public String[] getServerPackages() {
        String[] array = new String[]{"bitel.billing.server.dialup", "bitel.billing.server.call"};
        return array;
    }

    protected void addLoginOptions(Connection con, XMLStreamWriter tables, String lid, int mid) throws SQLException, XMLStreamException {
        super.addLoginOptions(con, tables, lid, mid);
        List limits = ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("user_login_limit_" + mid), (String)"lid", (String)lid, (String)"id", (boolean)false, null, null);
        for (String llid : limits) {
            ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("user_login_condition_" + mid), (String)"llid", (String)llid, null, (boolean)false, null, null);
        }
    }

    protected void deleteLoginData(Connection con, String lid, int mid) throws SQLException {
        super.deleteLoginData(con, lid, mid);
        List limits = ServerUtils.deleteRowsFromTable((Connection)con, (String)("user_login_limit_" + mid), (String)"lid", (String)lid, (String)"id");
        for (String limitId : limits) {
            ServerUtils.deleteRowsFromTable((Connection)con, (String)("user_login_condition_" + mid), (String)"llid", (String)limitId, null);
        }
    }

    protected LoginManager getLoginManager(Connection con, int mid) {
        return new DialUpLoginManager(con, mid);
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        ContractWrapEvent wrapEvent;
        Connection con;
        if (event instanceof ContractCreateEvent) {
            ContractCreateEvent ccEvent = (ContractCreateEvent)event;
            con = ctx.getConnection();
            Document dataDoc = ccEvent.getPattern().getData();
            Element addLogin = XMLUtils.selectElement((Node)dataDoc, (String)("data/modules/dialup[@mid=" + mid + "]/addLogin[@enable=1]"));
            if (addLogin != null) {
                DialUpLoginManager dlu = new DialUpLoginManager(con, mid);
                if (ccEvent.isCheck()) {
                    ccEvent.setError(dlu.checkLoginAvailable((Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(mid))));
                } else {
                    try {
                        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(mid));
                        if (dlu.checkLoginAvailable((Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(mid))) == null) {
                            DialUpLogin login = new DialUpLogin();
                            login.setCid(ccEvent.getContractId());
                            login.setDate1(new Date());
                            login.setDate2(null);
                            login.setStatus(Utils.parseInt((String)addLogin.getAttribute("access"), (int)1) == 0);
                            login.setMaxSession(Utils.parseInt((String)addLogin.getAttribute("session"), (int)1));
                            login.setComment("");
                            login.setObjectId(0);
                            String pswd = PswdGen.generatePassword((ParameterMap)moduleSetup);
                            login.setPswd(pswd);
                            login = dlu.addLogin(login, (Preferences)moduleSetup);
                            for (Element service : XMLUtils.selectElements((Node)addLogin, (String)"limit/service")) {
                                ArrayList<int[]> conds = new ArrayList<int[]>();
                                for (Node node = service.getFirstChild(); node != null; node = node.getNextSibling()) {
                                    if (node.getNodeType() != 1 || !"item".equals(node.getNodeName())) continue;
                                    Element item = (Element)node;
                                    int[] c = new int[]{Utils.parseInt((String)item.getAttribute("hh")), Utils.parseInt((String)item.getAttribute("dw")), Utils.parseInt((String)item.getAttribute("dm")), Utils.parseInt((String)item.getAttribute("mm"))};
                                    conds.add(c);
                                }
                                dlu.updateLimitService(login.getId(), service.getAttribute("sid"), Utils.parseInt((String)service.getAttribute("type")), service.getAttribute("param1"), service.getAttribute("param2"), TimeUtils.parseCalendar((String)service.getAttribute("date1"), (String)"dd.MM.yyyy"), TimeUtils.parseCalendar((String)service.getAttribute("date2"), (String)"dd.MM.yyyy"), service.getAttribute("comment"), Utils.parseInt((String)service.getAttribute("num")), conds);
                            }
                            for (Object realmOptions : XMLUtils.selectElements((Node)addLogin, (String)"attributes/realmOptions")) {
                                dlu.updateRealmOptions(login.getId(), Utils.parseInt((String)realmOptions.getAttribute("rp_mode")), realmOptions.getAttribute("realm_group"));
                            }
                            ArrayList<String[]> attributes = new ArrayList<String[]>();
                            for (Element attribute : XMLUtils.selectElements((Node)addLogin, (String)"attributes/table/data/attr")) {
                                String[] attr = new String[]{attribute.getAttribute("attribute"), attribute.getAttribute("value"), attribute.getAttribute("realm")};
                                attributes.add(attr);
                            }
                            if (attributes.size() > 0) {
                                dlu.updateAttributes(login.getId(), attributes);
                            }
                            ArrayList<String[]> attrSets = new ArrayList<String[]>();
                            for (Element attrSet : XMLUtils.selectElements((Node)addLogin, (String)"attributes/set_table/data/set")) {
                                String[] set = new String[3];
                                set[0] = attrSet.getAttribute("setId");
                                set[1] = attrSet.getAttribute("realm");
                                attrSets.add(set);
                            }
                            if (attrSets.size() > 0) {
                                dlu.updateAttributeSet(login.getId(), attrSets);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            super.moduleAction(ctx, mid, event);
        }
        if (event instanceof ContractCloseEvent) {
            ContractCloseEvent cEvent = (ContractCloseEvent)event;
            con = ctx.getConnection();
            if (!cEvent.isCheck()) {
                String query = "UPDATE radius_pair_ip_" + mid + " SET date2=? WHERE id in ( SELECT id from user_login_" + mid + " WHERE cid=?) AND date2 IS NULL";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)cEvent.getDate()));
                ps.setInt(2, cEvent.getContractId());
                ps.executeUpdate();
                ps.close();
            }
        } else if (event instanceof ContractWrapEvent && !(wrapEvent = (ContractWrapEvent)event).isCheck()) {
            con = ctx.getConnection();
            LoginIpManager loginIpManager = new LoginIpManager(con, mid);
            DialUpLoginManager manager = new DialUpLoginManager(con, mid);
            this.sendIpChangedEvent(mid, loginIpManager, manager, wrapEvent.getContractId());
            this.sendIpChangedEvent(mid, loginIpManager, manager, wrapEvent.getToContractId());
        }
    }

    public void sendIpChangedEvent(int mid, LoginIpManager loginIpManager, DialUpLoginManager manager, int contractId) {
        List logins = manager.getContractLogins(contractId);
        for (Login login : logins) {
            List<IpAddr> addrList = loginIpManager.getAllLoginsIps(login.getId());
            if (addrList.size() <= 0) continue;
            EventProcessor.getInstance().publishAfterCommit((Event)new DialUpLoginIpChangedEvent(mid, login.getId(), addrList));
        }
    }
}

