/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.bean;

import bitel.billing.server.MaxTrafficCalculator;
import bitel.billing.server.call.bean.Login;
import bitel.billing.server.call.bean.LoginManager;
import bitel.billing.server.util.MonthForRecalc;
import bitel.billing.server.util.db.ColumnValue;
import bitel.billing.server.util.db.TableCopier;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.dialup.server.MaxRecalculator;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLogin;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpSessionUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DialUpLoginManager
extends LoginManager {
    private PreparedStatement updateLimitServicePS = null;
    private PreparedStatement insertUserConditionPS = null;

    public DialUpLoginManager(Connection con, int moduleId) {
        super(con, moduleId);
    }

    public DialUpLogin findLogin(String userName, java.util.Date date) {
        DialUpLogin login = null;
        if (Utils.isBlankString((String)userName)) {
            return login;
        }
        try {
            PreparedStatement ps = null;
            int numLogin = Utils.parseInt((String)userName, (int)Integer.MIN_VALUE);
            if (numLogin != Integer.MIN_VALUE) {
                String query = "SELECT * FROM " + this.tableName + " WHERE ( isNull(date1) OR date1<=? ) AND ( isNull(date2) OR date2>=? ) AND login=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(3, numLogin);
            } else {
                String query = "SELECT login.* FROM user_alias_" + this.mid + " AS alias INNER JOIN " + this.tableName + " AS login ON alias.login_id=login.id AND ( isNull(login.date1) OR login.date1<=? ) AND ( isNull(login.date2) OR login.date2>=? ) WHERE alias.login_alias=? AND LENGTH(alias.login_alias)=LENGTH(?)";
                ps = this.con.prepareStatement(query);
                ps.setString(3, userName);
                ps.setString(4, userName);
            }
            Date sqlDate = TimeUtils.convertDateToSqlDate((java.util.Date)date);
            ps.setDate(1, sqlDate);
            ps.setDate(2, sqlDate);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                login = this.getLoginFromResultSet(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return login;
    }

    public DialUpLogin addLogin(Login login, Preferences moduleSetup) {
        DialUpLogin result = null;
        try {
            String query = null;
            PreparedStatement ps = null;
            int topNocardLogin = moduleSetup.getInt("top.nocard.login", 10000);
            query = "INSERT INTO " + this.tableName + " ( cid, login, date1, date2, status, comment, object_id, session, pswd ) SELECT ?, IF(MAX(login) IS NULL, 0, MAX(login) + 1), ?, ?, ?, ?, ?, ?, ? FROM " + this.tableName + " WHERE login<" + topNocardLogin;
            ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, login.getCid());
            ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate1()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate2()));
            ps.setInt(4, login.getStatus() ? 0 : 1);
            ps.setString(5, login.getComment());
            ps.setInt(6, login.getObjectId());
            ps.setInt(7, login.getMaxSession());
            ps.setString(8, login.getPswd());
            ps.executeUpdate();
            result = (DialUpLogin)this.getLoginById(ServerUtils.lastInsertId((PreparedStatement)ps));
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateLogin(Login login) {
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "UPDATE user_login_" + this.mid + " SET date1=?, date2=?, status=?, session=?, comment=?, object_id=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate1()));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)login.getDate2()));
            ps.setInt(3, login.getStatus() ? 0 : 1);
            ps.setInt(4, login.getMaxSession());
            ps.setString(5, login.getComment());
            ps.setInt(6, login.getObjectId());
            ps.setInt(7, login.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected DialUpLogin getLoginFromResultSet(ResultSet rs) throws SQLException {
        DialUpLogin login = new DialUpLogin();
        login.setId(rs.getInt("id"));
        login.setCid(rs.getInt("cid"));
        login.setLogin(rs.getLong("login"));
        login.setPswd(rs.getString("pswd"));
        login.setStatus(rs.getInt("status") == 0);
        login.setMaxSession(rs.getInt("session"));
        login.setRpMode(rs.getInt("rp_mode"));
        login.setRealmGroup(rs.getString("realm_group"));
        login.setDate1(rs.getDate("date1"));
        login.setDate2(rs.getDate("date2"));
        login.setComment(rs.getString("comment"));
        login.setObjectId(rs.getInt("object_id"));
        return login;
    }

    public void updateLimitService(int lid, String sids, int type, String param1, String param2, Calendar date1, Calendar date2, String comment, int num, List<int[]> conditions) throws SQLException {
        if (this.updateLimitServicePS == null || this.updateLimitServicePS.getConnection() != this.con) {
            String query = "INSERT INTO user_login_limit_" + this.mid + " ( lid, sid, type_con, param1, param2, date1, date2, comment, num ) VALUES ( ?, ?,  ?, ?, ?, ?, ?, ?, ? )";
            this.updateLimitServicePS = this.con.prepareStatement(query, 1);
        }
        this.updateLimitServicePS.setInt(1, lid);
        this.updateLimitServicePS.setString(2, sids);
        this.updateLimitServicePS.setInt(3, type);
        this.updateLimitServicePS.setString(4, param1);
        this.updateLimitServicePS.setString(5, param2);
        this.updateLimitServicePS.setDate(6, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
        this.updateLimitServicePS.setDate(7, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
        this.updateLimitServicePS.setString(8, comment == null ? "" : comment.trim());
        this.updateLimitServicePS.setInt(9, num);
        this.updateLimitServicePS.executeUpdate();
        int llid = ServerUtils.lastInsertId((PreparedStatement)this.updateLimitServicePS);
        if (this.insertUserConditionPS == null || this.insertUserConditionPS.getConnection() != this.con) {
            String query = "INSERT INTO user_login_condition_" + this.mid + " VALUES ( ?, ?, ?, ?, ? )";
            this.insertUserConditionPS = this.con.prepareStatement(query, 1);
            this.insertUserConditionPS.setInt(1, llid);
        }
        for (int[] conds : conditions) {
            assert (conds.length == 4);
            this.insertUserConditionPS.setInt(2, conds[0]);
            this.insertUserConditionPS.setInt(3, conds[1]);
            this.insertUserConditionPS.setInt(4, conds[2]);
            this.insertUserConditionPS.setInt(5, conds[3]);
            this.insertUserConditionPS.executeUpdate();
        }
    }

    public void updateAttributeSet(int lid, List<String[]> sets) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM radius_pair_set_" + this.mid + " WHERE id=?");
        ps.setInt(1, lid);
        ps.executeUpdate();
        ps.close();
        ps = this.con.prepareStatement("INSERT INTO radius_pair_set_" + this.mid + " (id, set_id, realm) VALUES (?, ?, ?)");
        ps.setInt(1, lid);
        assert (sets != null);
        for (String[] set : sets) {
            assert (set.length == 2);
            ps.setInt(2, Utils.parseInt((String)set[0]));
            ps.setString(3, set[1]);
            ps.executeUpdate();
        }
        ps.close();
    }

    public final void updateRealmOptions(int lid, int rpMode, String realmGroup) throws SQLException {
        String query = "UPDATE user_login_" + this.mid + " SET rp_mode=?, realm_group=? WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, rpMode);
        ps.setString(2, realmGroup);
        ps.setInt(3, lid);
        ps.executeUpdate();
        ps.close();
    }

    public Set<Integer> loadAttrSet(int loginId, String realm) {
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT set_id FROM radius_pair_set_" + this.mid + " WHERE id=? AND realm=?");
            ps.setInt(1, loginId);
            ps.setString(2, realm);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected void moveLoginData(Login login, int cidFrom, int cidTo) throws SQLException {
        int lid = login.getId();
        Calendar date1 = TimeUtils.convertDateToCalendar((java.util.Date)login.getDate1());
        Calendar date2 = TimeUtils.convertDateToCalendar((java.util.Date)login.getDate2());
        String query = null;
        ResultSet rs = null;
        Calendar dateMonth = (Calendar)date1.clone();
        while (TimeUtils.monthsDelta((Calendar)dateMonth, (Calendar)date2) >= 0) {
            String sessionDetailTable = ServerUtils.getModuleMonthTableName((String)"session_detail", (java.util.Date)dateMonth.getTime(), (int)this.mid);
            String sessionAccountTable = ServerUtils.getModuleMonthTableName((String)"session_account", (java.util.Date)dateMonth.getTime(), (int)this.mid);
            String sessionTable = ServerUtils.getModuleMonthTableName((String)"log_session", (java.util.Date)dateMonth.getTime(), (int)this.mid);
            if (ServerUtils.tableExists((Connection)this.con, (String)sessionDetailTable) && ServerUtils.tableExists((Connection)this.con, (String)sessionAccountTable) && ServerUtils.tableExists((Connection)this.con, (String)sessionTable)) {
                StringBuilder sessionIdList = new StringBuilder(1000);
                query = "SELECT id FROM " + sessionTable + " WHERE lid=?";
                PreparedStatement psSelectSessions = this.con.prepareStatement(query);
                psSelectSessions.setInt(1, lid);
                rs = psSelectSessions.executeQuery();
                while (rs.next()) {
                    if (sessionIdList.length() > 0) {
                        sessionIdList.append(",");
                    }
                    sessionIdList.append(rs.getInt(1));
                }
                psSelectSessions.close();
                if (sessionIdList.length() > 0) {
                    query = "UPDATE " + sessionDetailTable + " SET cid=? WHERE session_id IN ( " + sessionIdList.toString() + " )";
                    PreparedStatement psUpdateSessionDetail = this.con.prepareStatement(query);
                    psUpdateSessionDetail.setInt(1, cidTo);
                    psUpdateSessionDetail.executeUpdate();
                    psUpdateSessionDetail.close();
                    query = "UPDATE " + sessionAccountTable + " SET cid=? WHERE session_id IN ( " + sessionIdList.toString() + " )";
                    PreparedStatement psUpdateSessionAccount = this.con.prepareStatement(query);
                    psUpdateSessionAccount.setInt(1, cidTo);
                    psUpdateSessionAccount.executeUpdate();
                    psUpdateSessionAccount.close();
                }
            }
            dateMonth.add(2, 1);
        }
    }

    protected void wrapLoginData(Login loginFrom, Login loginTo) throws SQLException {
        Calendar date1 = TimeUtils.convertDateToCalendar((java.util.Date)loginTo.getDate1());
        Calendar date2 = TimeUtils.convertDateToCalendar((java.util.Date)loginTo.getDate2());
        if (date2 == null) {
            date2 = new GregorianCalendar();
        }
        String query = null;
        ResultSet rs = null;
        Calendar dateMonth = (Calendar)date1.clone();
        while (TimeUtils.monthsDelta((Calendar)dateMonth, (Calendar)date2) >= 0) {
            String sessionDetailTable = ServerUtils.getModuleMonthTableName((String)"session_detail", (java.util.Date)dateMonth.getTime(), (int)this.mid);
            String sessionAccountTable = ServerUtils.getModuleMonthTableName((String)"session_account", (java.util.Date)dateMonth.getTime(), (int)this.mid);
            String sessionTable = ServerUtils.getModuleMonthTableName((String)"log_session", (java.util.Date)dateMonth.getTime(), (int)this.mid);
            if (ServerUtils.tableExists((Connection)this.con, (String)sessionDetailTable) && ServerUtils.tableExists((Connection)this.con, (String)sessionAccountTable) && ServerUtils.tableExists((Connection)this.con, (String)sessionTable)) {
                StringBuilder sessionIdList = new StringBuilder(1000);
                query = "SELECT id FROM " + sessionTable + " WHERE lid=? AND session_start>=?";
                PreparedStatement psSelectSessions = this.con.prepareStatement(query);
                psSelectSessions.setInt(1, loginFrom.getId());
                psSelectSessions.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
                rs = psSelectSessions.executeQuery();
                while (rs.next()) {
                    if (sessionIdList.length() > 0) {
                        sessionIdList.append(",");
                    }
                    sessionIdList.append(rs.getInt(1));
                }
                psSelectSessions.close();
                if (sessionIdList.length() > 0) {
                    query = "UPDATE " + sessionTable + " SET lid=? WHERE id IN ( " + sessionIdList.toString() + " )";
                    PreparedStatement psUpdateLogSession = this.con.prepareStatement(query);
                    psUpdateLogSession.setInt(1, loginTo.getId());
                    psUpdateLogSession.executeUpdate();
                    psUpdateLogSession.close();
                    query = "UPDATE " + sessionDetailTable + " SET cid=? WHERE session_id IN ( " + sessionIdList.toString() + " )";
                    PreparedStatement psUpdateSessionDetail = this.con.prepareStatement(query);
                    psUpdateSessionDetail.setInt(1, loginTo.getCid());
                    psUpdateSessionDetail.executeUpdate();
                    psUpdateSessionDetail.close();
                    query = "UPDATE " + sessionAccountTable + " SET cid=? WHERE session_id IN ( " + sessionIdList.toString() + " )";
                    PreparedStatement psUpdateSessionAccount = this.con.prepareStatement(query);
                    psUpdateSessionAccount.setInt(1, loginTo.getCid());
                    psUpdateSessionAccount.executeUpdate();
                    psUpdateSessionAccount.close();
                }
            }
            new RunTaskDataManager(this.con).addTask((RunTask)new MaxRecalculator(this.mid, dateMonth, "", loginFrom.getCid() + "," + loginTo.getCid()));
            dateMonth.add(2, 1);
        }
    }

    public boolean hasActiveSessions(int loginId) {
        boolean result = false;
        try {
            String tableName = ServerUtils.getModuleMonthTableName((String)"log_session", (java.util.Date)new java.util.Date(), (int)this.mid);
            if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                String query = "SELECT id FROM " + tableName + " WHERE lid=? AND status=0 LIMIT 1";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(1, loginId);
                ResultSet rs = ps.executeQuery();
                result = rs.next();
                rs.close();
                ps.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void recalcAfterMove(MonthForRecalc months, int cidFrom, int cidTo) throws SQLException {
        String sids = MaxTrafficCalculator.getModuleServicesWithoutMaxTraf((Connection)this.con, (int)this.mid, (Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(this.mid)));
        String query = "DELETE FROM contract_account WHERE cid IN (" + cidFrom + ", " + cidTo + ") AND yy=? AND mm=? AND sid IN ( " + sids + ")";
        PreparedStatement psDeleteAccount = this.con.prepareStatement(query);
        RunTaskDataManager runTaskDataManager = new RunTaskDataManager(this.con);
        DialUpSessionUtils dsu = new DialUpSessionUtils(this.con, this.mid);
        BalanceUtils bu = new BalanceUtils(this.con);
        for (Calendar month : months.getMonths()) {
            runTaskDataManager.addTask((RunTask)new MaxRecalculator(this.mid, month, null, cidFrom + "," + cidTo));
            psDeleteAccount.setInt(1, month.get(1));
            psDeleteAccount.setInt(2, month.get(2) + 1);
            psDeleteAccount.executeUpdate();
            dsu.setContractAccountFromSessionAccount(month, cidFrom);
            bu.setBalanceFromAccount(cidFrom, month);
            dsu.setContractAccountFromSessionAccount(month, cidTo);
            bu.setBalanceFromAccount(cidTo, month);
        }
        bu.close();
        psDeleteAccount.close();
    }

    protected void doSpecificWrapActions(int newLoginId, java.util.Date dateOpen, java.util.Date dateClose, Login login, TableCopier tableCopier) throws SQLException {
        String loginIpTable = "radius_pair_ip_" + this.mid;
        if (ServerUtils.tableExists((Connection)this.con, (String)loginIpTable)) {
            HashMap<String, ColumnValue> valueMap = new HashMap<String, ColumnValue>();
            valueMap.put("id", new ColumnValue(true, (Object)newLoginId));
            valueMap.put("date1", new ColumnValue(true, (Object)dateOpen));
            String date2Filter = " (date2 IS NULL OR date2>'" + TimeUtils.formatSQLDate((java.util.Date)dateClose) + "')";
            tableCopier.copyRecord(loginIpTable, date2Filter + " AND id=" + login.getId(), valueMap);
            tableCopier.updateColumn(loginIpTable, "date2", TimeUtils.formatSQLDate((java.util.Date)dateClose), date2Filter + " AND id=" + login.getId());
        }
    }

    public String checkAliases(Login login, Set<String> aliases) {
        for (String token : aliases) {
            if (token.matches("[0-9]*")) {
                StringBuilder error = new StringBuilder(200);
                error.append("\"");
                error.append(token);
                error.append("\" - \u044d\u0442\u043e \u0447\u0438\u0441\u043b\u043e, \u0430 \u0430\u043b\u0438\u0430\u0441 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c");
                return error.toString();
            }
            aliases.add(token);
        }
        return this.checkConflictAliases(login, aliases);
    }
}

