/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.service;

import bitel.billing.server.util.MailMsg;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.xml.ws.Holder;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentJournal;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatus;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatusLogItem;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentType;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsPatternService;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentDao;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentStatusDao;
import ru.bitel.bgbilling.plugins.documents.server.bean.event.DocumentGeneratedEvent;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentsPatternGenerator;
import ru.bitel.bgbilling.plugins.documents.server.filestorage.DocumentsFileStorage;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService")
public class DocumentsServiceImpl
extends AbstractService
implements DocumentsService {
    private DocumentDao documentDao;
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.documents");
    @Resource
    DocumentsPatternService documentsPatternService;

    @PostConstruct
    public void init() throws BGException {
        this.documentDao = new DocumentDao(this.getConnection());
    }

    private FileStorage getFileStorage() throws BGException {
        return new DocumentsFileStorage(this.getConnection());
    }

    public List<Document> getDocumentList(int contractId, String title, Period period) throws BGException {
        return this.documentDao.getDocumentList(contractId, title, period);
    }

    public Document getDocument(int documentId) throws BGException {
        return this.documentDao.getDocument(documentId);
    }

    public int updateDocument(Document document) throws BGException {
        document.setUserId(this.userId);
        this.documentDao.update(document);
        return document.getId();
    }

    public void deleteDocument(List<Integer> documentIds) throws BGException {
        try {
            for (Integer id : documentIds) {
                FileStorage documentsFileStorage = this.getFileStorage();
                documentsFileStorage.deleteByOwner(id.intValue());
                this.documentDao.deleteDocument(id);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean updateDocumentStatus(int documentId, int statusId, String statusComment) throws BGException {
        boolean result = false;
        DocumentStatusLogItem logItem = new DocumentStatusLogItem();
        logItem.setStatusId(statusId);
        logItem.setComment(statusComment);
        logItem.setStatusDate(new Date());
        logItem.setDocumentId(documentId);
        logItem.setUserId(this.context.getUserId());
        List<DocumentStatusLogItem> logList = this.getDocumentStatusLogList(documentId);
        DocumentStatusLogItem lastLogItem = null;
        if (!logList.isEmpty()) {
            lastLogItem = logList.get(logList.size() - 1);
        }
        if (lastLogItem == null || !lastLogItem.equals((Object)logItem)) {
            Document document = this.getDocument(documentId);
            document.setStatusId(statusId);
            this.updateDocument(document);
            this.updateStatusLog(logItem);
            result = true;
        }
        return result;
    }

    public String getAdditionalParams(int contractId) throws BGException {
        JSONObject result = new JSONObject();
        ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);
        Contract contract = (Contract)contractDao.get(contractId);
        contractDao.close();
        for (ParameterMap params : this.plugin.getSetup().subKeyed("contract.type.").values()) {
            Pattern pattern;
            Matcher m;
            String extractRegexp;
            String prefix = params.get("prefix", null);
            if (!Utils.notBlankString((String)prefix) || !contract.getTitle().startsWith(prefix)) continue;
            String dir = params.get("dir", null);
            if (Utils.isBlankString((String)dir) || Utils.isBlankString((String)(extractRegexp = params.get("extract.regexp", "\\d+"))) || !(m = (pattern = Pattern.compile(extractRegexp)).matcher(contract.getTitle())).find()) break;
            String create = params.get("dir.auto.create", "false");
            String regexp = params.get("compare.regexp", "<EXTRACT>").replaceAll("<EXTRACT>", m.group(1));
            result.put("dir", (Object)dir);
            result.put("regexp", (Object)regexp);
            result.put("create", (Object)create);
            if (!"true".equals(create)) continue;
            result.put("file", (Object)((String)(dir.endsWith(String.valueOf(File.separatorChar)) ? dir : dir + File.separatorChar) + m.group(1) + " " + contract.getComment()));
        }
        return result.toString();
    }

    public List<BGServerFile> getDocumentFileList(int documentId) throws BGException {
        FileStorage documentsFileStorage = this.getFileStorage();
        return documentsFileStorage.getFilesListByOwner(documentId);
    }

    public BGServerFile downloadDocumentFile(int fileId, int contractId, Holder<DataHandler> fileData) throws BGException {
        if (fileId <= 0) {
            throw new BGIllegalArgumentException();
        }
        FileStorage documentsFileStorage = this.getFileStorage();
        BGServerFile serverFile = documentsFileStorage.getFileById(fileId);
        if (serverFile == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (1)");
        }
        serverFile.setContractId(this.documentDao.getDocumentOwnerId(serverFile.getOwnerId()));
        if (serverFile.getContractId() != contractId) {
            throw new BGException("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438 OwnerId \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442! fileId = " + fileId + "; cid = " + contractId + "; file_cid = " + serverFile.getContractId());
        }
        try {
            File file = new File(documentsFileStorage.getFileName(fileId));
            if (!file.exists()) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (2).", (Throwable)new FileNotFoundException());
            }
            fileData.value = new DataHandler(documentsFileStorage.getDataSource(fileId));
        }
        catch (FileNotFoundException e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (2).\n" + e.getLocalizedMessage());
        }
        return serverFile;
    }

    public void deleteDocumentFiles(List<Integer> fileIds) throws BGException {
        if (fileIds == null) {
            throw new BGIllegalArgumentException();
        }
        FileStorage documentsFileStorage = this.getFileStorage();
        String rootPath = this.plugin.getSetup().get("file.net.share.root.path");
        if (!Utils.isEmptyString((String)rootPath)) {
            for (Integer fileId : fileIds) {
                BGServerFile serverFile = documentsFileStorage.getFileById(fileId.intValue());
                String fileExtension = serverFile.getTitle().substring(serverFile.getTitle().lastIndexOf(".") + 1);
                documentsFileStorage.deleteFile(fileId.intValue(), fileExtension);
            }
        } else {
            for (Integer fileId : fileIds) {
                documentsFileStorage.deleteFile(fileId.intValue());
            }
        }
    }

    public void updateDocumentFile(BGServerFile file) throws BGException {
        FileStorage documentsFileStorage = this.getFileStorage();
        documentsFileStorage.updateFile(file);
    }

    public void sendFileByEmail(List<String> emails, List<Integer> fileIds) throws BGException {
        ArrayList<1> files = new ArrayList<1>();
        for (final Integer id : fileIds) {
            final FileStorage documentsFileStorage = this.getFileStorage();
            try {
                documentsFileStorage.load(id.intValue());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new BGMessageException("\u0424\u0430\u0439\u043b\u044b \u043d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b. \u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435.");
            }
            DataSource dataSource = new DataSource(){

                public String getContentType() {
                    return "application/octet-stream";
                }

                public InputStream getInputStream() throws IOException {
                    return documentsFileStorage.load(id.intValue());
                }

                public String getName() {
                    try {
                        return documentsFileStorage.getFileById(id.intValue()).getTitle();
                    }
                    catch (BGException e) {
                        return "file.docx";
                    }
                }

                public OutputStream getOutputStream() {
                    return null;
                }
            };
            files.add(dataSource);
        }
        String subject = this.plugin.getSetup().get("documents.mail.subject", "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 BGBilling");
        try {
            MimeMultipart multipart = new MimeMultipart();
            for (DataSource dataSource : files) {
                MimeBodyPart filePart = new MimeBodyPart();
                filePart.setDataHandler(new DataHandler(dataSource));
                try {
                    filePart.setFileName(MimeUtility.encodeText((String)dataSource.getName(), (String)"utf-8", (String)"B"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new BGException((Throwable)e);
                }
                multipart.addBodyPart((BodyPart)filePart);
            }
            MailMsg mailMsg = new MailMsg((Preferences)Setup.getSetup());
            for (String email : emails) {
                mailMsg.sendMessage(email, subject, (Multipart)multipart);
            }
        }
        catch (MessagingException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<DocumentJournal> documentJournalList() throws BGException {
        return this.context.getDirectory(DocumentJournal.class, -1).list();
    }

    public DocumentJournal documentJournalGet(int journalId) throws BGException {
        return (DocumentJournal)this.context.getDirectory(DocumentJournal.class, -1).get(journalId);
    }

    public int documentJournalUpdate(DocumentJournal journal) throws BGException {
        this.context.getDirectory(DocumentJournal.class, -1).update((Id)journal);
        return journal.getId();
    }

    public int documentJournalDelete(int journalId) throws BGException {
        return this.context.getDirectory(DocumentJournal.class, -1).delete(journalId);
    }

    public List<DocumentType> documentTypeList() throws BGException {
        return this.context.getDirectory(DocumentType.class, -1).list();
    }

    public DocumentType documentTypeGet(int typeId) throws BGException {
        return (DocumentType)this.context.getDirectory(DocumentType.class, -1).get(typeId);
    }

    public int documentTypeUpdate(DocumentType type) throws BGException {
        this.context.getDirectory(DocumentType.class, -1).update((Id)type);
        return type.getId();
    }

    public int documentTypeDelete(int typeId) throws BGException {
        return this.context.getDirectory(DocumentType.class, -1).delete(typeId);
    }

    public List<DocumentStatus> documentStatusList() throws BGException {
        return this.context.getDirectory(DocumentStatus.class, -1).list();
    }

    public DocumentStatus documentStatusGet(int statusId) throws BGException {
        return (DocumentStatus)this.context.getDirectory(DocumentStatus.class, -1).get(statusId);
    }

    public int documentStatusUpdate(DocumentStatus status) throws BGException {
        this.context.getDirectory(DocumentStatus.class, -1).update((Id)status);
        return status.getId();
    }

    public int documentStatusDelete(int statusId) throws BGException {
        return this.context.getDirectory(DocumentStatus.class, -1).delete(statusId);
    }

    public List<DocumentStatusLogItem> getDocumentStatusLogList(int documentId) throws BGException {
        DocumentStatusDao documentStatusDao = new DocumentStatusDao(this.getConnection());
        List<DocumentStatusLogItem> result = documentStatusDao.getStatusHistory(documentId);
        documentStatusDao.close();
        return result;
    }

    public List<DocumentStatusLogItem> updateStatusLog(DocumentStatusLogItem item) throws BGException {
        DocumentStatusDao statusDao = new DocumentStatusDao(this.getConnection());
        item.setUserId(this.userId);
        statusDao.addStatusLog(item);
        List<DocumentStatusLogItem> result = statusDao.getStatusHistory(item.getDocumentId());
        statusDao.close();
        return result;
    }

    public Document generateDocument(int cid, int patternId, int journal, int type) throws BGException {
        DocumentPattern pattern = this.documentsPatternService.getPattern(patternId);
        if (pattern == null) {
            throw new BGIllegalArgumentException();
        }
        DocumentsPatternGenerator generator = new DocumentsPatternGenerator(this.getConnection(), pattern, cid, type, journal, this.userId);
        Document result = generator.generateDocument(null);
        EventProcessor.getInstance().publishAfterCommit((Event)new DocumentGeneratedEvent(-1, this.plugin.getPluginUID(), cid, this.userId, result));
        return result;
    }

    public List<String> checkNotFillParams(int cid, int patternId, int journal, int type) throws BGException {
        DocumentPattern pattern = this.documentsPatternService.getPattern(patternId);
        if (pattern == null) {
            throw new BGIllegalArgumentException();
        }
        DocumentsPatternGenerator generator = new DocumentsPatternGenerator(this.getConnection(), pattern, cid, type, journal, this.userId);
        return generator.getNotFillParameters();
    }

    public File getFileNetShare(int id, String title) throws BGException {
        FileStorage documentsFileStorage = this.getFileStorage();
        String rootPath = this.plugin.getSetup().get("file.net.share.root.path");
        if (Utils.isBlankString((String)rootPath)) {
            return null;
        }
        File file = new File(documentsFileStorage.getFileName(id));
        return file;
    }
}

