/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.bean.ServiceDao;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgent;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgentStatus;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebTariff;
import ru.bitel.bgbilling.modules.drwebn.common.service.DrwebService;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebAgentDAO;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebTariffDAO;
import ru.bitel.bgbilling.modules.drwebn.server.tasks.Recalculator;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.drwebn.common.service.DrwebService")
public class DrwebServiceImpl
extends AbstractService
implements DrwebService {
    private DrwebAgentDAO agentManager = null;
    private DrwebTariffDAO tariffManager = null;
    private ContractManager contractManager = null;

    @PostConstruct
    public void init() {
        this.agentManager = new DrwebAgentDAO(this.getConnection(), this.moduleId);
        this.tariffManager = new DrwebTariffDAO(this.getConnection(), this.moduleId);
        this.contractManager = new ContractManager(this.getConnection());
    }

    public List<DrwebTariff> allTariffList() throws BGException {
        return this.tariffManager.getListAll();
    }

    public List<DrwebTariff> tariffListForContract(int cid, boolean forNew) throws BGException {
        ArrayList<DrwebTariff> res = new ArrayList<DrwebTariff>();
        Contract contract = this.contractManager.getContractById(cid);
        for (DrwebTariff tariff : this.tariffManager.getListAll()) {
            String groupStr = tariff.getGroupForView();
            if (!Utils.isEmptyString((String)groupStr)) {
                long grTariff = Utils.enumToMask((String)groupStr);
                if ((contract.getGroups() & grTariff) == 0L) continue;
            }
            if (!forNew && tariff.isOnlyForNew()) continue;
            Date date = new Date();
            Date from = tariff.getDateFromView();
            Date to = tariff.getDateToView();
            if (from != null && !TimeUtils.dateBeforeOrEq((Date)from, (Date)date) || to != null && !TimeUtils.dateBeforeOrEq((Date)date, (Date)to)) continue;
            res.add(tariff);
        }
        return res;
    }

    public void tariffUpdate(DrwebTariff tariff) throws BGException {
        this.tariffManager.update(tariff);
    }

    public void tariffDelete(int id) throws BGException {
        this.tariffManager.delete(id);
    }

    public List<DrwebAgent> agentList(int cid) throws BGException {
        return this.agentManager.getAgentListByCid(cid);
    }

    public List<DrwebAgentStatus> agentStatusList(int agentId) throws BGException {
        try {
            return this.agentManager.getStatusList(agentId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<DrwebAgentStatus> statusChange(DrwebAgentStatus status, boolean rewrite) throws BGException {
        this.agentManager.updateStatus(status, this.userId, rewrite);
        return null;
    }

    public void recalculate(String cids, String mail, String date, String comment) throws BGException {
        Calendar startMonth = TimeUtils.parseCalendar((String)date, (String)"dd.MM.yyyy");
        if (this.moduleId < 0 || startMonth == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 mid=" + this.moduleId + "; date=" + startMonth);
        }
        if (TimeUtils.monthsDelta((Calendar)new GregorianCalendar(), (Calendar)startMonth) > 0) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0437\u0430 \u0431\u0443\u0434\u0443\u0449\u0438\u0435 \u043c\u0435\u0441\u044f\u0446\u044b!");
        }
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new Recalculator(this.moduleId, startMonth, cids, mail, comment));
    }

    public void accountClear(String cids, String date) throws BGException {
        Connection con = this.getConnection();
        if (this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        try (ServiceDao serviceDao = new ServiceDao(con);){
            Calendar startMonth = TimeUtils.parseCalendar((String)date, (String)"dd.MM.yyyy");
            startMonth = TimeUtils.getStartMonth((Calendar)startMonth);
            List list = serviceDao.list(this.moduleId);
            StringBuilder sb = new StringBuilder();
            for (Service service : list) {
                sb.append(service.getId());
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            String sidList = sb.toString();
            String query = "SELECT DISTINCT cid FROM contract_account WHERE sid IN ( " + sidList + " ) AND yy=? AND mm=?";
            if (Utils.notBlankString((String)cids)) {
                query = query + " AND cid IN ( " + cids + " )";
            }
            PreparedStatement psSelect = con.prepareStatement(query);
            query = "DELETE FROM contract_account WHERE sid IN ( " + sidList + " ) AND yy=? AND mm=?";
            if (Utils.notBlankString((String)cids)) {
                query = query + " AND cid IN ( " + cids + " )";
            }
            PreparedStatement psDelete = con.prepareStatement(query);
            int yy = startMonth.get(1);
            int mm = startMonth.get(2) + 1;
            HashSet<Integer> contracts = new HashSet<Integer>();
            psSelect.setInt(1, yy);
            psSelect.setInt(2, mm);
            ResultSet rs = psSelect.executeQuery();
            while (rs.next()) {
                contracts.add(rs.getInt(1));
            }
            rs.close();
            psDelete.setInt(1, yy);
            psDelete.setInt(2, mm);
            psDelete.executeUpdate();
            BalanceUtils bu = new BalanceUtils(con);
            for (Integer cid : contracts) {
                bu.setBalanceFromAccount(cid.intValue(), startMonth);
            }
            bu.close();
            psSelect.close();
            psDelete.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage() + " [" + e.getSQLState() + ", " + e.getErrorCode() + "]", (Throwable)e);
        }
    }
}

