/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.tasks;

import bitel.billing.server.admin.errorlog.bean.PeriodicErrorManager;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgentStatusBase;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebAgentDAO;
import ru.bitel.bgbilling.modules.drwebn.server.tariff.DrWebNTariffContext;
import ru.bitel.bgbilling.modules.drwebn.server.tasks.CalculatorUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class Prolonger
extends TaskBase {
    private PeriodicErrorManager errorManager;
    private Calendar day;
    Date date;
    private Calendar startMonth;
    private DrwebAgentDAO manager;
    private BalanceUtils bu;

    protected boolean initTask() {
        this.day = (Calendar)this.getOperatingTime().clone();
        this.startMonth = (Calendar)this.getOperatingTime().clone();
        this.startMonth.set(5, 1);
        this.startMonth.set(11, 0);
        this.date = this.day.getTime();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try (ContractManager contractManager = new ContractManager(con);){
            this.manager = new DrwebAgentDAO(con, this.moduleId);
            this.errorManager = new PeriodicErrorManager(con);
            this.errorManager.initErrorMessage(this.moduleId, "drwebn", String.valueOf(this.moduleId), this.getOperatingTime().getTime());
            this.bu = new BalanceUtils(con);
            DrWebNTariffContext context = new DrWebNTariffContext(this.moduleId, this.startMonth, this.getOperatingTime());
            ServiceCostCache costCache = new ServiceCostCache();
            CalculatorUtils calcUtils = new CalculatorUtils(con, this.moduleId, this.startMonth, context, costCache);
            List<DrwebAgentDAO.AgentDayItem> agentList = this.manager.getActualAgent(this.day);
            for (DrwebAgentDAO.AgentDayItem item : agentList) {
                Contract contract = contractManager.getContractById(item.agent.getCid());
                if (!CalculatorUtils.isStartDayStatus(item.status)) continue;
                calcUtils.processStatus(item.agent, (DrwebAgentStatusBase)item.status, this.date);
                if (!this.check(contract, costCache)) continue;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.day.getTime());
            this.errorManager.processErrors();
            this.bu.close();
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private boolean check(Contract contract, ServiceCostCache costCache) {
        BigDecimal planAccount = (BigDecimal)costCache.getContractAccounts().get(contract.getId());
        BigDecimal balance = this.bu.getBalanceOut(this.date, contract.getId());
        BigDecimal limit = contract.getBalanceLimit();
        return balance.subtract(planAccount).compareTo(limit) >= 0;
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c DrWeb. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u0417\u0430 \u0434\u0435\u043d\u044c" + TimeUtils.format((Calendar)this.getOperatingTime(), (String)"yyyy.MM.dd");
    }
}

