/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.action;

import java.sql.SQLException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.hd.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.hd.server.bean.HdPackage;
import ru.bitel.bgbilling.modules.hd.server.bean.HdPackageManager;
import ru.bitel.bgbilling.modules.hd.server.bean.Zone;
import ru.bitel.bgbilling.modules.hd.server.bean.ZoneManager;
import ru.bitel.common.Utils;

public class ActionPackageGet
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        Element serviceEl = this.createElement(this.rootNode, "package");
        int id = this.getIntParameter("id", -1);
        if (this.mid <= 0 || id <= 0) {
            throw new BGIllegalArgumentException();
        }
        HdPackage service = new HdPackageManager(this.con, this.mid).getPackage(id);
        if (service != null) {
            Zone zone;
            serviceEl.setAttribute("title", service.getTitle());
            serviceEl.setAttribute("sid", String.valueOf(service.getServiceId()));
            serviceEl.setAttribute("act_type", String.valueOf(service.getActivateType()));
            serviceEl.setAttribute("prol_type", String.valueOf(service.getProlongationType()));
            serviceEl.setAttribute("domain", Utils.booleanToStringInt((boolean)service.isDomainEnable()));
            serviceEl.setAttribute("domain_zone", Utils.toString(service.getDomainZoneList()));
            if (service.isDomainEnable()) {
                // empty if block
            }
            serviceEl.setAttribute("ns", Utils.booleanToStringInt((boolean)service.isNsEnable()));
            serviceEl.setAttribute("ns_domain", String.valueOf(service.getNsDomain()));
            serviceEl.setAttribute("host", Utils.booleanToStringInt((boolean)service.isHostEnable()));
            serviceEl.setAttribute("host_domain", String.valueOf(service.getHostDomain()));
            serviceEl.setAttribute("host_col", String.valueOf(service.getHostCol()));
            serviceEl.setAttribute("host_addr", service.getHostAddr());
            if (service.getHostDomain() > 0 && (zone = new ZoneManager(this.con, this.mid).getZone(service.getHostDomain())) != null) {
                serviceEl.setAttribute("host_domain_name", zone.getName());
            }
            serviceEl.setAttribute("hosting", Utils.booleanToStringInt((boolean)service.isHostingEnable()));
            serviceEl.setAttribute("hosting_host", String.valueOf(service.getHostingHost()));
            serviceEl.setAttribute("hosting_type", String.valueOf(service.getHostingType()));
            serviceEl.setAttribute("period_act", Utils.toString(service.getPeriodsActivation()));
            serviceEl.setAttribute("period_prol", Utils.toString(service.getPeriodsProlongation()));
        }
    }
}

