/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskParamService;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.ParamManager;
import ru.bitel.common.Utils;
import ru.bitel.common.model.DirectoryItem;
import ru.bitel.common.model.MapHolder;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskParamService")
public class HelpdeskParamServiceImpl
extends AbstractService
implements HelpdeskParamService {
    private static BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
    private ParamManager paramManager = null;

    @PostConstruct
    void init() {
        this.paramManager = new ParamManager(this.getConnection(), BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk"));
    }

    public MapHolder<String, String> getParams(int contractId) throws BGException {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties properties = this.paramManager.getProperties(contractId);
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return new MapHolder(map);
    }

    public void setParams(int contractId, MapHolder<String, String> _params) throws BGException {
        String trueStr = "true";
        Map params = _params.getMap();
        int mode = Utils.parseInt((String)((String)params.get("comm.mode")), (int)0);
        if (!"true".equals(plugin.getSetup().get("default.comm.telegram.enable", "true"))) {
            params.remove("comm.telegram.value");
            if (mode == 4) {
                mode = 0;
            }
        }
        if (!"true".equals(plugin.getSetup().get("default.comm.phone.enable", "true"))) {
            params.remove("comm.phone.value");
            if (mode == 1) {
                mode = 0;
            }
        }
        if (!"true".equals(plugin.getSetup().get("default.comm.email.enable", "true"))) {
            params.remove("comm.email.value");
            if (mode == 2) {
                mode = 0;
            }
        }
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                mode = 0;
            }
        }
        params.put("comm.mode", String.valueOf(mode));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)params);
        this.paramManager.setProperties(contractId, properties);
    }

    public List<DirectoryItem> getModeList() throws BGException {
        return this.paramManager.getModeList();
    }

    public String getContractCurrentMode(int contractId) throws BGException {
        return this.paramManager.getContractCurrentMode(contractId);
    }
}

