/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.plugins.im.common.IMMessage;

public class IMMessageList {
    private List<IMMessage> list = new ArrayList<IMMessage>();

    public List<IMMessage> getList() {
        return this.list;
    }

    public void addMessage(IMMessage message) {
        this.list.add(message);
    }

    public void addMessageSort(IMMessage message) {
        int sindex1 = Collections.binarySearch(this.list, message, new MessageComparator());
        if (sindex1 >= 0) {
            this.list.add(sindex1, message);
        } else {
            this.list.add(-sindex1 - 1, message);
        }
    }

    public void setXml(Element elementList) {
        for (IMMessage message : this.list) {
            Element elementMessage = elementList.getOwnerDocument().createElement("message");
            elementList.appendChild(elementMessage);
            message.setXml(elementMessage);
        }
    }

    public void getXml(Element elementList) {
        NodeList nl = elementList.getElementsByTagName("message");
        int size = nl.getLength();
        Element row = null;
        for (int i = 0; i < size; ++i) {
            row = (Element)nl.item(i);
            IMMessage message = new IMMessage();
            message.getXml(row);
            this.list.add(message);
        }
    }

    public IMMessageList cloneListAndClear() {
        IMMessageList ml = new IMMessageList();
        ml.list.addAll(this.list);
        this.list.clear();
        return ml;
    }

    public class MessageComparator
    implements Comparator<IMMessage> {
        @Override
        public int compare(IMMessage o1, IMMessage o2) {
            return Long.signum(o1.getTime() - o2.getTime());
        }
    }
}

