/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.event;

import java.util.Date;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.PoolEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;

@EventType(noLocal=true)
public class InetAccountingEvent
extends PoolEvent {
    public static final int TYPE_START = 1;
    public static final int TYPE_STOP = 2;
    public static final int TYPE_UPDATE = 3;
    @XmlAttribute
    private final int type;
    private final InetConnection connection;
    private final long sessionId;
    private final Map<Integer, AccountingTrafficAmount> counterTraffics;
    private final Date accountingTime;

    protected InetAccountingEvent() {
        this.type = -1;
        this.connection = null;
        this.sessionId = -1L;
        this.counterTraffics = null;
        this.accountingTime = null;
    }

    public InetAccountingEvent(PoolEventPublisher<?> publisher, int contractId, InetConnection connection, long sessionId, int type, Date accountingTime) {
        super(publisher, contractId, 0);
        this.type = type;
        this.connection = connection;
        this.sessionId = sessionId;
        this.counterTraffics = null;
        this.accountingTime = accountingTime;
    }

    public InetAccountingEvent(PoolEventPublisher<?> publisher, int contractId, InetConnection connection, long sessionId, int type, Map<Integer, AccountingTrafficAmount> counterTraffics, Date accountingTime) {
        super(publisher, contractId, 0);
        this.type = type;
        this.connection = connection;
        this.sessionId = sessionId;
        this.counterTraffics = counterTraffics;
        this.accountingTime = accountingTime;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("type", this.type);
        message.setIntProperty("deviceId", this.connection.getDeviceId());
    }

    public InetConnection getConnection() {
        return this.connection;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public int getType() {
        return this.type;
    }

    public Map<Integer, AccountingTrafficAmount> getCounterTraffics() {
        return this.counterTraffics;
    }

    public Date getAccountingTime() {
        return this.accountingTime;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; type: ");
        sb.append(this.type);
        sb.append("; deviceId: ");
        sb.append(this.connection.getDeviceId());
        sb.append("; connectionId: ");
        sb.append(this.connection.getId());
    }
}

