/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.current;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.day.RecalculateDayDAO;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class RecalculateCurrentDayDAO
extends RecalculateDayDAO {
    protected PreparedStatement updateSessionCostPS;
    private PreparedStatement updateSessionAccountPS;
    private String sessionAccountTableName;
    private String sessionTableName;
    private final Set<Long> currentSessions;

    public RecalculateCurrentDayDAO(Date dateFrom, Date dateTo, int moduleId, Set<Long> currentSessions, Connection con) throws SQLException {
        super(dateFrom, dateTo, moduleId, con);
        this.currentSessions = currentSessions;
        this.sessionAccountTableName = ServerUtils.getModuleTableName((String)"inet_session_account", (int)moduleId);
        this.sessionTableName = ServerUtils.getModuleTableName((String)"inet_session", (int)moduleId);
    }

    @Override
    public void init() throws SQLException {
        super.init();
        this.updateSessionAccountPS = this.con.prepareStatement("INSERT INTO sessionAccountTableName (amount, account, contractId, sessionId, serviceId) VALUES (?,?,?,?,?)  ON DUPLICATE KEY UPDATE  amount = ?, account = ?".replaceAll("sessionAccountTableName", this.sessionAccountTableName));
        this.updateSessionCostPS = this.con.prepareStatement("UPDATE sessionTableName  SET sessionCost=? WHERE id=? ".replaceAll("sessionTableName", this.sessionTableName));
    }

    @Override
    public void recycle() throws SQLException {
        super.recycle();
        this.updateSessionAccountPS.close();
        this.updateSessionCostPS.close();
    }

    @Override
    public void flushContract(int contractId, int superContractId, int yy, int mm, Set<Long> affectedSessionsForContract, Map<Integer, BigDecimal> accountMapForContract, Set<Integer> allSids) throws BGException, SQLException {
        int idx = 1;
        this.deleteInvalidSessionAccountLogForContract(this.con, contractId, affectedSessionsForContract);
        idx = 1;
        PreparedStatement deleteInvalidSessionAccountForContractPS = this.con.prepareStatement("DELETE FROM  account USING sessionAccountTableName as account LEFT JOIN sessionTableName  AS session  ON account.sessionId = session.id WHERE  account.contractId = ? AND account.sessionId  NOT IN (sessionSet) AND ( session.id IS NULL OR (sessionStart >= ? AND sessionStart < ?) ) ".replaceAll("sessionAccountTableName", this.sessionAccountTableName).replaceAll("sessionTableName", this.sessionTableName).replace("sessionSet", Utils.toString(affectedSessionsForContract)));
        deleteInvalidSessionAccountForContractPS.setInt(idx++, contractId);
        deleteInvalidSessionAccountForContractPS.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.dateFrom));
        deleteInvalidSessionAccountForContractPS.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.dateTo));
        deleteInvalidSessionAccountForContractPS.executeUpdate();
        deleteInvalidSessionAccountForContractPS.close();
        this.updateContractAccountFromSessionAccount(contractId, yy, mm, allSids);
    }

    public void updateContractAccountFromSessionAccount(int contractId, int yy, int mm, Set<Integer> allSids) throws SQLException {
        this.deleteAllInetAccountFromContract(contractId, allSids);
        String subTemplate = " (SELECT serviceId, sum(account) AS account FROM sessionAccount where contractId = ? and account > 0 GROUP BY serviceId) ";
        String query = " INSERT INTO contract_account( yy, mm, cid, sid, summa ) SELECT ?, ?, ? , serviceId, sum(account) FROM (" + subTemplate.replace("sessionAccount", this.sessionAccountTableName) + " UNION " + subTemplate.replace("sessionAccount", this.sessionAccountLogTableName) + ") as combine  GROUP  BY serviceId";
        PreparedStatement ps = this.con.prepareStatement(query);
        int idx = 1;
        ps.setInt(idx++, yy);
        ps.setInt(idx++, mm);
        ps.setInt(idx++, contractId);
        ps.setInt(idx++, contractId);
        ps.setInt(idx++, contractId);
        ps.executeUpdate();
        ps.close();
    }

    @Override
    protected PreparedStatement getUpdateSessionAccountPS(long sessionId) {
        return this.isCurrent(sessionId) ? this.updateSessionAccountPS : this.updateSessionAccountLogPS;
    }

    protected boolean isCurrent(long sessionId) {
        return this.currentSessions.contains(sessionId);
    }

    @Override
    protected PreparedStatement getDeleteBadAccountForValidSessionPS(long sessionId, Set<Integer> serviceSet) throws SQLException {
        boolean isCurrent = this.isCurrent(sessionId);
        return isCurrent ? this.con.prepareStatement("DELETE FROM sessionAccountTableName  WHERE  contractId=? AND sessionId=?  AND serviceId NOT IN (serviceSet)".replaceAll("sessionAccountTableName", this.sessionAccountTableName).replaceAll("serviceSet", Utils.toString(serviceSet))) : super.getDeleteBadAccountForValidSessionPS(sessionId, serviceSet);
    }

    @Override
    protected PreparedStatement getUpdateSessionCostLogPS(long sessionId) {
        return this.isCurrent(sessionId) ? this.updateSessionCostPS : this.updateSessionCostLogPS;
    }

    @Override
    public void removeAllExtraData(Set<Integer> allSids, Set<Integer> cids, int idDivizor, int idRemainder, Set<Integer> affectedContracts) throws BGException, SQLException {
        String andCidPartWithAffected = SessionRecalculateTarifficationManager.getSqlAndcidPartWithAffected(cids, affectedContracts);
        this.deleteExtraSessionAccount(cids, idDivizor, idRemainder, andCidPartWithAffected);
        this.deleteExtraAccount(cids, idDivizor, idRemainder, andCidPartWithAffected, allSids);
    }

    private void deleteExtraSessionAccount(Set<Integer> cids, int idDivizor, int idRemainder, String andCidPartWithAffected) throws SQLException {
        String query = "SELECT account.contractId, account.serviceId,  contract.scid as superContractId  FROM  " + this.sessionAccountLogTableName + " as account LEFT JOIN " + this.sessionLogTableName + " AS session  ON account.sessionId = session.id LEFT JOIN contract on account.contractId = contract.id  WHERE   session.sessionStart >= ? AND session.sessionStart < ? " + andCidPartWithAffected.replace("cid", "account.contractId") + " UNION SELECT account.contractId, account.serviceId,  contract.scid as superContractId  FROM  " + this.sessionAccountTableName + " as account LEFT JOIN " + this.sessionTableName + " AS session  ON account.sessionId = session.id LEFT JOIN contract on account.contractId = contract.id  WHERE   session.sessionStart >= ? AND session.sessionStart < ? " + andCidPartWithAffected.replace("cid", "account.contractId");
        PreparedStatement ps = this.con.prepareStatement(query);
        int idx = 1;
        ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.dateFrom));
        ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.dateTo));
        idx = SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, idx, cids, idDivizor, idRemainder);
        ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.dateFrom));
        ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.dateTo));
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, idx, cids, idDivizor, idRemainder);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Integer contractId = rs.getInt("contractId");
            Integer superContractId = rs.getInt("superContractId");
            Pair pair = new Pair((Object)contractId, (Object)superContractId);
            this.contractsForUpdateBalance.add(pair);
        }
        rs.close();
        ps.close();
        String delQuery = "DELETE FROM account  USING sessionAccountTableName as account LEFT JOIN sessionTableName AS session  ON account.sessionId = session.id WHERE   session.sessionStart >= ? AND session.sessionStart < ?  AND  account.contractId = ? ";
        PreparedStatement deleteSessionAccoutLogPS = this.con.prepareStatement(delQuery.replaceAll("sessionAccountTableName", this.sessionAccountLogTableName).replaceAll("sessionTableName", this.sessionLogTableName));
        deleteSessionAccoutLogPS.setDate(1, TimeUtils.convertDateToSqlDate((Date)this.dateFrom));
        deleteSessionAccoutLogPS.setDate(2, TimeUtils.convertDateToSqlDate((Date)this.dateTo));
        PreparedStatement deleteSessionAccoutPS = this.con.prepareStatement(delQuery.replaceAll("sessionAccountTableName", this.sessionAccountTableName).replaceAll("sessionTableName", this.sessionTableName));
        deleteSessionAccoutPS.setDate(1, TimeUtils.convertDateToSqlDate((Date)this.dateFrom));
        deleteSessionAccoutPS.setDate(2, TimeUtils.convertDateToSqlDate((Date)this.dateTo));
        for (Pair pair : this.contractsForUpdateBalance) {
            Integer contractId = (Integer)pair.getFirst();
            deleteSessionAccoutPS.setInt(3, contractId);
            deleteSessionAccoutPS.executeUpdate();
            deleteSessionAccoutLogPS.setInt(3, contractId);
            deleteSessionAccoutLogPS.executeUpdate();
        }
    }

    private void deleteExtraAccount(Set<Integer> cids, int idDivizor, int idRemainder, String andCidPartWithAffected, Set<Integer> services) throws SQLException, BGException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        String query = "SELECT   contract_account.cid as contractId,  contract.scid as superContractId FROM contract_account  LEFT JOIN contract on contract_account.cid = contract.id WHERE yy=? AND mm=? AND sid IN (" + Utils.toString(services) + ")" + andCidPartWithAffected;
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, yy);
        ps.setInt(2, mm);
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, 3, cids, idDivizor, idRemainder);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Integer contractId = rs.getInt("contractId");
            Integer superContractId = rs.getInt("superContractId");
            Pair pair = new Pair((Object)contractId, (Object)superContractId);
            this.contractsForUpdateBalance.add(pair);
        }
        ps.close();
    }
}

