/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.radius;

import java.util.List;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.Utils;
import ru.bitel.common.util.MacrosFormat;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntime;

public class InetRadiusAttributesMacros
extends MacrosFormat {
    private final String patternString;
    private static final Pattern COMMA = Pattern.compile("\\s*,\\s*");

    public InetRadiusAttributesMacros(String pattern) {
        this.patternString = pattern;
    }

    public StringBuffer format(StringBuffer appendable, Object ... globalArgs) {
        return super.format(appendable, this.patternString, globalArgs);
    }

    protected Object invoke(String macros, Object[] args, Object[] globalArgs) {
        IpResourceRuntime ipResourceRuntime = (IpResourceRuntime)globalArgs[3];
        if ("ipGate".equals(macros)) {
            return ipResourceRuntime == null ? "" : ipResourceRuntime.ipResource.getRouter();
        }
        if ("ipDns".equals(macros)) {
            return ipResourceRuntime == null ? "" : this.getIpDns(args, ipResourceRuntime);
        }
        if ("ipSubnetMask".equals(macros)) {
            return ipResourceRuntime == null ? "" : ipResourceRuntime.ipResource.getSubnetMask();
        }
        if ("ipParam".equals(macros) && args.length > 0) {
            if (ipResourceRuntime != null) {
                String def = args.length > 1 ? String.valueOf(args[1]) : "";
                return ipResourceRuntime.config.get(String.valueOf(args[0]), def);
            }
            return "";
        }
        if ("agentDevice".equals(macros)) {
            InetApplication application = (InetApplication)globalArgs[0];
            InetNas nas = (InetNas)((Object)globalArgs[1]);
            RadiusListenerWorker req = (RadiusListenerWorker)globalArgs[2];
            return nas.getAgentDeviceRuntime(application, req, req.getRequest());
        }
        if ("device".equals(macros)) {
            InetNas nas = (InetNas)((Object)globalArgs[1]);
            return nas.getDeviceRuntime();
        }
        if ("param".equals(macros) && args.length > 0) {
            String def = args.length > 2 ? String.valueOf(args[2]) : "";
            if (args[0] instanceof InetDeviceRuntime) {
                InetDeviceRuntime deviceRuntime = (InetDeviceRuntime)args[0];
                return deviceRuntime.config.get(String.valueOf(args[1]), def);
            }
            return def;
        }
        if ("requestAttribute".equals(macros)) {
            RadiusListenerWorker worker = (RadiusListenerWorker)globalArgs[2];
            if (worker.getRequest() != null) {
                RadiusAttributeInfo rai;
                RadiusAttribute ra = args.length == 1 ? ((rai = RadiusDictionary.findAttributeInfo((String)String.valueOf(args[0]))) != null ? worker.getRequest().getAttribute(rai.vendor, rai.type) : null) : worker.getRequest().getAttribute(this.getInt(args, 0, -1), this.getInt(args, 1, -1));
                if (ra != null) {
                    return ra.toString(false);
                }
                return "";
            }
        } else {
            if ("login".equals(macros)) {
                InetServRuntime inetServRuntime = (InetServRuntime)globalArgs[5];
                return Utils.maskNull((String)inetServRuntime.getInetServ().getLogin());
            }
            if ("inetServId".equals(macros)) {
                InetServRuntime inetServRuntime = (InetServRuntime)globalArgs[5];
                return String.valueOf(inetServRuntime.inetServId);
            }
            if ("contractId".equals(macros)) {
                InetServRuntime inetServRuntime = (InetServRuntime)globalArgs[5];
                return String.valueOf(inetServRuntime.contractRuntime.contractId);
            }
            if ("contractTitle".equals(macros)) {
                InetServRuntime inetServRuntime = (InetServRuntime)globalArgs[5];
                ContractRuntime contractRuntime = inetServRuntime.contractRuntime;
                if (contractRuntime == null) {
                    return "null";
                }
                return contractRuntime.getContractTitle();
            }
            if ("identifier".equals(macros)) {
                InetServRuntime inetServRuntime = (InetServRuntime)globalArgs[5];
                List identifierList = inetServRuntime.getInetServ().getIdentifierList();
                if (identifierList == null || identifierList.size() == 0) {
                    return "";
                }
                return Utils.maskNull((String)((String)identifierList.get(0)));
            }
        }
        return "";
    }

    private Object getIpDns(Object[] args, IpResourceRuntime ipResourceRuntime) {
        String def;
        int num;
        switch (args.length) {
            case 0: {
                return Utils.maskNull((String)ipResourceRuntime.ipResource.getDns());
            }
            case 2: {
                num = Utils.parseInt((String)String.valueOf(args[0]), (int)0);
                def = String.valueOf(args[1] != null ? args[1] : "");
                break;
            }
            default: {
                num = -1;
                def = String.valueOf(args[0] != null ? args[0] : "");
            }
        }
        if (num <= 0) {
            if (Utils.isBlankString((String)ipResourceRuntime.ipResource.getDns())) {
                return def;
            }
            return ipResourceRuntime.ipResource.getDns();
        }
        String[] dnss = COMMA.split(Utils.maskNull((String)ipResourceRuntime.ipResource.getDns()));
        return dnss.length >= num ? dnss[num - 1].trim() : def;
    }
}

