/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.monitor;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.inet.IpAddress;

class SessionTableModel
extends BGTableModel<InetSessionLog> {
    Map<Integer, InetDevice> deviceMap = new HashMap<Integer, InetDevice>();
    private InetDeviceService deviceService;

    public SessionTableModel(String name, InetDeviceService wsDevice, InetServService wsServ) {
        super(name);
        this.deviceService = wsDevice;
    }

    protected void initColumns() {
        this.addColumn("ConID", -1, 80, -1, "connectionId", true);
        this.addColumn("SessID", -1, 80, -1, "id", true);
        this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", -1, 150, -1, "contractTitle", true);
        this.addColumn("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", -1, 150, -1, null, true);
        this.addColumn("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", -1, 150, -1, "acctSessionId", true);
        this.addColumn("\u0421\u0435\u0440\u0432\u0438\u0441", -1, 240, -1, null, true);
        this.addColumn("\u0420\u0435\u0430\u043b\u043c", -1, 80, -1, "realm", true);
        this.addColumn("\u0421 \u043d\u043e\u043c\u0435\u0440\u0430/\u043d\u0430 \u043d\u043e\u043c\u0435\u0440", -1, 150, -1, null, true);
        this.addColumn("IP", -1, 150, -1, null, true);
        this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", Column.DateTime.class, -1, 140, -1, null, true);
        this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", Column.DateTime.class, -1, 140, -1, null, true);
        this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c", Column.DateTime.class, -1, 140, -1, null, true);
        this.addColumn("\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", -1, 120, 200, null, true);
        this.addColumn("C\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", -1, 90, -1, "sessionCost", true);
        this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 100, -1, null, true);
        this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", -1, 100, -1, null, true);
    }

    public Object getValue(InetSessionLog val, int column) {
        Object result = null;
        try {
            switch (column) {
                case 2: {
                    result = val.getContractTitle() + "[" + val.getContractComment() + "]";
                    break;
                }
                case 3: {
                    result = "";
                    if (val.getDeviceId() > 0) {
                        InetDevice device = this.deviceMap.get(val.getDeviceId());
                        if (device == null) {
                            device = this.deviceService.inetDeviceGet(val.getDeviceId());
                            this.deviceMap.put(val.getDeviceId(), device);
                        }
                        if (device != null) {
                            result = device.getTitle();
                        }
                    }
                    break;
                }
                case 5: {
                    result = val.getServiceTitle();
                    break;
                }
                case 7: {
                    result = "";
                    boolean flag = false;
                    if (val.getCallingStationId() != null) {
                        result = result + val.getCallingStationId();
                        flag = true;
                    }
                    if (val.getCalledStationId() != null) {
                        if (flag) {
                            result = result + "/";
                        }
                        result = result + val.getCalledStationId();
                    }
                    break;
                }
                case 8: {
                    StringBuilder sb = new StringBuilder(60);
                    if (val.getInetAddressBytes() != null) {
                        IpAddress.toString((byte[])val.getInetAddressBytes(), (StringBuilder)sb);
                    }
                    if (val.getPrefix() != null) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        IpAddress.toRFCString((byte[])val.getPrefix(), (StringBuilder)sb);
                        sb.append("/").append(val.getPrefixLength());
                    }
                    result = sb.toString();
                    break;
                }
                case 9: {
                    result = val.getSessionStart();
                    break;
                }
                case 10: {
                    result = val.getSessionStop();
                    break;
                }
                case 11: {
                    result = val.getLastActive();
                    break;
                }
                case 12: {
                    result = Utils.formatSessionTime((int)((int)val.getSessionTime()));
                    break;
                }
                case 14: {
                    result = val.getStatusName();
                    break;
                }
                case 15: {
                    result = val.getDeviceState() == 1 ? "\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "<html><font color=\"red\">\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e</font></html>";
                    break;
                }
                default: {
                    result = super.getValue((Object)val, column);
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 " + ex.getMessage());
        }
        return result;
    }
}

