/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.load.bean.Source;
import bitel.billing.server.netflow.ipn.LogUploader;
import bitel.billing.server.netflow.ipn.NetFlowSetup;
import bitel.billing.server.netflow.ipn.Processor;
import bitel.billing.server.netflow.ipn.SourceSelector;
import bitel.billing.server.netflow.ipn.TaskGenerator;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLogger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class AdminPortListener
extends Thread {
    private Date startTime = new Date();
    private Logger logger = LogManager.getLogger((String)"collector");
    private NetFlowSetup setup;
    private DatagramSocket socket;
    private IPHourlyDataLogger dataLogger;
    private Object listeners;
    private TaskGenerator taskGenerator;
    private List<SourceSelector> ss;
    private Processor processor;

    public AdminPortListener(Object listeners, IPHourlyDataLogger dataLogger, NetFlowSetup setup, int port, TaskGenerator taskGenerator, SourceSelector ss, Processor processor) {
        this.setup = setup;
        this.dataLogger = dataLogger;
        this.listeners = listeners;
        this.taskGenerator = taskGenerator;
        this.ss = ss != null ? Collections.singletonList(ss) : Collections.emptyList();
        this.processor = processor;
        try {
            this.socket = new DatagramSocket(port);
        }
        catch (Exception ex) {
            System.err.println("Port " + port + " is busy! [" + ex.getMessage() + "]");
            System.exit(1);
        }
        this.start();
    }

    @Override
    public void run() {
        byte[] buffer = new byte[100];
        byte[] data = null;
        block6: while (true) {
            try {
                while (true) {
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.socket.receive(packet);
                    data = packet.getData();
                    String command = new String(data, 0, packet.getLength(), "ISO-8859-1").trim();
                    String arg = null;
                    int pos = command.indexOf(32);
                    if (pos > 0) {
                        arg = command.substring(pos).trim();
                        command = command.substring(0, pos).trim();
                    }
                    this.logger.info("Admin command: " + command);
                    if (command.equals("stop")) {
                        try {
                            this.sendResponse("OK stopping..", packet);
                            this.dataLogger.flush(null).get();
                            System.exit(0);
                            continue block6;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    if (command.equals("flush")) {
                        this.dataLogger.flush(null).get();
                        this.sendResponse("OK flushing..", packet);
                        continue;
                    }
                    if (command.equals("status")) {
                        this.sendResponse(this.getStatus(), packet);
                        continue;
                    }
                    if (command.equals("save")) {
                        try {
                            new LogUploader(this.setup, arg);
                            this.sendResponse("Saving started..", packet);
                            continue block6;
                        }
                        catch (BGException e) {
                            this.sendResponse(e.getMessage(), packet);
                            continue;
                        }
                    }
                    if (command.equals("isload")) {
                        String[] source_time = arg.split("\\s+");
                        if (source_time.length != 2) {
                            this.sendResponse("Params error!", packet);
                            continue;
                        }
                        int source = Utils.parseInt((String)source_time[0].trim(), (int)0);
                        Calendar dtime = TimeUtils.parseCalendar((String)source_time[1].trim(), (String)"yyyy-MM-dd-HH");
                        if (source == 0) {
                            this.sendResponse("Incorrect source!", packet);
                            continue;
                        }
                        if (dtime == null) {
                            this.sendResponse("Incorrect date!", packet);
                            continue;
                        }
                        this.taskGenerator.addTaskProcessAndSourceData(dtime, source);
                        this.sendResponse("OK log is marked, process started..", packet);
                        continue;
                    }
                    if (command.startsWith("sourcelist")) {
                        StringBuilder result = new StringBuilder();
                        for (SourceSelector selector : this.ss) {
                            for (Map.Entry<Long, Source> me : selector.getAddressSourceMap().entrySet()) {
                                if (result.length() != 0) {
                                    result.append(";");
                                }
                                result.append(IPUtils.convertLongIpToString((long)me.getKey()));
                                result.append(":");
                                result.append(me.getValue().getId());
                            }
                        }
                        this.sendResponse(result.toString(), packet);
                        continue;
                    }
                    this.sendResponse("Unknown admin command: " + command, packet);
                }
            }
            catch (Exception ex) {
                this.logger.error("AdminPortListener error " + ex.getMessage(), (Throwable)ex);
                continue;
            }
            break;
        }
    }

    private void sendResponse(String responseStr, DatagramPacket inPacket) throws Exception {
        int MAX_SIZE = 65533;
        if (responseStr.length() > MAX_SIZE) {
            responseStr = responseStr.substring(0, MAX_SIZE);
        }
        byte[] responseBytes = responseStr.getBytes("ISO-8859-1");
        DatagramPacket response = new DatagramPacket(responseBytes, responseBytes.length, inPacket.getAddress(), inPacket.getPort());
        this.socket.send(response);
    }

    private String getStatus() {
        StringBuilder status = new StringBuilder();
        VersionInfo vi = VersionInfo.getVersionInfo((String)"ipn");
        status.append("Traffic collector for IPN v " + vi.getVersionString());
        status.append("\n");
        status.append(ServerUtils.uptimeStatus((Date)this.startTime));
        status.append("\n");
        status.append(Utils.memoryStatus());
        status.append("\n");
        if (this.listeners != null) {
            if (this.listeners instanceof Collection) {
                for (Object o : (Collection)this.listeners) {
                    status.append("FlowListener: ");
                    status.append(o.toString());
                    status.append("\n");
                }
            } else {
                status.append("FlowListener: ");
                status.append(this.listeners.toString());
                status.append("\n");
            }
        }
        status.append("Flow loader: ");
        status.append(String.valueOf(this.dataLogger) + "\n");
        if (this.processor != null) {
            status.append(this.processor.getStatus() + "\n");
        }
        status.append("\n");
        status.append(this.setup.getPoolStatus());
        return status.toString();
    }
}

