/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class GetDetailPanel
extends BGPanel {
    private JTabbedPane tabPanel = new JTabbedPane();
    private BGComboBox<ComboBoxItem> addressSelectCb = new BGComboBox();
    private BGControlPanelDateNoB dateP = new BGControlPanelDateNoB();
    private IntTextField hourTf = new IntTextField();
    private BGTextField emailTf = new BGTextField();
    private BGComboBox<ComboBoxItem> addressSelectCbM = new BGComboBox();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGTextField fileName = new BGTextField();
    private String fileTemplate;
    private String lastFileName = null;
    private String contractTitle = "";
    private String userName = "";
    private Map<String, String> ipMap = new HashMap<String, String>();

    public GetDetailPanel() {
        this.jbInit();
    }

    public void init(String module, int contractId, int moduleId) {
        this.setContractId(contractId);
        super.init(module, moduleId);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder(" \u0417\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e "));
        this.tabPanel.add((Component)this.getDetailPanel(), "\u0417\u0430 \u0447\u0430\u0441");
        this.tabPanel.add((Component)this.getDetailPanelMonth(), "\u0417\u0430 \u043f\u0435\u0440\u0438\u043e\u0434");
        this.add(this.tabPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
    }

    private JPanel getDetailPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.addressSelectCb, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0414\u0430\u0442\u0430: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.dateP, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("E-Mail: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.emailTf, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0427\u0430\u0441: "), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.hourTf, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        JButton createDetailButton = new JButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441");
        panel.add((Component)createDetailButton, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.hourTf.setMaxValue(0L);
        this.hourTf.setMaxValue(23L);
        createDetailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetDetailPanel.this.getDetail();
            }
        });
        return panel;
    }

    private JPanel getDetailPanelMonth() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.addressSelectCbM, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.period, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0424\u0430\u0439\u043b: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.fileName, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        JButton createDetailButton = new JButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441");
        panel.add((Component)createDetailButton, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        createDetailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetDetailPanel.this.getDetailMonth();
            }
        });
        this.addressSelectCbM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetDetailPanel.this.createFileName();
            }
        });
        this.period.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("date1") || evt.getPropertyName().equals("date2")) {
                    GetDetailPanel.this.createFileName();
                }
            }
        });
        return panel;
    }

    public void setAddressList(Document doc) {
        Element list = XMLUtils.selectElement((Node)doc, (String)"//listAddress");
        ClientUtils.buildComboBox(this.addressSelectCb, (Node)list, (String)"");
        ClientUtils.buildComboBox(this.addressSelectCbM, (Node)list, (String)"");
        this.fileTemplate = null;
        this.fileTemplate = XMLUtils.selectText((Node)doc, (String)"//file_template/@file_template", (String)"");
        this.contractTitle = XMLUtils.selectText((Node)doc, (String)"//file_template/@contract_title", (String)"");
        this.userName = XMLUtils.selectText((Node)doc, (String)"//file_template/@user_name", (String)"");
        for (Element item : XMLUtils.elements((NodeList)list.getChildNodes())) {
            String id = XMLUtils.getAttribute((Element)item, (String)"id", null);
            String ip = XMLUtils.getAttribute((Element)item, (String)"ip", null);
            this.ipMap.put(id, ip);
        }
        this.createFileName();
    }

    private void getDetail() {
        String addressId = ClientUtils.getIdFromComboBox(this.addressSelectCb);
        String date = this.dateP.getDateString();
        String hour = this.hourTf.getText();
        String email = this.emailTf.getText();
        if (Utils.isBlankString((String)addressId)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432!");
            return;
        }
        if (Utils.isBlankString((String)date)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443!");
            return;
        }
        if (Utils.isBlankString((String)hour)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0447\u0430\u0441!");
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("CreateDetail");
        request.setModuleId(this.getModuleId());
        request.setAttribute("address_id", addressId);
        request.setAttribute("date", date);
        request.setAttribute("hour", hour);
        request.setAttribute("mail", email);
        if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0441\u043b\u0430\u043d\u0430 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
            return;
        }
    }

    private void getDetailMonth() {
        String addressId = ClientUtils.getIdFromComboBox(this.addressSelectCbM);
        String date1 = this.period.getDateString1();
        String date2 = this.period.getDateString2();
        String file = this.fileName.getText();
        if (Utils.isBlankString((String)addressId)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432!");
            return;
        }
        if (Utils.isBlankString((String)date1) || Utils.isBlankString((String)date2)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0438\u043e\u0434!");
            return;
        }
        if (Utils.isBlankString((String)file)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430!");
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("CreateDetailMonth");
        request.setModuleId(this.getModuleId());
        request.setAttribute("address_id", addressId);
        request.setAttribute("date1", date1);
        request.setAttribute("date2", date2);
        request.setAttribute("file", file);
        if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0431\u0443\u0434\u0435\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430 \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
            return;
        }
    }

    private void createFileName() {
        if (Utils.isEmptyString((String)this.fileTemplate) || this.lastFileName != null && !this.lastFileName.equals(this.fileName.getText())) {
            return;
        }
        String res = this.fileTemplate.replaceAll("\\{cid\\}", String.valueOf(this.getContractId()));
        res = res.replaceAll("\\{cid\\}", String.valueOf(this.getContractId()));
        res = res.replaceAll("\\{contract_title\\}", this.contractTitle);
        res = res.replaceAll("\\{user\\}", this.userName);
        String ip = this.ipMap.get(this.addressSelectCbM.getSelectedId());
        res = res.replaceAll("\\{ip\\}", ip != null ? ip : "");
        GregorianCalendar dateNow = new GregorianCalendar();
        res = res.replaceAll("\\{yyyy_now\\}", String.valueOf(dateNow.get(1)));
        res = res.replaceAll("\\{MM_now\\}", String.valueOf(dateNow.get(2) + 1));
        res = res.replaceAll("\\{dd_now\\}", String.valueOf(dateNow.get(5)));
        if (this.period.getDateFrom() != null) {
            GregorianCalendar date1 = new GregorianCalendar();
            date1.setTime(this.period.getDateFrom());
            res = res.replaceAll("\\{yyyy1\\}", String.valueOf(date1.get(1)));
            res = res.replaceAll("\\{MM1\\}", String.valueOf(date1.get(2) + 1));
            res = res.replaceAll("\\{dd1\\}", String.valueOf(date1.get(5)));
        } else {
            res = res.replaceAll("\\{yyyy1\\}", "");
            res = res.replaceAll("\\{MM1\\}", "");
            res = res.replaceAll("\\{dd1\\}", "");
        }
        if (this.period.getDateTo() != null) {
            GregorianCalendar date2 = new GregorianCalendar();
            date2.setTime(this.period.getDateTo());
            res = res.replaceAll("\\{yyyy2\\}", String.valueOf(date2.get(1)));
            res = res.replaceAll("\\{MM2\\}", String.valueOf(date2.get(2) + 1));
            res = res.replaceAll("\\{dd2\\}", String.valueOf(date2.get(5)));
        } else {
            res = res.replaceAll("\\{yyyy2\\}", "");
            res = res.replaceAll("\\{MM2\\}", "");
            res = res.replaceAll("\\{dd2\\}", "");
        }
        this.fileName.setText(res);
        this.lastFileName = res;
    }
}

