<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<div class="titleFont3">История оплат</div>
<c:choose>
	<c:when test="${not empty transactions}">
		<c:forEach var="item" varStatus="status" items="${transactions}">
		<div class="gridRow" style="margin: 15px 0px; grid-template-columns: auto 6em;">
			<div style="display: flex; flex-direction: column;">
				<div>
					<c:choose>
						<c:when test="${not empty item.transactionDate}"><fmt:formatDate value="${item.transactionDate}" type="BOTH" dateStyle="SHORT" timeStyle="SHORT"/></c:when>
						<c:otherwise><fmt:formatDate value="${item.createDate}" type="BOTH" dateStyle="SHORT" timeStyle="SHORT"/></c:otherwise>
					</c:choose>
					<span class="paramColor">[#${item.id}]</span>
					<c:if test="${item.autopayment}"><span class="paramColor autopayment">[автоплатеж]</span></c:if>
				</div>
				<div class="flexRow" style="margin-left: 1em; margin-top: 0.3em; flex-wrap: wrap;">
					<div class="paramFont paramColor" style="width: 10em;">Статус: <span><c:forEach var="statusItem" items="${statusList}"><c:if test="${item.status eq statusItem.code}">${statusItem.title}</c:if></c:forEach></span></div>
					<div class="paramFont paramColor" style="width: 10em;">Карта: <span>${item.pan}</span></div>
					<div class="paramFont paramColor" style="width: 15em;">Держатель: <span>${item.cardholderName}</span></div>
				</div>
			</div>
			<c:set var="sum"><fmt:formatNumber value="${item.sum}" minFractionDigits="2"/></c:set>
			<div class="titleFont3" style="text-align: right; white-space: nowrap;">${sum}<span class="CUR"></span></div>
			<%-- 
			<div class="titleFont3" style="text-align: right;">${fn:substringBefore(sum,',')}<span class="sumFrac">,${fn:substringAfter(sum,',')}</span><span class="CUR"/></div>
			--%>
		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
		</c:forEach>
	</c:when>
	<c:otherwise><div class="notFound" style="margin: 20px;">Данные не найдены</div></c:otherwise>
</c:choose>
