/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGUndoManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class BGTextArea
extends JTextArea {
    private boolean emptyTextFlag = false;
    private String helpText = "";
    private Font baseFont = null;
    private Color baseColor = null;
    private BGUndoManager man = new BGUndoManager();
    private boolean doNotShowHelpText;

    public BGTextArea() {
        this.aa();
        this.init();
    }

    public BGTextArea(int rows, int columns) {
        super(rows, columns);
        this.aa();
        this.init();
    }

    private void init() {
        this.man.setActionUndoAndRedo(this);
    }

    private void aa() {
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
        this.setMargin(new Insets(3, 3, 3, 3));
        this.baseFont = this.getFont();
        this.baseColor = this.getForeground();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (BGTextArea.this.emptyTextFlag) {
                    BGTextArea.this.emptyTextFlag = false;
                    BGTextArea.this.a();
                }
                super.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                String txt = BGTextArea.this.getText();
                if (txt == null || txt.isEmpty()) {
                    BGTextArea.this.emptyTextFlag = true;
                    BGTextArea.this.a();
                } else {
                    BGTextArea.this.emptyTextFlag = false;
                }
                super.focusLost(e);
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        int rows;
        Dimension size = super.getMinimumSize();
        int columns = this.getColumns();
        Insets insets = this.getInsets();
        if (columns != 0) {
            size.width = columns * this.getColumnWidth() + insets.left + insets.right;
        }
        if ((rows = this.getRows()) != 0) {
            size.height = rows * this.getRowHeight() + insets.top + insets.bottom;
        }
        return size;
    }

    @Override
    public String getText() {
        String text = "";
        if (!this.emptyTextFlag) {
            text = super.getText();
        }
        return text;
    }

    @Override
    public void append(String str) {
        if (str != null && !str.isEmpty()) {
            this.emptyTextFlag = false;
            this.a();
            super.append(str);
        }
    }

    public void setEmptyText(String helpText) {
        if (helpText != null && !helpText.isEmpty()) {
            this.emptyTextFlag = true;
            this.helpText = helpText;
        } else {
            this.emptyTextFlag = false;
        }
        this.a();
    }

    private void a() {
        if (this.emptyTextFlag) {
            this.setFont(this.getFont().deriveFont(2));
            this.setForeground(Color.GRAY);
            this.setText(this.helpText);
        } else {
            this.setText("");
            this.setFont(this.baseFont);
            this.setForeground(this.baseColor);
        }
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.man.discardAllEdits();
    }

    public void setPromptText(String helpText) {
        this.setPromptText(helpText, true, true);
    }

    public void setPromptText(final String helpText, boolean clearText, final boolean emptyTextFlag) {
        this.emptyTextFlag = emptyTextFlag;
        this.setFont(this.getFont().deriveFont(2));
        this.setForeground(Color.GRAY);
        this.setText(helpText);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (BGTextArea.this.doNotShowHelpText || !BGTextArea.this.isEnabled() || !BGTextArea.this.isEditable()) {
                    return;
                }
                if (emptyTextFlag) {
                    BGTextArea.this.setText("");
                } else {
                    boolean old = BGTextArea.this.emptyTextFlag;
                    BGTextArea.this.emptyTextFlag = false;
                    BGTextArea.this.setSelectionStart(0);
                    BGTextArea.this.setSelectionEnd(BGTextArea.this.getText().length());
                    BGTextArea.this.emptyTextFlag = old;
                }
                BGTextArea.this.setFont(BGTextArea.this.baseFont);
                BGTextArea.this.setForeground(BGTextArea.this.baseColor);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (BGTextArea.this.doNotShowHelpText || !BGTextArea.this.isEnabled() || !BGTextArea.this.isEditable()) {
                    return;
                }
                BGTextArea.this.emptyTextFlag = emptyTextFlag;
                BGTextArea.this.setFont(BGTextArea.this.getFont().deriveFont(2));
                BGTextArea.this.setForeground(Color.GRAY);
                BGTextArea.this.setText(helpText);
            }
        });
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (!BGTextArea.this.isEnabled() || !BGTextArea.this.isEditable()) {
                    return;
                }
                if (!BGTextArea.super.getText().equals("") && !BGTextArea.super.getText().equals(helpText)) {
                    BGTextArea.this.setFont(BGTextArea.this.baseFont);
                    BGTextArea.this.setForeground(BGTextArea.this.baseColor);
                    BGTextArea.this.emptyTextFlag = false;
                    BGTextArea.this.doNotShowHelpText = true;
                } else {
                    BGTextArea.this.doNotShowHelpText = false;
                    BGTextArea.this.emptyTextFlag = emptyTextFlag;
                }
            }
        });
    }
}

