/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.ModTreeNode;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.contract.ParameterEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.event.UpdateContractEmailEvent;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUAction;

public class EmailEditor
extends ParameterEditor {
    private static final int FONT_SIZE = 14;
    private String eid;
    private JPanel incorrectPanel = new JPanel(new GridBagLayout());
    private BGTable bgEmailTable = new BGTable();
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private StringBuffer buf;
    public Map<Integer, ModTreeNode> mail = new HashMap<Integer, ModTreeNode>();
    private BGTableCellEditor cellEditor = new BGTableCellEditor();

    public EmailEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bgEmailTable.init("kernel", 0);
        this.bgEmailTable.setHeader(this.rb_name, this.moduleDoc, "param_email");
        this.bgEmailTable.setDefaultEditor(this.bgEmailTable.getColumnClass(0), this.cellEditor);
        this.bgEmailTable.setRowHeight(22);
        this.bgEmailTable.setFont(new Font("Dialog", 0, 14));
        this.toolBar.setDefaultButtons(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int n;
                if ("newItem".equals(e.getActionCommand())) {
                    if (EmailEditor.this.bgEmailTable.getRowCount() > 0) {
                        n = EmailEditor.this.bgEmailTable.getRowCount() - 1;
                        if (EmailEditor.this.bgEmailTable.getValueAt(n, 0) != null && !EmailEditor.this.bgEmailTable.getValueAt(n, 0).equals("")) {
                            Vector rowData = new Vector();
                            EmailEditor.this.bgEmailTable.addRow(rowData);
                        }
                    } else {
                        Vector rowData = new Vector();
                        EmailEditor.this.bgEmailTable.addRow(rowData);
                    }
                }
                if ("deleteItem".equals(e.getActionCommand())) {
                    n = EmailEditor.this.bgEmailTable.getEditingRow();
                    EmailEditor.this.bgEmailTable.removeRow(n);
                    EmailEditor.this.bgEmailTable.repaint();
                }
            }
        });
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(1);
        this.toolBar.setToolBar(new String[]{"newItem", "deleteItem"});
    }

    private void jbInit() throws Exception {
        this.bgEmailTable.setAutoResizeMode(2);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolBar, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.bgEmailTable), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    public boolean updateData() {
        if (this.inspectionEmail()) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("UpdateEmailInfo");
            request.setAttribute("pid", this.id);
            request.setAttribute("eid", this.eid);
            request.setContractId(this.getContractId());
            request.setAttribute("e-mail", this.SringConvert());
            this.buf = new StringBuffer();
            request.setAttribute("buf", this.buf.toString());
            boolean result = ClientUtils.checkStatus(TransferManager.getDocument(request));
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            EventBus.publish((Object)new UpdateContractEmailEvent(this.getContractId(), Utils.parseInt(this.id)));
            return result;
        }
        return false;
    }

    @Override
    public void setData() {
        this.bgEmailTable.removeRows();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("EmailInfo");
        request.setContractId(this.getContractId());
        request.setAttribute("pid", this.id);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.bgEmailTable.updateData(doc);
            this.eid = XMLUtils.getAttribute(doc.getDocumentElement(), "id", "0");
            boolean error = Utils.parseBoolean(XMLUtils.getAttribute(doc.getDocumentElement(), "error"), false);
            if (error) {
                this.getIncorrectPanel(doc);
                ClientUtils.showErrorMessageDialog("\u0414\u0430\u043d\u043d\u044b\u0435 \u0431\u044b\u043b\u0438 \u043d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b. \u041e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0432\u0435\u0440\u043d\u043e.", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
            } else {
                this.remove(this.incorrectPanel);
            }
        }
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            Element address = XMLUtils.selectElement(doc, "//email");
            this.eid = XMLUtils.getAttribute(address, "id", "0");
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
    }

    private String SringConvert() {
        Object mailString = new String("");
        for (int i = 0; i < this.bgEmailTable.getRowCount() && this.bgEmailTable.getValueAt(i, 0) != null && !this.bgEmailTable.getValueAt(i, 0).equals(""); ++i) {
            for (int j = 1; j >= 0; --j) {
                if (j == 1 && this.bgEmailTable.getValueAt(i, j) != null && !this.bgEmailTable.getValueAt(i, j).equals("")) {
                    mailString = (String)mailString + this.bgEmailTable.getValueAt(i, j).toString();
                }
                if (j != 0) continue;
                mailString = (String)mailString + " <";
                mailString = (String)mailString + this.bgEmailTable.getValueAt(i, j).toString();
                mailString = (String)mailString + ">";
                mailString = (String)mailString + "\n";
            }
        }
        return mailString;
    }

    private boolean inspectionEmail() {
        JScrollPane scrollPane;
        JTextArea textArea;
        String text;
        Component compScrollPane;
        this.cellEditor.stopCellEditing();
        boolean result = true;
        Pattern patternEmail = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", 2);
        for (int i = 0; i < this.bgEmailTable.getRowCount(); ++i) {
            if (this.bgEmailTable.getValueAt(i, 0) != null && !Utils.isBlankString(this.bgEmailTable.getValueAt(i, 0).toString())) {
                String string = this.bgEmailTable.getValueAt(i, 0).toString();
                Matcher m = patternEmail.matcher(string);
                if (m.lookingAt()) continue;
                result = false;
                ClientUtils.showErrorMessageDialog("E-Mail \u0431\u044b\u043b \u043d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0432 " + (i + 1) + " \u0441\u0442\u0440\u043e\u043a\u0435.");
                break;
            }
            if (this.bgEmailTable.getValueAt(i, 1) == null || Utils.isBlankString(this.bgEmailTable.getValueAt(i, 1).toString())) continue;
            ClientUtils.showErrorMessageDialog("\u041f\u043e\u043b\u0435 \"E-Mail\" \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
            return false;
        }
        if (this.incorrectPanel.getComponentCount() > 0 && (compScrollPane = this.incorrectPanel.getComponents()[0]) instanceof JScrollPane && Utils.notEmptyString((text = (textArea = (JTextArea)(scrollPane = (JScrollPane)compScrollPane).getViewport().getView()).getText()).trim())) {
            ClientUtils.showErrorMessageDialog("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0435 \"\u041d\u0435\u0440\u0430\u0437\u043e\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 \"");
            result = false;
        }
        return result;
    }

    private void getIncorrectPanel(Document doc) {
        String incorrectString = XMLUtils.getAttribute(doc.getDocumentElement(), "incorrectString");
        if (this.incorrectPanel.getComponentCount() == 0) {
            BGTitleBorder titleBorder = new BGTitleBorder(" \u041d\u0435\u0440\u0430\u0437\u043e\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 ");
            titleBorder.setTitleColor(Color.RED);
            this.incorrectPanel.setBorder(titleBorder);
            this.incorrectPanel.add((Component)new JScrollPane(new JTextArea(incorrectString)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.incorrectPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.4, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            Component compScrollPane = this.incorrectPanel.getComponents()[0];
            if (compScrollPane instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)compScrollPane;
                JTextArea textArea = (JTextArea)scrollPane.getViewport().getView();
                textArea.setText(incorrectString);
            }
        }
    }

    public class BGTableCellEditor
    implements TableCellEditor {
        JTextField tf = new JTextField();
        DefaultCellEditor textFieldEditor;
        JPanel editor = new JPanel(new GridBagLayout());

        public BGTableCellEditor() {
            this.tf.setBorder(new LineBorder(Color.darkGray));
            this.textFieldEditor = new DefaultCellEditor(this.tf);
            this.editor.add(this.tf);
            this.tf.setFont(new Font("Dialog", 0, 14));
            final Action actionPastDefault = this.tf.getActionMap().get("paste-from-clipboard");
            BGUAction actionPast = new BGUAction("", ""){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String strEmail = (String)EmailEditor.this.getToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                        boolean error = false;
                        Object nameString = new String();
                        String emailString = new String();
                        if (strEmail.indexOf("<") == -1) {
                            error = true;
                        } else {
                            Pattern patternEmail = Pattern.compile("<(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\]>)", 2);
                            int indexFirst = strEmail.indexOf("<");
                            nameString = strEmail.substring(0, indexFirst);
                            int indexSecond = strEmail.indexOf(">");
                            nameString = (String)nameString + strEmail.substring(indexSecond + 1, strEmail.length());
                            Matcher matcherEmail = patternEmail.matcher(strEmail);
                            if (matcherEmail.find()) {
                                emailString = matcherEmail.group();
                            }
                            emailString = emailString.replaceAll("<", "");
                            emailString = emailString.replaceAll(">", "");
                        }
                        if (!error) {
                            if (!Utils.isBlankString(emailString)) {
                                if (EmailEditor.this.bgEmailTable.getEditingColumn() == 0) {
                                    BGTableCellEditor.this.tf.setText(emailString);
                                } else {
                                    EmailEditor.this.bgEmailTable.setValueAt(emailString, EmailEditor.this.bgEmailTable.getEditingRow(), 0);
                                }
                            }
                            if (!Utils.isBlankString((String)nameString)) {
                                if (EmailEditor.this.bgEmailTable.getEditingColumn() == 1) {
                                    BGTableCellEditor.this.tf.setText((String)nameString);
                                } else {
                                    EmailEditor.this.bgEmailTable.setValueAt(nameString, EmailEditor.this.bgEmailTable.getEditingRow(), 1);
                                }
                            }
                        } else {
                            actionPastDefault.actionPerformed(e);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            };
            this.tf.getActionMap().put("paste-from-clipboard", actionPast);
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.textFieldEditor.addCellEditorListener(l);
        }

        @Override
        public void cancelCellEditing() {
            this.textFieldEditor.cancelCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.textFieldEditor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.textFieldEditor.removeCellEditorListener(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.textFieldEditor.isCellEditable(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.textFieldEditor.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.textFieldEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

