/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.BGBorderFactory;
import bitel.billing.module.common.ListItem;
import bitel.billing.module.contract.ParameterEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class ListParamEditor
extends ParameterEditor {
    private DefaultListModel<ListItem> valuesModel = new DefaultListModel();
    private JList<ListItem> valuesList = new JList<ListItem>(this.valuesModel);
    private JTextField customValueField = new JTextField();
    private JRadioButton radioButton1 = new JRadioButton("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430");
    private JRadioButton radioButton2 = new JRadioButton("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");

    public ListParamEditor() {
        this((AbstractAction)null);
    }

    public ListParamEditor(final AbstractAction action) {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.valuesList.setBorder(BGBorderFactory.createEmptyBorder());
        if (action != null) {
            this.valuesList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && ListParamEditor.this.valuesList.getSelectedValue() != null) {
                        action.actionPerformed(new ActionEvent(this, 0, "ok"));
                    }
                }
            });
        }
    }

    private void jbInit() throws Exception {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioButton1);
        bg.add(this.radioButton2);
        this.radioButton1.setSelected(true);
        this.customValueField.setEnabled(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.radioButton1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.valuesList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.radioButton2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.customValueField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        Dimension dimension = this.getPreferredSize();
        dimension.height = 200;
        this.setPreferredSize(dimension);
        this.radioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListParamEditor.this.customValueField.setEnabled(false);
                ListParamEditor.this.valuesList.setEnabled(true);
            }
        });
        this.radioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListParamEditor.this.customValueField.setEnabled(true);
                ListParamEditor.this.valuesList.setEnabled(false);
            }
        });
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetListParam");
        request.setContractId(this.getContractId());
        request.setAttribute("pid", this.getId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element values = XMLUtils.selectElement(doc, "//values");
            String currentValue = values.getAttribute("value");
            ClientUtils.buildList(this.valuesList, this.valuesModel, values, currentValue);
            if ("0".equals(currentValue)) {
                this.radioButton2.setSelected(true);
                this.valuesList.setEnabled(false);
                this.customValueField.setEnabled(true);
                this.customValueField.setText(values.getAttribute("custom_value"));
            } else {
                this.radioButton1.setSelected(true);
                this.valuesList.setEnabled(true);
                this.customValueField.setEnabled(false);
                this.customValueField.setText("");
            }
        }
    }

    @Override
    public boolean updateData() {
        boolean result = false;
        ListItem li = this.valuesList.getSelectedValue();
        Request request = new Request();
        request.setModule(this.module);
        request.setAttribute("pid", this.getId());
        request.setAction("UpdateListParam");
        request.setAttribute("cid", this.getContractId());
        String value = "0";
        if (this.radioButton1.isSelected()) {
            if (li == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                return false;
            }
            value = (String)li.getAttribute("id");
            this.customValueField.setText("");
        }
        if (this.radioButton2.isSelected() && (this.customValueField.getText().equals("") || this.customValueField.getText() == null)) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
            return false;
        }
        request.setAttribute("value", value);
        request.setAttribute("custom_value", this.customValueField.getText().trim());
        result = ClientUtils.checkStatus(this.getDocument(request));
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        return result;
    }
}

