/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectParamService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;

public class ObjectParamDirectory
extends BGUPanel {
    private ContractObjectParam contractObjectParam = null;
    private JTextArea comment = new JTextArea();
    private JCheckBox history = new JCheckBox("\u0438\u0441\u0442\u043e\u0440\u0438\u044f");
    private BGTextField title = new BGTextField();
    private JPanel editor = new JPanel(new GridBagLayout());
    private BGComboBox<ComboBoxItem> type_CB = new BGComboBox();
    private ContractObjectParamService contractObjectParamService = null;
    private ObjectParamTableModel tableModel = new ObjectParamTableModel(ObjectParamTableModel.class.getName());

    public ObjectParamDirectory() {
        this.editor.setVisible(false);
    }

    @Override
    protected void jbInit() {
        this.editor.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editor.setLayout(new GridBagLayout());
        this.type_CB.addItem(new ComboBoxItem("1", "\u0442\u0435\u043a\u0441\u0442"));
        this.type_CB.addItem(new ComboBoxItem("2", "\u0441\u043f\u0438\u0441\u043e\u043a"));
        this.type_CB.addItem(new ComboBoxItem("3", "\u0434\u0430\u0442\u0430"));
        this.type_CB.addItem(new ComboBoxItem("4", "\u0430\u0434\u0440\u0435\u0441"));
        this.type_CB.addItem(new ComboBoxItem("5", "\u0444\u043b\u0430\u0433"));
        this.type_CB.setMinimumSize(new Dimension(150, 24));
        this.type_CB.setPreferredSize(new Dimension(150, 24));
        this.comment.setMargin(new Insets(3, 3, 3, 3));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        panel.add(this.type_CB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.title, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.history, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        JPanel panelComment = new JPanel(new GridBagLayout());
        panelComment.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelComment.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 5, 0), 0, 0));
        this.editor.add((Component)panelComment, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        BGUTable table = new BGUTable(this.tableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ObjectParamDirectory.this.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private ContractObjectParamService getContractObjectParamService() {
        if (this.contractObjectParamService == null) {
            this.contractObjectParamService = ((ClientContext)this.getContext()).getPort(ContractObjectParamService.class);
        }
        return this.contractObjectParamService;
    }

    private void stopEdit(boolean save) {
        if (save) {
            if (Utils.isBlankString(this.title.getText())) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
                return;
            }
            this.contractObjectParam.setTitle(this.title.getText());
            this.contractObjectParam.setType(Utils.parseInt(ClientUtils.getIdFromComboBox(this.type_CB)));
            this.contractObjectParam.setComment(this.comment.getText());
            this.contractObjectParam.setHistory(this.history.isSelected());
            try {
                this.getContractObjectParamService().updateObjectParam(this.contractObjectParam);
                this.editor.setVisible(false);
                this.performAction("refresh");
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    private void startEdit() {
        if (this.contractObjectParam == null || this.contractObjectParam.getId() < 1) {
            this.title.setText("");
            this.comment.setText("");
            this.type_CB.setSelectedIndex(0);
            this.history.setSelected(false);
        } else {
            try {
                this.contractObjectParam = this.getContractObjectParamService().getObjectParam(this.contractObjectParam.getId());
                this.title.setText(this.contractObjectParam.getTitle());
                ClientUtils.setComboBoxSelection(this.type_CB, this.contractObjectParam.getType());
                this.comment.setText(this.contractObjectParam.getComment());
                this.history.setSelected(this.contractObjectParam.isHistory());
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
        this.editor.setVisible(true);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ObjectParamDirectory.this.contractObjectParam = new ContractObjectParam();
                ObjectParamDirectory.this.type_CB.setEnabled(true);
                ObjectParamDirectory.this.startEdit();
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ObjectParamDirectory.this.contractObjectParam = (ContractObjectParam)((Object)ObjectParamDirectory.this.tableModel.getSelectedRow());
                if (ObjectParamDirectory.this.contractObjectParam != null) {
                    ObjectParamDirectory.this.type_CB.setEnabled(false);
                    ObjectParamDirectory.this.startEdit();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ObjectParamDirectory.this.contractObjectParam = (ContractObjectParam)((Object)ObjectParamDirectory.this.tableModel.getSelectedRow());
                if (ObjectParamDirectory.this.contractObjectParam != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    ObjectParamDirectory.this.getContractObjectParamService().deleteObjectParam(ObjectParamDirectory.this.contractObjectParam.getId());
                    ObjectParamDirectory.this.contractObjectParam = null;
                    ObjectParamDirectory.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ObjectParamDirectory.this.tableModel.setData(ObjectParamDirectory.this.getContractObjectParamService().searchObjectParam().getList());
            }
        };
    }

    class ObjectParamTableModel
    extends BGTableModel<ContractObjectParam> {
        public ObjectParamTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430", 100, 100, 100, "type", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, 500, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0418\u0441\u0442\u043e\u0440\u0438\u044f", 80, 80, 80, "history", true);
        }
    }
}

