/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object.table;

import bitel.billing.module.common.ListItem;
import bitel.billing.module.contract.object.table.ParameterEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class ListParamEditor
extends ParameterEditor {
    private JList<ListItem> valuesList = new JList();

    public ListParamEditor() {
        this((AbstractAction)null);
    }

    public ListParamEditor(final AbstractAction action) {
        if (action != null) {
            this.valuesList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && ListParamEditor.this.valuesList.getSelectedValue() != null) {
                        action.actionPerformed(new ActionEvent(this, 0, "ok"));
                    }
                }
            });
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.valuesList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ListParamValueGet");
        request.setAttribute("object", this.objectId);
        request.setAttribute("param", this.getId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element values = XMLUtils.selectElement(doc, "//values");
            String currentValue = values.getAttribute("value");
            ClientUtils.buildList(this.valuesList, (Node)values, currentValue);
        }
    }

    @Override
    public boolean updateData() {
        boolean result = false;
        ListItem li = this.valuesList.getSelectedValue();
        if (li == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
        } else {
            String value = (String)li.getAttribute("id");
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ListParamValueUpdate");
            request.setAttribute("object", this.objectId);
            request.setAttribute("param", this.getId());
            request.setAttribute("value", value);
            result = ClientUtils.checkStatus(this.getDocument(request));
        }
        return result;
    }
}

