/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.web.action;

import bitel.billing.server.util.MailMsg;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class XSLManager {
    private static final Logger log = LogManager.getLogger();
    public static final String xslPath = "webroot/xsl/";
    private static XSLManager instance;
    private boolean cacheTemplates = false;
    private final HashMap<String, Templates> templates = new HashMap(32);
    private static ErrorListener errorListener;

    public static final XSLManager getInstance() {
        if (instance == null) {
            instance = new XSLManager();
        }
        return instance;
    }

    private XSLManager() {
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.cacheTemplates = Setup.getSetup().getBoolean("xslt.cache", true);
    }

    private final Transformer getTransformer(String xsltFile) throws TransformerConfigurationException {
        Transformer transformer;
        if (this.cacheTemplates) {
            Templates template = this.templates.get(xsltFile);
            if (template == null) {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                tFactory.setErrorListener(errorListener);
                File file = new File(xslPath + xsltFile);
                if (file.exists()) {
                    template = tFactory.newTemplates(new StreamSource(file));
                    this.templates.put(xsltFile, template);
                }
            }
            transformer = template != null ? template.newTransformer() : null;
        } else {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setErrorListener(errorListener);
            transformer = tFactory.newTransformer(new StreamSource(new File(xslPath + xsltFile)));
        }
        if (transformer == null) {
            throw new TransformerConfigurationException("error new transformer for template xslt file (does not exist?) webroot/xsl/" + xsltFile);
        }
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setParameter("xsltFile", xsltFile);
        transformer.setErrorListener(errorListener);
        return transformer;
    }

    public final Transformer getTransformer(String xsltFile, Map<String, Object> params) throws BGException {
        try {
            if (Utils.isEmptyString(xsltFile)) {
                throw new BGException("XSLT file name is empty!");
            }
            Transformer transformer = this.getTransformer(xsltFile);
            if (params != null) {
                for (Map.Entry<String, Object> e : params.entrySet()) {
                    transformer.setParameter(e.getKey(), e.getValue());
                }
            }
            return transformer;
        }
        catch (TransformerConfigurationException ex) {
            throw new BGException("Error XSLT file " + xsltFile, ex);
        }
    }

    private final void transform(Transformer transformer, Source doc, Result out) {
        try {
            transformer.transform(doc, out);
        }
        catch (Exception ex) {
            log.error("Error XSLT file " + transformer.getParameter("xsltFile"), (Throwable)ex);
        }
    }

    public final void transform(Source source, String xsltFile, Node out) throws BGException {
        try {
            this.getTransformer(xsltFile, null).transform(source, new DOMResult(out));
        }
        catch (Exception ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 " + xsltFile, ex);
        }
    }

    public final void transform(Source source, String xsltFile, Result out) throws BGException {
        try {
            this.getTransformer(xsltFile, null).transform(source, out);
        }
        catch (Exception ex) {
            log.error("Error XSLT file " + xsltFile, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(HttpServletResponse response, String xsltFile, Source source, Map<String, Object> transformerParams, String contentType, String fileName, boolean zip) {
        try {
            Transformer transformer = this.getTransformer(xsltFile, transformerParams);
            OutputStream out = null;
            ZipOutputStream z = null;
            try {
                if (zip) {
                    response.setContentType("application/zip");
                    response.setHeader("Content-disposition", "filename=" + fileName + ".zip");
                    z = new ZipOutputStream((OutputStream)response.getOutputStream());
                    z.putNextEntry(new ZipEntry(fileName));
                    out = z;
                } else {
                    if (fileName != null) {
                        response.setHeader("Content-disposition", "filename=" + fileName);
                    }
                    String encoding = transformer.getOutputProperty("encoding");
                    if (((String)contentType).startsWith("text")) {
                        contentType = (String)contentType + "; charset=" + encoding;
                    }
                    response.setContentType((String)contentType);
                    response.setCharacterEncoding(encoding);
                    out = response.getOutputStream();
                }
                this.transform(transformer, source, (Result)new StreamResult(out));
            }
            finally {
                if (z != null) {
                    z.closeEntry();
                    z.flush();
                    z.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(OutputStream out, String xsltFile, Source source, Map<String, Object> transformerParams, String fileName, boolean zip) {
        try {
            ZipOutputStream z = null;
            try {
                if (zip) {
                    z = new ZipOutputStream(out);
                    z.putNextEntry(new ZipEntry(fileName));
                    out = z;
                }
                this.transform(this.getTransformer(xsltFile, transformerParams), source, (Result)new StreamResult(out));
            }
            finally {
                if (z != null) {
                    z.closeEntry();
                    z.flush();
                    z.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource transform(String xsltFile, Source source, Map<String, Object> params, String contentType, String fileName, boolean zip) throws BGException {
        try {
            Transformer transformer = this.getTransformer(xsltFile, params);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
            OutputStream out = null;
            ZipOutputStream z = null;
            try {
                if (zip) {
                    contentType = "application/zip";
                    z = new ZipOutputStream(baos);
                    z.putNextEntry(new ZipEntry(fileName));
                    out = z;
                } else {
                    String encoding = transformer.getOutputProperty("encoding");
                    if (((String)contentType).startsWith("text")) {
                        contentType = (String)contentType + "; charset=" + encoding;
                    }
                    out = baos;
                }
                this.transform(transformer, source, (Result)new StreamResult(out));
            }
            finally {
                if (z != null) {
                    z.closeEntry();
                    z.flush();
                    z.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            ByteArrayDataSource dataSource = new ByteArrayDataSource(baos.toByteArray(), (String)contentType);
            if (fileName != null) {
                if (zip) {
                    dataSource.setName(fileName + ".zip");
                } else {
                    dataSource.setName(fileName);
                }
            }
            return dataSource;
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public void transformAndSend(String xsltFile, Source source, Map<String, Object> params, String contentType, String fileName, boolean zip, String email, String emailSubject) {
        try {
            if (emailSubject == null || emailSubject.length() == 0) {
                emailSubject = "REPORT";
            }
            DataSource dataSource = this.transform(xsltFile, source, params, contentType, fileName, zip);
            MimeMultipart m = new MimeMultipart();
            MimeBodyPart attach = new MimeBodyPart();
            m.addBodyPart((BodyPart)attach);
            attach.setDataHandler(new DataHandler(dataSource));
            if (fileName != null) {
                attach.setFileName(dataSource.getName());
            }
            new MailMsg((Preferences)Setup.getSetup()).sendMessage(email, emailSubject, (Multipart)m);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    static {
        errorListener = new ErrorListener(){

            private boolean check(TransformerException e) {
                Throwable t = e;
                while (((Throwable)t).getCause() != null) {
                    Exception x;
                    if (!((t = ((Throwable)t).getCause()) instanceof SAXException ? (x = ((SAXException)t).getException()) instanceof IOException || x instanceof EOFException || x instanceof SocketException : t instanceof IOException || t instanceof EOFException || t instanceof SocketException)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void error(TransformerException e) throws TransformerException {
                if (this.check(e)) {
                    log.error("error transform", (Throwable)e);
                }
            }

            @Override
            public void fatalError(TransformerException e) throws TransformerException {
                if (this.check(e)) {
                    log.error("fatal error transform", (Throwable)e);
                }
            }

            @Override
            public void warning(TransformerException e) throws TransformerException {
                if (this.check(e)) {
                    log.warn("warning transform", (Throwable)e);
                }
            }
        };
    }
}

