/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.tariff.option.client.TariffOptionActivateModesEditor;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.table.BGTableModel;

public class TariffOptionServiceConfig
extends BGUPanel {
    private TariffOptionEditor editor;
    private TariffOptionTableModel tableModel = new TariffOptionTableModel(TariffOptionTableModel.class.getName());
    private BGUTable table = new BGUTable(this.tableModel);
    private TariffOptionService tariffOptionService;
    Action refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            TariffOptionServiceConfig.this.tableModel.setData(TariffOptionServiceConfig.this.getService().tariffOptionList());
        }
    };

    public TariffOptionServiceConfig(ClientContext ctx) {
        super(ctx);
    }

    @Override
    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        JPanel labelPanel = new JPanel(new GridBagLayout());
        labelPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e", 0), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 50, 0, 50), 0, 0));
        this.editor = new TariffOptionEditor();
        BGEditor rightPanel = new BGEditor("info");
        rightPanel.addForm(labelPanel, "info");
        rightPanel.addForm(this.editor);
        rightPanel.addPropertyChangeListener(e -> {
            if ("show".equals(e.getPropertyName()) && "info".equals(e.getNewValue())) {
                this.table.setEnabled(true);
            }
        });
        this.table.setSelectionMode(0);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.setBorder(new BGTitleBorder(" \u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043e\u043f\u0446\u0438\u0438 "));
        leftPanel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        BGSplitPaneNoBorder mainSplit = new BGSplitPaneNoBorder(1, leftPanel, (Component)rightPanel, 500L);
        this.add((Component)mainSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TariffOptionServiceConfig.this.performAction("edit");
                }
            }
        });
        Request request = new Request();
        request.setModule("tariff");
        request.setAction("ListTariffPlans");
        Document doc = ((ClientContext)this.getContext()).getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ArrayList<BGUListItem> data = new ArrayList<BGUListItem>();
            for (Element itemElement : XMLUtils.selectElements(doc, "//tariffPlans/item")) {
                data.add(new BGUListItem(Utils.parseInt(itemElement.getAttribute("id")), itemElement.getAttribute("title")));
            }
            this.editor.tariffPlans.getList().setData(data);
        }
    }

    private TariffOptionService getService() {
        if (this.tariffOptionService == null) {
            this.tariffOptionService = ((ClientContext)this.getContext()).getPort(TariffOptionService.class);
        }
        return this.tariffOptionService;
    }

    class TariffOptionTableModel
    extends BGTableModel<TariffOption> {
        public TariffOptionTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 150, 150, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }
    }

    class TariffOptionEditor
    extends BGUPanel {
        private BGTextField titleTF;
        private BGControlPanelListSelect tariffPlans;
        private ContractLabelTree contractLabelTree;
        private TariffOptionActivateModesEditor activateModes;
        private BGUCheckList<TariffOption> dependsList;
        private BGUCheckList<TariffOption> incompatibleList;
        private JCheckBox hide;
        private JRadioButton hideForGroupsModeOr;
        private JRadioButton hideForGroupsModeAnd;
        private ContractLabelTree hideForContractLabels;
        private JTextArea comment;
        private JTextArea description;
        private String id;
        Action newItem;
        Action editItem;
        Action deleteItem;
        Action ok;

        public TariffOptionEditor() {
            super(new GridBagLayout());
            this.titleTF = new BGTextField();
            this.tariffPlans = new BGControlPanelListSelect(5);
            this.activateModes = new TariffOptionActivateModesEditor();
            this.dependsList = new BGUCheckList();
            this.incompatibleList = new BGUCheckList();
            this.hide = new JCheckBox("\u0421\u043a\u0440\u044b\u0442 \u0432 \u0432\u0435\u0431-\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435");
            this.hideForGroupsModeOr = new JRadioButton("\u0418\u041b\u0418");
            this.hideForGroupsModeAnd = new JRadioButton("\u0418");
            this.comment = new JTextArea();
            this.description = new JTextArea();
            this.id = null;
            this.newItem = new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    TariffOptionEditor.this.id = "new";
                    TariffOptionEditor.this.editOption();
                    TariffOptionEditor.this.performActionOpen();
                }
            };
            this.editItem = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    TariffOption tariffOption = (TariffOption)TariffOptionServiceConfig.this.tableModel.getSelectedRow();
                    if (tariffOption != null) {
                        TariffOptionEditor.this.id = String.valueOf(tariffOption.getId());
                        TariffOptionEditor.this.editOption();
                        TariffOptionEditor.this.performActionOpen();
                    }
                }
            };
            this.deleteItem = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    TariffOption tariffOption = (TariffOption)TariffOptionServiceConfig.this.tableModel.getSelectedRow();
                    if (tariffOption != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u043f\u0446\u0438\u044e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                        TariffOptionServiceConfig.this.getService().tariffOptionDelete(tariffOption.getId());
                        TariffOptionServiceConfig.this.performAction("refresh");
                    }
                }
            };
            this.ok = new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043e\u043f\u0446\u0438\u044e"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (Utils.isBlankString(TariffOptionEditor.this.titleTF.getText())) {
                        ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435.");
                        return;
                    }
                    TariffOption tariffOption = new TariffOption();
                    tariffOption.setId(Utils.parseInt(TariffOptionEditor.this.id));
                    tariffOption.setTitle(TariffOptionEditor.this.titleTF.getText());
                    tariffOption.setTariffIdSet(Utils.toIntegerSet(TariffOptionEditor.this.tariffPlans.getListValues()));
                    tariffOption.setContractLabels(new HashSet<Integer>(TariffOptionEditor.this.contractLabelTree.getSelectedIds()));
                    tariffOption.setActivateModeList(TariffOptionEditor.this.activateModes.getData());
                    tariffOption.setDepends(TariffOptionEditor.this.dependsList.getSelectedIds());
                    tariffOption.setIncompatible(TariffOptionEditor.this.incompatibleList.getSelectedIds());
                    tariffOption.setHideForWeb(TariffOptionEditor.this.hide.isSelected());
                    tariffOption.setHideForContractGroupsMode(TariffOptionEditor.this.hideForGroupsModeAnd.isSelected() ? 1 : 0);
                    tariffOption.setHideForContractLabels(new HashSet<Integer>(TariffOptionEditor.this.hideForContractLabels.getSelectedIds()));
                    tariffOption.setComment(TariffOptionEditor.this.comment.getText());
                    tariffOption.setDescription(TariffOptionEditor.this.description.getText());
                    TariffOptionServiceConfig.this.getService().tariffOptionUpdate(tariffOption);
                    TariffOptionEditor.this.performActionClose();
                    TariffOptionServiceConfig.this.table.setEnabled(true);
                    TariffOptionServiceConfig.this.performAction("refresh");
                }
            };
        }

        @Override
        protected void jbInit() throws BGException {
            this.contractLabelTree = new ContractLabelTree(((ClientContext)this.getContext()).getPort(ContractLabelService.class));
            this.hideForContractLabels = new ContractLabelTree(((ClientContext)this.getContext()).getPort(ContractLabelService.class));
            JPanel titlePanel = new JPanel(new GridBagLayout());
            titlePanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            titlePanel.add((Component)this.titleTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 0, 5), 0, 0));
            JTabbedPane editorTabPanel = new JTabbedPane();
            editorTabPanel.addTab("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b", this.tariffPlans);
            editorTabPanel.addTab("\u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", new JScrollPane(this.contractLabelTree));
            editorTabPanel.addTab("\u0420\u0435\u0436\u0438\u043c\u044b \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", this.activateModes);
            JPanel dependsPanel = new JPanel(new GridBagLayout());
            dependsPanel.add((Component)BGSwingUtilites.wrapBorder(this.dependsList, "\u0417\u0430\u0432\u0438\u0441\u0438\u0442 \u043e\u0442 \u043e\u043f\u0446\u0438\u0439:"), new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            dependsPanel.add((Component)BGSwingUtilites.wrapBorder(this.incompatibleList, "\u041d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u043e\u043f\u0446\u0438\u044f\u043c\u0438:"), new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            editorTabPanel.addTab("\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438", dependsPanel);
            JPanel panel = new JPanel(new GridBagLayout());
            JPanel hideForContractLabels = new JPanel(new GridBagLayout());
            panel.add((Component)this.hide, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
            hideForContractLabels.setBorder(BorderFactory.createTitledBorder("\u0421\u043a\u0440\u044b\u0442 \u0432 \u0432\u0435\u0431-\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0435 \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u043f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432"));
            panel.add((Component)hideForContractLabels, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            hideForContractLabels.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 5), 0, 0));
            hideForContractLabels.add((Component)this.hideForGroupsModeOr, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 3), 0, 0));
            hideForContractLabels.add((Component)this.hideForGroupsModeAnd, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 3), 0, 0));
            hideForContractLabels.add((Component)new JScrollPane(this.hideForContractLabels), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            ButtonGroup group = new ButtonGroup();
            group.add(this.hideForGroupsModeOr);
            group.add(this.hideForGroupsModeAnd);
            editorTabPanel.addTab("\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c", panel);
            this.comment.setLineWrap(true);
            this.description.setLineWrap(true);
            JPanel descriptionPanel = new JPanel(new GridBagLayout());
            descriptionPanel.add((Component)BGSwingUtilites.wrapBorder(new JScrollPane(this.comment), "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            descriptionPanel.add((Component)BGSwingUtilites.wrapBorder(new JScrollPane(this.description), "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            editorTabPanel.addTab("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", descriptionPanel);
            this.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)editorTabPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        }

        private void editOption() throws BGException {
            TariffOption option = null;
            List<TariffOption> options = TariffOptionServiceConfig.this.getService().tariffOptionList();
            if (this.id.equals("new")) {
                List<TariffOptionActivateMode> emptyModeList = Collections.emptyList();
                this.titleTF.setText("");
                this.tariffPlans.setListValues("");
                this.contractLabelTree.setSelectedIds(Collections.emptyList());
                this.activateModes.setData(emptyModeList);
                this.hide.setSelected(false);
                this.hideForGroupsModeOr.setSelected(true);
                this.hideForContractLabels.setSelectedIds(Collections.emptyList());
                this.comment.setText("");
                this.description.setText("");
            } else {
                option = TariffOptionServiceConfig.this.getService().tariffOptionGet(Utils.parseInt(this.id));
                if (option != null) {
                    this.titleTF.setText(option.getTitle());
                    this.tariffPlans.setListValues(Utils.toString(option.getTariffIdSet()));
                    this.contractLabelTree.setSelectedIds(new ArrayList<Integer>(option.getContractLabels()));
                    this.activateModes.setData(option.getActivateModeList());
                    this.hide.setSelected(option.isHideForWeb());
                    if (option.getHideForContractGroupsMode() == 0) {
                        this.hideForGroupsModeOr.setSelected(true);
                    } else {
                        this.hideForGroupsModeAnd.setSelected(true);
                    }
                    this.hideForContractLabels.setSelectedIds(new ArrayList<Integer>(option.getHideForContractLabels()));
                    this.comment.setText(option.getComment());
                    this.description.setText(option.getDescription());
                    options.remove(option);
                }
            }
            this.dependsList.setData(options);
            this.incompatibleList.setData(options);
            if (option != null) {
                this.dependsList.setSelected(option.getDepends());
                this.incompatibleList.setSelected(option.getIncompatible());
            }
            TariffOptionServiceConfig.this.table.setEnabled(false);
        }
    }
}

