/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client.device;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.oss.kernel.entity.client.EntityAttributesForm;
import ru.bitel.oss.systems.inventory.resource.client.device.DeviceFormComment;
import ru.bitel.oss.systems.inventory.resource.client.device.DeviceFormMain;
import ru.bitel.oss.systems.inventory.resource.client.device.DevicePanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;

class DeviceForm<D extends Device<D, T>, T extends DeviceType>
extends BGUPanel {
    private final DevicePanel<D, T> devicePanel;
    private JTabbedPane pane;
    private List<BGUPanel> panels;
    private AtomicReference<D> currentRef = new AtomicReference();

    public DeviceForm(DevicePanel<D, T> devicePanel, ClientContext context) {
        super((LayoutManager)new BorderLayout(), context);
        this.devicePanel = devicePanel;
        this.setName("deviceForm");
    }

    @Override
    protected void jbInit() {
        BGSwingUtilites.wrapBorder(this, " \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 ");
        this.panels = new ArrayList<BGUPanel>();
        BGUPanel panel1 = this.devicePanel.newMainForm(this.currentRef);
        this.panels.add(panel1);
        EntityAttributesForm panel2 = new EntityAttributesForm(this.currentRef, (ClientContext)this.getContext());
        this.panels.add(panel2);
        DeviceFormComment<D, T> comment = new DeviceFormComment<D, T>(this.devicePanel, this.currentRef);
        this.panels.add(comment);
        this.pane = new JTabbedPane();
        this.pane.addTab("\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435", panel1);
        this.pane.addTab("\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b", panel2);
        this.pane.addTab("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", comment);
        this.pane.setMnemonicAt(0, 49);
        this.pane.setMnemonicAt(1, 50);
        this.add((Component)this.pane, "Center");
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (DeviceForm.this.isShowing()) {
                    ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442.");
                    return;
                }
                DeviceForm.this.currentRef.set(DeviceForm.this.devicePanel.newDevice());
                for (BGUPanel panel : DeviceForm.this.panels) {
                    panel.performAction("new");
                }
                DeviceForm.this.pane.setSelectedIndex(0);
                DeviceForm.this.performActionOpen();
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (DeviceForm.this.isShowing()) {
                    ClientUtils.showErrorMessageDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442.");
                    return;
                }
                if (DeviceForm.this.devicePanel.model.getSelectedRow() != DeviceForm.this.devicePanel.model.getRoot()) {
                    Object selected = (Device)DeviceForm.this.devicePanel.model.getSelectedRow();
                    if (selected == null) {
                        return;
                    }
                    selected = DeviceForm.this.devicePanel.deviceGet(selected.getId());
                    DeviceForm.this.currentRef.set(selected);
                    for (BGUPanel panel : DeviceForm.this.panels) {
                        panel.performAction("edit");
                    }
                    DeviceForm.this.pane.setSelectedIndex(0);
                    DeviceForm.this.performActionOpen();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (!this.isEnabled()) {
                    ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430.");
                    return;
                }
                Device selected = (Device)DeviceForm.this.devicePanel.model.getSelectedRow();
                if (selected == null || selected == DeviceForm.this.devicePanel.model.getRoot()) {
                    ClientUtils.showMessageDialog("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
                    return;
                }
                if (selected.getChildren() != null) {
                    ClientUtils.showMessageDialog("\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
                    return;
                }
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    DeviceForm.this.devicePanel.deviceDelete(selected.getId());
                    DeviceForm.this.devicePanel.model.setSelectedRow(selected.getParentId());
                    DeviceForm.this.devicePanel.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                DeviceType type = null;
                for (BGUPanel panel : DeviceForm.this.panels) {
                    if (panel instanceof DeviceFormMain) {
                        type = ((DeviceFormMain)panel).getSelectedDeviceType();
                    }
                    if (panel.performAction("ok")) continue;
                    return;
                }
                Device device = (Device)DeviceForm.this.currentRef.get();
                device.setTitle(Device.generateTitle((Device)device, type));
                int id = DeviceForm.this.devicePanel.deviceUpdate(device);
                DeviceForm.this.devicePanel.performAction("refresh");
                DeviceForm.this.devicePanel.model.setSelectedRow(id);
                DeviceForm.this.performActionClose();
            }
        };
    }
}

