/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean.find;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.find.SearchContractModule;
import bitel.billing.server.contract.bean.find.SearchConvertPattern;
import java.sql.Connection;
import java.util.Calendar;
import java.util.List;
import ru.bitel.common.TimeUtils;

public final class SearchContract {
    public static final int MAX_RESULT = 10;
    protected static final int REGIME_OFF = 0;
    protected static final int REGIME_NORMAL = 1;
    protected static final int REGIME_LIKE = 2;
    protected static final int REGIME_REGEXP = 3;
    private final int mid;
    private final int pid;
    private final SearchContractModule search;
    private final SearchConvertPattern[] pattern;
    private final int regime;
    public final int pos;
    private final long groups;
    private final String patternTitle;
    private final boolean contractPeriodCheck;

    protected SearchContract(SearchContractModule search, int mid, int pid, int pos, SearchConvertPattern[] pattern, int regime, long groups, String patternTitle, boolean contractPeriodCheck) {
        this.search = search;
        this.mid = mid;
        this.pid = pid;
        this.pos = pos;
        this.pattern = pattern;
        this.regime = regime;
        this.groups = groups;
        this.patternTitle = patternTitle;
        this.contractPeriodCheck = contractPeriodCheck;
    }

    public final List<Contract> findContract(Connection con, String param, Calendar date, StringBuilder report) {
        String searchParamValue;
        String string = searchParamValue = this.pattern == null ? param : SearchConvertPattern.convert(param, this.pattern);
        if (report.length() > 0) {
            report.append(";");
        }
        report.append("\u043f\u043e\u0437. " + this.pos + " \u0438\u0441\u043a\u043e\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 " + searchParamValue + " \u0434\u0430\u0442\u0430 " + TimeUtils.formatDate((Calendar)date));
        return this.search.findContracts(con, this, searchParamValue, date.getTime());
    }

    public String toString() {
        return "\nmode=" + (this.search != null ? this.search.getName() : "") + "\nmid=" + this.mid + "\npid=" + this.pid + "\ngroups=" + this.groups + "\nregime=" + this.regime + "\nreplace=" + SearchConvertPattern.toString(this.pattern);
    }

    public int getMid() {
        return this.mid;
    }

    public int getRegime() {
        return this.regime;
    }

    public long getGroups() {
        return this.groups;
    }

    public String getPatternTitle() {
        return this.patternTitle;
    }

    public int getPid() {
        return this.pid;
    }

    public boolean isContractPeriodCheck() {
        return this.contractPeriodCheck;
    }
}

