/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.status.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractStatusLog;
import bitel.billing.server.contract.bean.ContractStatusManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;

public class ActionContractStatusLog
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        if (this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        ContractStatusManager manager = new ContractStatusManager(this.con);
        List<ContractStatusLog> logs = manager.getLogList(this.cid);
        for (ContractStatusLog log : logs) {
            Element row = this.createElement(data, "row");
            row.setAttribute("period", TimeUtils.formatPeriod((Date)log.getDate1(), (Date)log.getDate2()));
            row.setAttribute("date", TimeUtils.format((Date)log.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("status", StatusCache.getInstance().getStatusTitle(log.getStatus()));
            row.setAttribute("comment", log.getComment());
            row.setAttribute("user", UserMap.getUser(log.getUserId()).getName());
        }
    }
}

