/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.load.action;

import bitel.billing.server.load.action.base.ActionBase;
import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;

public class ActionUpdateSource
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", 0);
        int mid = this.getIntParameter("mid", -1);
        String title = this.getParameter("title");
        String comment = this.getParameter("comment");
        int typeID = this.getIntParameter("type", 0);
        String host = this.getParameter("host");
        String path = this.getParameter("path");
        String user = this.getParameter("login");
        String pswd = this.getParameter("passwd");
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1"));
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2"));
        String config = this.getParameter("config", "");
        if (mid == -1 || title == null || user == null || pswd == null || host == null && path == null || date1 == null && date2 == null) {
            throw new BGIllegalArgumentException();
        }
        Source source = new Source();
        source.setId(id);
        source.setMid(mid);
        source.setTitle(title.length() == 0 ? "\u0431\u0435\u0437 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f" : title);
        source.setDate1(date1);
        source.setDate2(date2);
        source.setComment(comment == null ? "" : comment);
        source.setType(typeID);
        switch (typeID) {
            case 2: {
                source.setHostOrDir(path);
                break;
            }
            default: {
                source.setHostOrDir(host);
            }
        }
        source.setUser(user);
        source.setPswd(pswd);
        source.setConfig(config);
        SourceManager manager = new SourceManager(this.con);
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("UpdateSource", mid, this.userId);
        if (closedDate != null) {
            Calendar oldDateFrom = null;
            Calendar oldDateTo = null;
            if (id > 0) {
                Source oldSource = manager.getSource(id);
                oldDateFrom = oldSource.getDate1();
                oldDateTo = oldSource.getDate2();
            }
            ClosedDateChecker.checkDatesForUpdate(closedDate, oldDateFrom, oldDateTo, date1, date2);
        }
        manager.updateSource(source);
    }
}

