/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.processor.LC_LimitCheckerError;
import bitel.billing.server.processor.LC_LoginServiceCondition;
import bitel.billing.server.processor.LoginError;
import bitel.billing.server.radius.RadiusSetup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import ru.bitel.common.TimeUtils;

public class LC_CheckingLogin {
    private int lid = 0;
    private volatile int connections_count = 1;
    protected List<LC_LoginServiceCondition> login_conditions = new ArrayList<LC_LoginServiceCondition>();
    protected int max_sessions = 0;
    protected boolean status;
    protected RadiusSetup setup;

    public LC_CheckingLogin(Login login, RadiusSetup setup, Connection con) {
        this.lid = login.getId();
        this.setup = setup;
        this.status = login.getStatus();
        this.max_sessions = login.getMaxSession();
        this.loadConditions(con);
    }

    public boolean hasConditions() {
        boolean result = false;
        for (int i = 0; i < this.login_conditions.size(); ++i) {
            LC_LoginServiceCondition condition = this.login_conditions.get(i);
            if (condition.getConditionType() != 3 && condition.getConditionType() != 4) continue;
            result = true;
            break;
        }
        return result;
    }

    public Hashtable<String, Object> getRests(Hashtable<String, Object> params, int sid, boolean subst) {
        Hashtable<String, Object> rests = null;
        for (int i = 0; i < this.login_conditions.size(); ++i) {
            LC_LoginServiceCondition condition = this.login_conditions.get(i);
            if (!condition.isConditionWorking(params) || !condition.workForServiceId(sid)) continue;
            rests = condition.getRests(params, subst);
        }
        return rests;
    }

    private void loadConditions(Connection con) {
        try {
            PreparedStatement ps = con.prepareStatement("SELECT * FROM user_login_limit_" + this.setup.getModuleId() + " WHERE lid=? AND ( isNull( date1 ) or date1 <= now() ) AND ( isNull( date2 ) OR date2 >= now() ) ORDER BY type_con, num");
            ps.setInt(1, this.getLid());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                LC_LoginServiceCondition condition = new LC_LoginServiceCondition(rs.getInt("id"), this.setup, con);
                this.login_conditions.add(condition);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LoginError canLoginComeIn(Connection con, Hashtable<String, Object> params) {
        LC_LimitCheckerError result = null;
        if (!this.status) {
            result = new LC_LimitCheckerError(26);
        } else if (this.max_sessions != 0 && this.max_sessions <= this.connections_count) {
            result = new LC_LimitCheckerError(21);
        } else if (this.login_conditions.size() == 0) {
            result = null;
        } else {
            Calendar time = (Calendar)params.get("time");
            time = TimeUtils.clear_MIN_MIL_SEC((Calendar)time);
            boolean access = true;
            int condition_type = 0;
            for (int i = 0; i < this.login_conditions.size(); ++i) {
                LC_LoginServiceCondition condition = this.login_conditions.get(i);
                if (!condition.isConditionWorking(params)) continue;
                if (condition.getConditionType() != condition_type && !access) break;
                boolean accessPrev = access;
                if (access = condition.canComeIn(params, access)) {
                    result = null;
                } else if (!access && accessPrev) {
                    switch (condition.getConditionType()) {
                        case 1: {
                            result = new LC_LimitCheckerError(22);
                            break;
                        }
                        case 2: {
                            result = new LC_LimitCheckerError(23);
                            break;
                        }
                        case 3: {
                            result = new LC_LimitCheckerError(24);
                            break;
                        }
                        case 4: {
                            result = new LC_LimitCheckerError(25);
                            break;
                        }
                        case 5: {
                            result = new LC_LimitCheckerError(27);
                        }
                    }
                }
                condition_type = condition.getConditionType();
            }
        }
        return result;
    }

    public int getLid() {
        return this.lid;
    }

    public void setConnectionsCount(int value) {
        this.connections_count = value;
    }
}

