/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.calc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class ItemZoneCostCache
implements Serializable {
    private final ConcurrentMap<Integer, ItemZoneCostCacheItem> dataMap = new ConcurrentHashMap<Integer, ItemZoneCostCacheItem>(200);
    private final ConcurrentMap<Integer, ItemZoneCostCacheItem> dataMapInput = new ConcurrentHashMap<Integer, ItemZoneCostCacheItem>(200);
    private final ConcurrentMap<Integer, ItemZoneCostCacheItem> dataMapOutput = new ConcurrentHashMap<Integer, ItemZoneCostCacheItem>(200);
    private Logger logger = null;

    public ItemZoneCostCache(Logger logger) {
        this.logger = logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void addZoneCost(Integer itemId, Integer zoneId, BigDecimal amount, int type) {
        this.addZoneCost(this.dataMap, itemId, zoneId, amount);
        if (type == 2) {
            this.addZoneCost(this.dataMapInput, itemId, zoneId, amount);
        } else if (type == 1) {
            this.addZoneCost(this.dataMapOutput, itemId, zoneId, amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addZoneCost(ConcurrentMap<Integer, ItemZoneCostCacheItem> map, Integer itemId, Integer zoneId, BigDecimal amount) {
        ItemZoneCostCacheItem newItemMap;
        ItemZoneCostCacheItem itemMap = (ItemZoneCostCacheItem)map.get(itemId);
        if (itemMap == null && (itemMap = map.putIfAbsent(itemId, newItemMap = new ItemZoneCostCacheItem())) == null) {
            itemMap = newItemMap;
        }
        ItemZoneCostCacheItem itemZoneCostCacheItem = itemMap;
        synchronized (itemZoneCostCacheItem) {
            itemMap.add(zoneId, amount);
        }
    }

    public BigDecimal getZoneCost(Integer itemId, Integer zoneId, int type) {
        BigDecimal result = null;
        result = type == 2 ? this.getZoneCost(this.dataMapInput, itemId, zoneId) : (type == 1 ? this.getZoneCost(this.dataMapOutput, itemId, zoneId) : this.getZoneCost(this.dataMap, itemId, zoneId));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getZoneCost(ConcurrentMap<Integer, ItemZoneCostCacheItem> map, Integer itemId, Integer zoneId) {
        ItemZoneCostCacheItem itemMap = (ItemZoneCostCacheItem)map.get(itemId);
        if (itemMap != null) {
            ItemZoneCostCacheItem itemZoneCostCacheItem = itemMap;
            synchronized (itemZoneCostCacheItem) {
                CostAmount costAmount = itemMap.zoneMap.get(zoneId);
                if (costAmount != null) {
                    return costAmount.amount;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryUpdate(Connection con, int moduleId, int itemId, Calendar time, long zoneTrafficCacheTime) {
        ItemZoneCostCacheItem itemMap;
        this.logger.debug("ItemZoneCostCache: tryUpdate[itemId => {}]...", (Object)itemId);
        ItemZoneCostCacheItem itemZoneCostCacheItem = itemMap = this.getItemMap(this.dataMap, itemId);
        synchronized (itemZoneCostCacheItem) {
            if (itemMap.loadTime == 0L || time.getTimeInMillis() - itemMap.loadTime > zoneTrafficCacheTime) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("tryUpdateTrafficCache: time.getTimeInMillis()=" + time.getTimeInMillis() + ", itemMap.loadTime=" + itemMap.loadTime + ", zoneTrafficCacheTime=" + zoneTrafficCacheTime);
                }
                this.load(con, moduleId, itemId, time);
                return;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(itemMap.loadTime);
            if (TimeUtils.monthsDelta((Calendar)time, (Calendar)calendar) != 0) {
                this.logger.debug("TimeUtils.monthsDelta( time, calendar ) != 0");
                this.load(con, moduleId, itemId, time);
                return;
            }
            itemMap.loadTime = time.getTimeInMillis();
        }
        this.logger.debug("ItemZoneCostCache:no need update");
    }

    private ItemZoneCostCacheItem getItemMap(ConcurrentMap<Integer, ItemZoneCostCacheItem> map, int itemId) {
        ItemZoneCostCacheItem itemMap = (ItemZoneCostCacheItem)map.get(itemId);
        if (itemMap == null) {
            ItemZoneCostCacheItem newItemMap = new ItemZoneCostCacheItem();
            itemMap = map.putIfAbsent(itemId, newItemMap);
            if (itemMap == null) {
                itemMap = newItemMap;
            }
        }
        return itemMap;
    }

    private void load(Connection con, int moduleId, int loginId, Calendar time) {
        this.logger.debug("ItemZoneCostCache:load...");
        long start = System.currentTimeMillis();
        try {
            ItemZoneCostCacheItem itemMap = this.getItemMap(this.dataMap, loginId);
            ItemZoneCostCacheItem itemMapInput = this.getItemMap(this.dataMapInput, loginId);
            ItemZoneCostCacheItem itemMapOutput = this.getItemMap(this.dataMapOutput, loginId);
            String tableName = ServerUtils.getModuleMonthTableName("log_session", time.getTime(), moduleId);
            if (ServerUtils.tableExists(con, tableName)) {
                String query = "SELECT zone, SUM(fake_cost), type FROM " + tableName + " WHERE lid=? GROUP BY zone, type";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, loginId);
                ResultSet rs = ps.executeQuery();
                itemMap.clear();
                itemMapInput.clear();
                itemMapOutput.clear();
                while (rs.next()) {
                    int zoneId = rs.getInt(1);
                    BigDecimal amount = rs.getBigDecimal(2);
                    int type = rs.getInt(3);
                    itemMap.add(zoneId, amount);
                    if (type == 2) {
                        itemMapInput.add(zoneId, amount);
                        continue;
                    }
                    if (type != 1) continue;
                    itemMapOutput.add(zoneId, amount);
                }
                rs.close();
                ps.close();
                itemMap.loadTime = time.getTimeInMillis();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ItemZoneCostCache:itemMap=>" + itemMap.toString());
                    this.logger.debug("ItemZoneCostCache:itemMapInput=>" + itemMapInput.toString());
                    this.logger.debug("ItemZoneCostCache:itemMapOutput=>" + itemMapOutput.toString());
                    this.logger.debug("ItemZoneCostCache:load...Ok");
                }
            }
            long duration = System.currentTimeMillis() - start;
            this.logger.debug("ItemZoneTrafficCache:load... " + duration + " ms");
        }
        catch (Exception e) {
            this.logger.debug("ItemZoneCostCache:load...ERROR");
            e.printStackTrace();
        }
    }

    class ItemZoneCostCacheItem {
        long loadTime;
        final Map<Integer, CostAmount> zoneMap = new HashMap<Integer, CostAmount>(4);

        ItemZoneCostCacheItem() {
        }

        public void add(Integer zoneId, BigDecimal amount) {
            CostAmount costAmount = this.zoneMap.get(zoneId);
            if (costAmount == null) {
                this.zoneMap.put(zoneId, new CostAmount(amount));
            } else {
                costAmount.amount = costAmount.amount.add(amount);
            }
        }

        public String toString() {
            if (ItemZoneCostCache.this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("loadTime" + this.loadTime);
                for (Integer key : this.zoneMap.keySet()) {
                    sb.append(", " + key + "=>" + this.zoneMap.get((Object)key).amount.toString());
                }
                return sb.toString();
            }
            return super.toString();
        }

        public void clear() {
            this.zoneMap.clear();
        }
    }

    class CostAmount {
        BigDecimal amount;

        public CostAmount(BigDecimal amount) {
            this.amount = amount;
        }
    }
}

