/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.common.util;

import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.server.util.Setup;

public class CustomerUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getValue(int contractId, String fieldKey, String defaultValue) {
        try (Connection connection = Setup.getSetup().getDBConnectionFromPool();){
            CustomerDao customerDao = new CustomerDao(connection);
            Optional<CustomerLink> optional = customerDao.getCustomerLink(contractId, LocalDateTime.now());
            if (!optional.isPresent()) return defaultValue;
            String string = customerDao.getCustomerParameter(optional.get().getCustomerId(), fieldKey);
            return string;
        }
        catch (Exception ex) {
            return "ERROR: " + ex.getLocalizedMessage();
        }
    }
}

