/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ContractUtils {
    public static String getCustomerAddress(Connection connection, int moduleId, int contractId) throws BGException {
        ContractModuleConfigDao contractModuleConfigDao;
        String customerAddress = null;
        try {
            contractModuleConfigDao = new ContractModuleConfigDao(connection, moduleId);
            try {
                customerAddress = contractModuleConfigDao.get(contractId, "customerAddress");
            }
            finally {
                contractModuleConfigDao.close();
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        if (Utils.isBlankString((String)customerAddress)) {
            contractModuleConfigDao = new ContractModuleConfigDao(connection, 0);
            try {
                customerAddress = contractModuleConfigDao.get(contractId, "payment.phone");
                if (Utils.isBlankString((String)customerAddress)) {
                    customerAddress = contractModuleConfigDao.get(contractId, "payment.email");
                }
            }
            finally {
                contractModuleConfigDao.close();
            }
        }
        return customerAddress;
    }

    public static String checkPassword(ParameterMap setup, String pswd1, String pswd2) {
        Object error = null;
        int passwordMin = PswdGen.getPasswordLengthMin(setup);
        int passwordMax = PswdGen.getPasswordLengthMax(setup);
        String passwordChars = PswdGen.getPasswordChars(setup);
        if (Utils.isEmptyString((String)pswd1) || pswd1.length() < passwordMin || pswd1.length() > passwordMax) {
            error = "\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + passwordMin + " \u0434\u043e " + passwordMax + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!";
        } else if (!PswdGen.checkChars(pswd1, passwordChars)) {
            error = "\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: " + passwordChars;
        } else if (pswd1 == null || pswd2 == null || pswd2 != null && !pswd1.equals(pswd2)) {
            error = "\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442!";
        }
        return error;
    }

    public static String saveCustomerAddress(Connection connection, int moduleId, int contractId, String customerAddress) throws BGException {
        return ContractUtils.saveX(connection, moduleId, contractId, "customerAddress", customerAddress);
    }

    public static String saveCustomerEmail(Connection connection, int moduleId, int contractId, String customerEmail) throws BGException {
        return ContractUtils.saveX(connection, moduleId, contractId, "customerEmail", customerEmail);
    }

    public static String savePaymentEmail(Connection connection, int moduleId, int contractId, String paymentEmail) throws BGException {
        return ContractUtils.saveX(connection, moduleId, contractId, "payment.email", paymentEmail);
    }

    public static String savePaymentPhone(Connection connection, int moduleId, int contractId, String paymentPhone) throws BGException {
        return ContractUtils.saveX(connection, moduleId, contractId, "payment.phone", paymentPhone);
    }

    public static String saveX(Connection connection, int moduleId, int contractId, String key, String value) throws BGException {
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(connection, moduleId);){
            if (value == null) {
                contractModuleConfigDao.delete(contractId, key);
            } else {
                contractModuleConfigDao.update(contractId, key, value);
            }
        }
        return value;
    }

    public static String getPaymentEmail(Connection connection, int moduleId, int contractId, String key) throws BGException {
        return ContractUtils.getX(connection, moduleId, contractId, "payment.email");
    }

    public static String getPaymentPhone(Connection connection, int moduleId, int contractId, String key) throws BGException {
        return ContractUtils.getX(connection, moduleId, contractId, "payment.phone");
    }

    public static String getX(Connection connection, int moduleId, int contractId, String key) throws BGException {
        String value = null;
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(connection, moduleId);){
            value = contractModuleConfigDao.get(contractId, key);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return value;
    }
}

