/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.common;

import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class CachedDirectory<K extends Id> {
    private final AtomicInteger loaded = new AtomicInteger(10);
    private final AtomicLong version;
    protected volatile CopyOnWriteArrayList<K> list;
    protected final ConcurrentMap<Integer, K> preloadIdMap = new ConcurrentHashMap<Integer, K>();
    protected volatile ConcurrentMap<Integer, K> idMap;
    protected volatile ConcurrentMap<String, K> titleMap;

    public CachedDirectory(AtomicLong version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version.get();
    }

    public K get(Directory<K> service, Integer id) throws BGException {
        ConcurrentMap<Integer, K> idMap = this.idMap;
        if (idMap != null) {
            return (K)((Id)idMap.get(id));
        }
        Object result = (Id)this.preloadIdMap.get(id);
        if (result != null) {
            return (K)result;
        }
        CopyOnWriteArrayList<K> list = this.list;
        if (list != null || this.loaded.decrementAndGet() < 0) {
            return this.loadAndGet(service, list, id);
        }
        try {
            result = service.get(id);
            if (result != null) {
                this.preloadIdMap.put(id, (Integer)result);
            }
        }
        catch (UnsupportedOperationException ex) {
            return this.loadAndGet(service, list, id);
        }
        return (K)result;
    }

    private synchronized K loadAndGet(Directory<K> service, List<K> list, int id) throws BGException {
        if (list == null) {
            this.list = new CopyOnWriteArrayList<K>(service.list());
            list = this.list;
        }
        ConcurrentHashMap<Integer, Integer> idMap = new ConcurrentHashMap<Integer, Integer>(list.size() + 10);
        if (list instanceof RandomAccess) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Id k = (Id)list.get(i);
                idMap.put(k.getId(), (Integer)k);
            }
        } else {
            for (Id k : list) {
                idMap.put(k.getId(), (Integer)k);
            }
        }
        this.idMap = idMap;
        return (K)((Id)idMap.get(id));
    }

    public K get(Directory<K> service, String title) {
        ConcurrentMap<String, String> titleMap = this.titleMap;
        if (titleMap == null) {
            titleMap = new ConcurrentHashMap<String, K>(this.list.size() + 10);
            CopyOnWriteArrayList<K> list = this.list;
            if (list instanceof RandomAccess) {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    Id k = (Id)list.get(i);
                    titleMap.put(((IdTitle)k).getTitle(), (String)k);
                }
            } else {
                for (Id k : list) {
                    titleMap.put(((IdTitle)k).getTitle(), (String)k);
                }
            }
            this.titleMap = titleMap;
        }
        return (K)((Id)titleMap.get(title));
    }

    public List<K> list(Directory<K> service) throws BGException {
        CopyOnWriteArrayList<K> list = this.list;
        if (list == null) {
            list = this.list = new CopyOnWriteArrayList<K>(service.list());
        }
        return list;
    }

    public synchronized int delete(Directory<K> service, int id) throws BGException {
        ConcurrentMap<Integer, K> idMap;
        int result = service.delete(id);
        CopyOnWriteArrayList<K> list = this.list;
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Id k = (Id)list.get(i);
                if (k.getId() != id) continue;
                list.remove(i);
                ConcurrentMap<String, K> titleMap = this.titleMap;
                if (titleMap == null || titleMap.remove(((IdTitle)k).getTitle(), k)) break;
                titleMap.values().remove(k);
                break;
            }
        }
        if ((idMap = this.idMap) != null) {
            idMap.remove(id);
        } else {
            this.preloadIdMap.remove(id);
        }
        this.version.incrementAndGet();
        return result;
    }

    public synchronized void update(Directory<K> service, K u) throws BGException {
        ConcurrentMap<Integer, Integer> idMap;
        service.update(u);
        CopyOnWriteArrayList<K> list = this.list;
        if (list != null) {
            int id = u.getId();
            boolean add = true;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Id k = (Id)list.get(i);
                if (k.getId() != id) continue;
                list.set(i, u);
                ConcurrentMap<String, String> titleMap = this.titleMap;
                if (titleMap != null) {
                    if (!titleMap.remove(((IdTitle)k).getTitle(), k)) {
                        titleMap.values().remove(k);
                    }
                    titleMap.put(((IdTitle)u).getTitle(), (String)u);
                }
                add = false;
                break;
            }
            if (add) {
                list.add(u);
                ConcurrentMap<String, String> titleMap = this.titleMap;
                if (titleMap != null) {
                    titleMap.put(((IdTitle)u).getTitle(), (String)u);
                }
            }
        }
        if ((idMap = this.idMap) != null) {
            idMap.put(u.getId(), (Integer)u);
        } else {
            this.preloadIdMap.put(u.getId(), (Integer)u);
        }
        this.version.incrementAndGet();
    }
}

