/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.installer.library;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.installer.event.GetLibrariesInfoEvent;
import ru.bitel.bgbilling.server.installer.event.GetLibraryEvent;
import ru.bitel.bgbilling.server.installer.library.LibraryUpdate;

public class LibraryEventListener {
    private static final Logger log = LogManager.getLogger();

    public LibraryEventListener() throws Exception {
        EventProcessor eventProcessor = EventProcessor.getInstance();
        eventProcessor.addListener(new EventListener<GetLibrariesInfoEvent>(){

            @Override
            public void notify(GetLibrariesInfoEvent e, EventListenerContext ctx) throws BGException {
                try {
                    e.setLibList(LibraryUpdate.getLibrariesInfo());
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }, GetLibrariesInfoEvent.class);
        eventProcessor.addListener(new EventListener<GetLibraryEvent>(){

            @Override
            public void notify(GetLibraryEvent e, EventListenerContext ctx) throws BGException {
                try {
                    e.setData(LibraryUpdate.getLibraryData(e.getLibName()));
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }, GetLibraryEvent.class);
    }
}

