/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrInt;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrIntDao
extends EntityAttrDefaultDao<EntityAttrInt> {
    public EntityAttrIntDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String intTable) {
        super(con, entityAttrDao, intTable);
    }

    @Override
    protected void createTable() {
        try (Statement createStatement = this.con.createStatement();){
            createStatement.execute("CREATE TABLE IF NOT EXISTS `" + this.table + "` ( `entityId` int(11) NOT NULL DEFAULT 0, `entitySpecAttrId` int(11) NOT NULL DEFAULT 0, `value` int(11) NOT NULL DEFAULT 0, PRIMARY KEY (`entityId`,`entitySpecAttrId`) )");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public EntityAttrInt get(int entityId, int attrSpecId) throws SQLException {
        PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        EntityAttrInt result = rs.next() ? new EntityAttrInt(entityId, attrSpecId, rs.getInt(1)) : null;
        rs.close();
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setInt(3, ((EntityAttrInt)a).getValue());
            ps.executeUpdate();
        }
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrInt attr) throws SQLException {
        boolean update = false;
        try (PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());){
            ps.setInt(1, attr.getValue());
            update = ps.executeUpdate() == 0;
        }
        if (update) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setInt(3, attr.getValue());
                ps.executeUpdate();
                boolean bl = true;
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        int oldValue = 0;
        try (PreparedStatement ps = this.entityAttrDao.getSelectOldValuePS();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                oldValue = rs.getInt(1);
            }
        }
        return attr.getValue() != oldValue;
    }

    @Override
    protected void insertHistory(int cid, EntityAttrInt attr) throws SQLException {
        PreparedStatement ps = this.getInsertHistiryPS();
        ps.setInt(1, cid);
        ps.setInt(2, attr.getEntitySpecAttrId());
        ps.setInt(3, attr != null ? Integer.valueOf(attr.getValue()) : null);
        ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
        ps.setInt(5, this.entityAttrDao.userId);
        ps.executeUpdate();
    }
}

