/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action.web;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.license.common.bean.OrderType;
import ru.bitel.bgbilling.modules.license.server.action.web.ActionOrders;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;

public class ActionDeleteOrder
extends ActionOrders {
    private LicenseManager licenseManager = null;
    private String errorText = null;

    @Override
    public void doAction() throws BGException {
        this.licenseManager = new LicenseManager(this.con, this.moduleId);
        int selectedCopyId = this.req.getInt("copy", -1);
        if (this.check()) {
            int ordersCount = this.req.getInt("ordersCount", -1);
            for (int i = 1; i <= ordersCount; ++i) {
                int id = this.req.getInt("chbx_" + i, -1);
                if (id <= 0) continue;
                this.licenseManager.deleteOrder(id);
            }
        } else {
            this.context.getRequest().setAttribute("error", (Object)this.errorText);
        }
        super.doAction();
        this.context.getRequest().setAttribute("action", (Object)"Orders");
    }

    private boolean check() throws BGException {
        int ordersCount = this.req.getInt("ordersCount", -1);
        boolean haveNonSign = this.licenseManager.checkHaveNonSignAdditionalAgreement(this.req.getInt("copyId", -1));
        for (int i = 1; i <= ordersCount; ++i) {
            int id = this.req.getInt("chbx_" + i, -1);
            if (id <= 0) continue;
            if (this.licenseManager.getOrderStatus(id) != 0) {
                this.errorText = "\u0423\u0434\u0430\u043b\u044f\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043d\u043e\u0432\u044b\u0439\".";
                return false;
            }
            if (!haveNonSign || this.licenseManager.getOrderType(id) != OrderType.BUY.getCode()) continue;
            this.errorText = "\u0423 \u0432\u0430\u0441 \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u043d\u0435\u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0435 \u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435, \u0435\u0441\u043b\u0438 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0435\u0433\u043e \u0441\u043e\u0441\u0442\u0430\u0432, \u043f\u043e\u043f\u0440\u043e\u0441\u0438\u0442\u0435 \u043d\u0430\u0441 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c( \u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d \u0441\u0447\u0435\u0442 \u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 )";
            return false;
        }
        return true;
    }
}

